set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8527538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-11-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '3213344',
      3.982898,
      1.727627,
      5,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      ' 5-20-1975',
      26.245599,
      NULL,
      NULL,
      NULL,
      6,
      ' 9- 0-1990',
      NULL,
      NULL,
      275.054311,
      23,
      1,
      '11- 5-1995',
      ' 9-25-1999',
      ' 5- 8-1978',
      0.861705,
      2.283765,
      2,
      0.118734,
      1,
      0,
      NULL,
      1.767355,
      NULL,
      NULL,
      NULL,
      10.599469,
      5,
      122,
      44,
      1,
      18.613265,
      1,
      4,
      2.074451,
      0,
      1,
      0,
      5,
      NULL,
      1.863256,
      NULL,
      1.572869,
      1,
      NULL,
      0,
      5,
      NULL,
      4,
      1,
      2,
      2,
      1,
      0,
      0,
      1,
      4,
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      1,
      0,
      0,
      2,
      1.320440,
      NULL,
      NULL,
      0,
      0,
      1,
      4,
      0,
      NULL,
      3,
      0,
      NULL,
      1,
      1.811194,
      0.822005,
      2.757350,
      0,
      1.993980,
      1,
      1.455988,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      3.416695,
      NULL,
      2,
      NULL,
      1.309949,
      NULL,
      NULL,
      1.613685,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      4,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      1,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0.947797,
      2,
      1,
      1,
      NULL,
      3,
      3,
      3,
      NULL,
      NULL,
      2,
      1,
      3,
      0,
      NULL,
      0,
      0,
      1,
      5,
      1,
      5,
      0,
      4,
      0,
      NULL,
      0,
      0.570852,
      1.760478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.304214,
      3.053962,
      1,
      5,
      0,
      1.272035,
      1,
      2.793440,
      4.219990,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.043868,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      10.490478,
      NULL,
      0,
      2,
      1,
      4.039345,
      '10-12-1982',
      2,
      NULL,
      4,
      0.515113,
      2,
      2.165143,
      0.043577,
      0.471514,
      1.244439,
      NULL,
      0,
      0,
      0.859265,
      0,
      13,
      NULL,
      0.237589,
      NULL,
      NULL,
      NULL,
      3,
      0.326002,
      0.205008,
      2,
      1,
      3,
      3,
      NULL,
      NULL,
      3,
      2,
      3,
      1,
      0.227586,
      1,
      7,
      1.531623,
      1,
      0.066674,
      1.360908,
      1,
      0,
      1.468060,
      0.506677,
      0.708853,
      2.639482,
      NULL,
      NULL,
      NULL,
      NULL,
      5.045959,
      2.722265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      50,
      45,
      76.923214,
      4,
      1,
      NULL,
      '14013',
      '',
      NULL,
      0,
      '31343',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.899705,
      NULL,
      1562.360925,
      NULL,
      1.546982,
      NULL,
      NULL,
      NULL,
      NULL,
      1.277436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.347682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.452701,
      NULL,
      NULL,
      1.994595,
      NULL,
      2.581589,
      1.565738,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.986613,
      NULL,
      NULL,
      1.203827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.854359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.801123,
      NULL,
      NULL,
      1.465252,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.289993,
      NULL,
      NULL,
      0.567684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.204857,
      NULL,
      NULL,
      1.470442,
      NULL,
      NULL,
      0.306848,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.909609,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.955126,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.969881,
      1.357793,
      0.387470,
      NULL,
      NULL,
      4.172012,
      0,
      1,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.016771,
      0,
      1,
      0.373226,
      1,
      3,
      0.177360,
      NULL,
      8,
      1.878986,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.061804,
      NULL,
      3,
      3,
      2.569169,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1.828676,
      0.285018,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.589065,
      0,
      0.830945,
      1,
      1.141812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.193610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.720241,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.505832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.743339,
      NULL,
      NULL,
      NULL,
      1.265452,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.605912,
      NULL,
      NULL,
      NULL,
      0.563567,
      NULL,
      NULL,
      NULL,
      2.583962,
      NULL,
      NULL,
      NULL,
      0.768375,
      NULL,
      NULL,
      NULL,
      0.022609,
      NULL,
      NULL,
      NULL,
      2.360818,
      NULL,
      NULL,
      NULL,
      2.712967,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.940230,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      1.771877,
      0,
      NULL,
      NULL,
      NULL,
      1.840318,
      NULL,
      NULL,
      0.448722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.039048,
      NULL,
      NULL,
      0.381250,
      NULL,
      1,
      9535.188358,
      268.494808,
      1.006067,
      NULL,
      1.656462,
      NULL,
      1.811115,
      1,
      NULL,
      0.891330,
      NULL,
      NULL,
      1,
      1.941854,
      NULL,
      1,
      0,
      NULL,
      0.359326,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.845958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.986178,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245822,
      1.934203,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.029584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.152747,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.340214,
      0.641908,
      1.276363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      6,
      1.247113,
      2.947604,
      2,
      0.462459,
      0,
      NULL,
      0,
      NULL,
      3.295460,
      1,
      0,
      NULL,
      2.835810,
      2,
      2.758663,
      2,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.898978,
      NULL,
      NULL,
      0,
      1.025399,
      3,
      2,
      NULL,
      2.732749,
      1.777637,
      3.966870,
      NULL,
      0,
      1,
      3.074626,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.898139,
      3,
      0.946328,
      NULL,
      2,
      2.857818,
      3,
      0.479724,
      1.089830,
      3.979520,
      NULL,
      NULL,
      1,
      2,
      1.021494,
      1.961464,
      0,
      0,
      1.803563,
      2,
      3.836184,
      NULL,
      0.678566,
      NULL,
      3.536797,
      1.433690,
      1.580684,
      42,
      NULL,
      NULL,
      1.432076,
      0,
      NULL,
      NULL,
      1.137215,
      1.299847,
      1,
      NULL,
      1,
      0,
      3,
      1,
      21,
      NULL,
      1,
      1.906378,
      4.256377,
      '34112',
      '12030',
      '',
      2,
      '42000',
      '',
      '',
      0.953708,
      NULL,
      '',
      '');
commit;
end;
/


