set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8527538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '3030142',
      2,
      0,
      1,
      1,
      '4400',
      0,
      1,
      NULL,
      NULL,
      ' 4-22-1980',
      37.711955,
      NULL,
      1,
      1,
      1,
      ' 6-25-1994',
      30.612182,
      0.495563,
      130.726605,
      123.702895,
      0,
      NULL,
      '11-18-1982',
      ' 8-15-1995',
      2.499248,
      1,
      3.892771,
      NULL,
      NULL,
      0.452033,
      NULL,
      NULL,
      1,
      56.395755,
      0,
      18.858531,
      2.225659,
      164,
      NULL,
      1,
      7.099543,
      3,
      2,
      5.471720,
      1.372947,
      0,
      1,
      2.598108,
      0,
      1,
      1,
      0.918074,
      0.524529,
      0.380774,
      1.215447,
      4,
      3,
      3,
      NULL,
      0,
      2,
      1,
      5,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.760821,
      NULL,
      NULL,
      5,
      3,
      0,
      1,
      1.340339,
      NULL,
      1,
      0.673956,
      1,
      NULL,
      0.400265,
      NULL,
      1,
      0.377565,
      1.044248,
      1.433633,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      5,
      3,
      1,
      0.149085,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      4,
      1,
      2,
      3,
      0,
      0,
      0,
      0,
      0,
      5,
      NULL,
      2,
      1,
      2,
      4,
      5,
      1,
      NULL,
      1,
      4,
      NULL,
      3,
      2.280416,
      2.360419,
      ' 8-29-1999',
      197,
      ' 2-11-2001',
      2.844855,
      1.129854,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1,
      5,
      1,
      0.010426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      2.323051,
      NULL,
      2,
      5,
      4,
      NULL,
      NULL,
      2.274227,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314209,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.003278,
      1,
      0.667126,
      1.814770,
      0,
      NULL,
      0,
      1.799235,
      14.561061,
      1.578238,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912519,
      2,
      2,
      2,
      1,
      3,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      2,
      1.345299,
      3.475257,
      7.425120,
      1,
      1,
      0.474026,
      0,
      0.621564,
      0,
      1,
      NULL,
      4.004002,
      0,
      0,
      3,
      1.535410,
      1.675533,
      0.149179,
      1,
      5.115991,
      4.475590,
      1.617204,
      7,
      1,
      3.592176,
      NULL,
      7,
      0,
      1.585168,
      0.185437,
      30,
      1,
      3.522252,
      NULL,
      40,
      60,
      78.078705,
      4,
      0,
      0.693400,
      '24124',
      '',
      '',
      2.525395,
      NULL,
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      3.285048,
      18.691945,
      238.776919,
      19.183820,
      0.393423,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.980217,
      NULL,
      1,
      3,
      0,
      1.769086,
      0.055679,
      NULL,
      NULL,
      NULL,
      2,
      0.654749,
      0.946594,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.809172,
      NULL,
      NULL,
      3.499050,
      5,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      2,
      1.635114,
      1,
      NULL,
      NULL,
      1.826730,
      NULL,
      NULL,
      3.583455,
      1,
      1.824172,
      0.054505,
      1,
      0,
      1.506443,
      NULL,
      0.258214,
      NULL,
      1.273622,
      NULL,
      0.622945,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.271103,
      0,
      0,
      NULL,
      NULL,
      3,
      1,
      0.677303,
      NULL,
      NULL,
      NULL,
      3.678617,
      1.374989,
      1.839198,
      NULL,
      1.606751,
      NULL,
      NULL,
      1.337485,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.189975,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.225800,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.753195,
      NULL,
      NULL,
      2.741300,
      2.828078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.530545,
      3.723747,
      4.923632,
      0,
      4.842827,
      1,
      NULL,
      NULL,
      1.260948,
      NULL,
      NULL,
      NULL,
      3,
      0.918114,
      NULL,
      2.568463,
      1.583195,
      1.096584,
      7,
      9.186936,
      0.761955,
      1,
      1.693104,
      NULL,
      0,
      3,
      3.437329,
      NULL,
      2,
      1,
      0.870739,
      2,
      10.763001,
      4.831486,
      0,
      NULL,
      1.870210,
      0,
      0,
      3,
      4,
      NULL,
      1.922382,
      NULL,
      1,
      0.481201,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.255471,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.943460,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.411382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.672192,
      2.252982,
      NULL,
      3,
      2.643805,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.242141,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.119188,
      0.716851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.830318,
      1,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1.654067,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.278674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.847713,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.105365,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.549814,
      NULL,
      0,
      NULL,
      730.435702,
      0,
      3.133439,
      1,
      1.706967,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      0,
      0.054668,
      1.360313,
      NULL,
      0.189025,
      0.609273,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.372423,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.732792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.457364,
      0.775334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.908599,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.068484,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.033082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.208898,
      0.836344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.141699,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.087998,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      14,
      0.094339,
      6.208685,
      5,
      3,
      18.688295,
      NULL,
      0.649377,
      NULL,
      0,
      2.363231,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.019514,
      0.831856,
      NULL,
      2,
      1.879385,
      NULL,
      NULL,
      1.929378,
      NULL,
      3.491300,
      1,
      NULL,
      0.813321,
      NULL,
      NULL,
      0,
      1.543907,
      NULL,
      NULL,
      0.900931,
      NULL,
      NULL,
      1.850760,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.641611,
      NULL,
      NULL,
      2.243511,
      NULL,
      3,
      NULL,
      3.881993,
      NULL,
      1,
      NULL,
      0.366730,
      NULL,
      1,
      NULL,
      2.463685,
      NULL,
      0.079693,
      NULL,
      1.928096,
      NULL,
      2.523880,
      NULL,
      1.399693,
      NULL,
      0.988512,
      NULL,
      NULL,
      1.669737,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.701603,
      NULL,
      0,
      4,
      6,
      NULL,
      NULL,
      0,
      23,
      54,
      5,
      1,
      3.126854,
      NULL,
      '41312',
      '',
      1.035819,
      '21311',
      '',
      '',
      0.482677,
      '',
      '',
      '');
commit;
end;
/


