set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8527538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '0210241',
      2,
      1.142094,
      3,
      NULL,
      '3402',
      3,
      1.273065,
      NULL,
      NULL,
      ' 7-19-1980',
      41,
      NULL,
      NULL,
      0.352962,
      3,
      ' 1-14-1991',
      18.283983,
      1.997275,
      NULL,
      NULL,
      NULL,
      ' 6-29-1980',
      ' 3-18-1987',
      ' 2-15-1977',
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.819339,
      1.782496,
      57.881380,
      2,
      NULL,
      6,
      NULL,
      137,
      1,
      16,
      3,
      0,
      NULL,
      1.982889,
      1,
      0,
      2.019863,
      0,
      NULL,
      1,
      0,
      0.952709,
      0,
      1.596706,
      1,
      2,
      2,
      1.020853,
      5,
      0,
      0,
      1,
      1,
      1,
      5,
      1,
      1,
      0,
      1,
      NULL,
      1.376281,
      3,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      1.306907,
      2,
      2,
      1,
      3,
      1.884056,
      0,
      1.826017,
      0.675119,
      2,
      NULL,
      1.123612,
      2,
      0,
      0.495304,
      NULL,
      1,
      1,
      1,
      1.829325,
      0,
      0.423933,
      0,
      NULL,
      5,
      5.184313,
      0,
      NULL,
      1.557589,
      1.119109,
      NULL,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      0,
      0,
      0,
      0,
      NULL,
      2,
      NULL,
      2.868226,
      NULL,
      1,
      NULL,
      1,
      0.814530,
      NULL,
      0.990934,
      2,
      0,
      0,
      0,
      2,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      4,
      2,
      NULL,
      1,
      1,
      NULL,
      3,
      5,
      1,
      NULL,
      4,
      3,
      3,
      3,
      7,
      1,
      ' 6-22-1986',
      628.956037,
      '10-20-1981',
      0,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      4,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      3.796580,
      2,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      8.651478,
      4,
      1.264475,
      4,
      8,
      2.044757,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      2.671218,
      2,
      5,
      NULL,
      NULL,
      NULL,
      4,
      ' 5-16-2003',
      NULL,
      1.027371,
      1,
      0.373701,
      1.133348,
      0,
      0.903892,
      1,
      1,
      0.116731,
      0,
      2,
      7.492030,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      3,
      3,
      1,
      0,
      3,
      3,
      NULL,
      3,
      0,
      2.822918,
      2,
      2,
      4,
      1,
      1,
      5.572182,
      0.394995,
      0.899927,
      1.194533,
      1.794474,
      NULL,
      NULL,
      0.579382,
      0.672182,
      2,
      NULL,
      1.550551,
      NULL,
      0.756183,
      2,
      3.742926,
      2,
      NULL,
      1,
      4.897219,
      2,
      2.400734,
      2.698471,
      3.656050,
      1.792253,
      46,
      3,
      3,
      NULL,
      67,
      48,
      47.471510,
      4,
      1,
      NULL,
      '01131',
      NULL,
      '',
      1.004802,
      '34310',
      NULL,
      NULL,
      1.063368,
      '',
      '',
      '',
      2,
      10.153172,
      69.087546,
      64,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368875,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.457690,
      NULL,
      NULL,
      0.100159,
      3,
      0.585535,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      2.948892,
      NULL,
      0,
      0.657682,
      NULL,
      NULL,
      2,
      0,
      0.749999,
      0.050636,
      NULL,
      NULL,
      1.356225,
      NULL,
      NULL,
      0.067790,
      NULL,
      NULL,
      NULL,
      0.968605,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.573556,
      1.889346,
      3.668835,
      0.855967,
      3.066750,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      0.203136,
      NULL,
      1,
      1.281700,
      2.149918,
      NULL,
      0,
      0.219435,
      NULL,
      1,
      NULL,
      0.450016,
      0,
      1,
      1.286309,
      NULL,
      NULL,
      1.935088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.357326,
      2.123771,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.455351,
      1,
      1,
      2,
      0.913565,
      NULL,
      NULL,
      1.457979,
      NULL,
      NULL,
      1.501421,
      NULL,
      NULL,
      0.875435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.302403,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566646,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.040865,
      NULL,
      NULL,
      1.352638,
      NULL,
      NULL,
      1.828401,
      NULL,
      NULL,
      NULL,
      NULL,
      5.200263,
      NULL,
      NULL,
      4.659694,
      0,
      NULL,
      NULL,
      1.786773,
      NULL,
      1,
      3,
      NULL,
      0.067776,
      0.918560,
      0,
      1,
      1.181658,
      5,
      5,
      2,
      1,
      NULL,
      NULL,
      1.389985,
      3.826364,
      1,
      0,
      2,
      3,
      0.159941,
      NULL,
      3,
      NULL,
      3.404189,
      3.659143,
      NULL,
      4,
      1,
      4,
      0,
      0,
      1,
      1,
      NULL,
      0.256427,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3.556640,
      0.277831,
      0.766010,
      1,
      0.022883,
      2.617544,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.729499,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.132014,
      NULL,
      NULL,
      NULL,
      1.244364,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.073633,
      NULL,
      NULL,
      NULL,
      0.154883,
      NULL,
      NULL,
      NULL,
      2.998173,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0.145913,
      NULL,
      NULL,
      NULL,
      0.964779,
      NULL,
      NULL,
      0.518749,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.452296,
      2,
      1252.200061,
      NULL,
      NULL,
      NULL,
      1.794250,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2624.008328,
      961,
      1.388488,
      1,
      1.445455,
      0.312693,
      0.638836,
      0,
      NULL,
      1.642412,
      0.672822,
      0.311208,
      1,
      0.676651,
      1,
      1.239961,
      1.570445,
      0.210344,
      0,
      NULL,
      NULL,
      0.512625,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.356290,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.992231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012918,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.156315,
      NULL,
      0.422891,
      NULL,
      0.915421,
      NULL,
      1,
      1.507426,
      0.217273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.944731,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.662328,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.926526,
      NULL,
      0.255419,
      NULL,
      0.767770,
      1.683157,
      0.716038,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      8,
      NULL,
      NULL,
      4.520879,
      1,
      NULL,
      NULL,
      1,
      1,
      3.204511,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.130723,
      NULL,
      NULL,
      0.395028,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.925972,
      NULL,
      NULL,
      0,
      1,
      1.303715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.713680,
      0.841346,
      NULL,
      2.984792,
      NULL,
      1.927939,
      NULL,
      0,
      NULL,
      2,
      NULL,
      3,
      NULL,
      1.765898,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.867219,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      179,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464698,
      NULL,
      0.691962,
      NULL,
      1,
      0,
      3,
      NULL,
      1.972880,
      1.986293,
      NULL,
      105.523292,
      5,
      0.438202,
      4,
      '31403',
      NULL,
      '',
      2,
      '13240',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


