set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9430524';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '0313401',
      1,
      1.797663,
      NULL,
      NULL,
      '1300',
      3.980157,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3,
      NULL,
      20,
      0,
      298,
      22.038099,
      2,
      ' 3- 5-1978',
      '10- 8-1992',
      ' 1- 0-2000',
      0.156828,
      NULL,
      2.835317,
      1.450736,
      0,
      1.036783,
      0,
      2,
      NULL,
      NULL,
      NULL,
      11,
      5.445168,
      16.502907,
      25.079437,
      4,
      4,
      1,
      2,
      0,
      1,
      NULL,
      1,
      1,
      0.899105,
      NULL,
      NULL,
      0.872445,
      1,
      3,
      0.189392,
      3,
      3,
      5,
      NULL,
      4,
      1,
      0,
      1,
      1,
      1,
      3,
      2,
      3,
      0,
      NULL,
      0,
      5,
      0,
      2,
      2,
      NULL,
      3.034762,
      0,
      1,
      1.585344,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      1.438311,
      1,
      1.515233,
      1,
      0.710612,
      3,
      1,
      0.609958,
      0.434127,
      NULL,
      0,
      NULL,
      0,
      1,
      4,
      4,
      1,
      0,
      NULL,
      0,
      NULL,
      1.094784,
      3.359409,
      0.004185,
      NULL,
      NULL,
      1,
      5,
      1,
      1,
      0,
      0,
      5,
      1,
      0,
      4,
      0,
      1,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      1,
      5,
      0,
      NULL,
      2,
      3,
      2,
      4,
      5,
      1,
      NULL,
      NULL,
      0,
      2,
      0,
      4,
      0,
      1,
      NULL,
      1,
      1,
      2,
      0,
      1.054438,
      2,
      '11- 9-1978',
      4.175024,
      ' 8-15-1984',
      0.955197,
      NULL,
      0,
      1,
      1,
      5,
      NULL,
      2,
      1,
      NULL,
      0,
      1,
      5,
      4,
      3,
      5,
      3,
      3,
      6,
      2,
      11.384827,
      2.610969,
      ' 4-26-2002',
      4,
      '10-23-2003',
      2.414573,
      1.263057,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.157436,
      NULL,
      1.236415,
      1.088667,
      0,
      1,
      0,
      0.320048,
      2.488085,
      NULL,
      3,
      2,
      1.422891,
      0,
      2,
      1.100538,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.725183,
      1,
      NULL,
      1.191568,
      0.366468,
      0,
      0.609223,
      10.950866,
      NULL,
      0.884803,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3,
      3,
      3,
      0,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      2,
      1.812228,
      2.783168,
      NULL,
      2.846313,
      NULL,
      NULL,
      2,
      1.413604,
      1,
      NULL,
      NULL,
      0.679941,
      1,
      NULL,
      0.919769,
      1,
      1.726671,
      2,
      1,
      2.046968,
      0.715039,
      NULL,
      NULL,
      4,
      0.602740,
      3.054022,
      0.972693,
      7,
      1,
      2.630761,
      NULL,
      1.950387,
      NULL,
      1.705719,
      NULL,
      57,
      68,
      75.471199,
      3,
      4,
      2.553514,
      '41102',
      '',
      '',
      1.136890,
      '',
      '',
      '',
      1.475251,
      '',
      '',
      '',
      1.937995,
      8,
      11.385799,
      34.211126,
      0.705995,
      31,
      NULL,
      5,
      0,
      0.691712,
      2.443203,
      1.951622,
      1.861150,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.286181,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.993448,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971692,
      NULL,
      3.859048,
      NULL,
      0,
      1,
      3.551155,
      0.665560,
      1.194870,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.803620,
      NULL,
      NULL,
      0.573742,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820639,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.619641,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.496151,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1.977981,
      0.831423,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.908134,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      0.207600,
      3.218863,
      NULL,
      1,
      2,
      NULL,
      NULL,
      3,
      1.193383,
      1,
      NULL,
      3,
      0.501614,
      1.279975,
      2,
      0.624493,
      3.891713,
      1,
      2,
      1.701919,
      0.843372,
      1,
      0,
      NULL,
      NULL,
      0,
      1.106648,
      NULL,
      1.000794,
      NULL,
      NULL,
      5,
      5.522972,
      0,
      NULL,
      4,
      2.324827,
      0,
      NULL,
      NULL,
      0.766923,
      3,
      1,
      1.726002,
      0,
      0.925824,
      NULL,
      5,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.431725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.525325,
      NULL,
      NULL,
      1.984610,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.086501,
      3,
      NULL,
      2,
      0,
      0.890219,
      1.220209,
      1,
      5.066390,
      NULL,
      NULL,
      NULL,
      1.865199,
      NULL,
      NULL,
      NULL,
      1.747894,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.581007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.354726,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.072162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.256968,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      6,
      0,
      3.314171,
      24.826661,
      1.026429,
      2,
      1,
      1.553747,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.293698,
      3.974690,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      31,
      1.711964,
      NULL,
      0,
      1,
      0,
      0,
      1.030254,
      1.444898,
      1.837917,
      0.685586,
      NULL,
      1,
      NULL,
      0.940916,
      0,
      1.545953,
      0.384908,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.052129,
      1.564788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.110852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.015794,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.820274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.360325,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.547881,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.906491,
      1,
      0.119089,
      0,
      NULL,
      1.096852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1.707273,
      0,
      NULL,
      1,
      0.984182,
      1,
      1,
      1.917707,
      NULL,
      1.150927,
      NULL,
      NULL,
      1.740257,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.215781,
      0.260952,
      NULL,
      2,
      2.677864,
      NULL,
      0.092750,
      NULL,
      NULL,
      0.603921,
      3.492640,
      NULL,
      1.890908,
      1.212991,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.170866,
      NULL,
      1,
      0,
      NULL,
      0.662754,
      NULL,
      NULL,
      37.612102,
      50.715717,
      3,
      2.521573,
      2.328132,
      NULL,
      '33232',
      NULL,
      1.001042,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


