set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9976000';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      1.850715,
      1,
      2,
      3.272429,
      0.937809,
      NULL,
      NULL,
      NULL,
      '13301012',
      59.336210,
      63.206953,
      '4241032',
      3,
      1,
      1,
      NULL,
      '2200',
      1,
      0,
      NULL,
      NULL,
      ' 2-10-2002',
      182,
      257,
      NULL,
      1,
      0.092777,
      ' 4-12-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.891910,
      1.050323,
      1.917698,
      0.055711,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.446079,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1,
      NULL,
      0,
      1.621777,
      1.145832,
      1,
      1.902987,
      1,
      1,
      0,
      0.731779,
      2,
      1,
      5,
      2.110085,
      2,
      NULL,
      1,
      0,
      1,
      2,
      NULL,
      1,
      3,
      2,
      5,
      5,
      4.746618,
      1,
      2,
      2,
      NULL,
      0.172532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.814874,
      NULL,
      0.463346,
      0,
      0.896973,
      1,
      1,
      1,
      1.418658,
      0.320503,
      3.443696,
      0,
      0.701306,
      0.140129,
      2.537785,
      0,
      3,
      NULL,
      1,
      5,
      0.325104,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      4,
      1,
      4,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      2,
      1,
      4.961200,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.201317,
      0,
      1,
      1,
      1,
      1,
      NULL,
      4,
      5,
      NULL,
      3,
      0,
      1,
      3,
      0,
      NULL,
      1,
      3,
      2,
      5,
      3,
      0,
      0,
      3,
      4,
      NULL,
      NULL,
      2.292066,
      '10- 3-2001',
      172,
      ' 8-14-1984',
      NULL,
      1.294875,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      5,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.145826,
      1.845860,
      NULL,
      1.345271,
      NULL,
      NULL,
      1,
      NULL,
      2.370936,
      0,
      6.883737,
      1,
      NULL,
      NULL,
      NULL,
      1.215309,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.016800,
      1,
      1,
      1.696196,
      1.544794,
      NULL,
      1.756865,
      31,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3.543630,
      2,
      3,
      NULL,
      3,
      2,
      3,
      NULL,
      NULL,
      0,
      0,
      1.159592,
      3,
      2.721917,
      1,
      1.463922,
      1.684383,
      1,
      NULL,
      1,
      0.021629,
      0.236155,
      1.810622,
      0.628029,
      1,
      1.265382,
      0,
      1.134377,
      2.352718,
      NULL,
      5.130156,
      4.360896,
      4,
      2,
      4,
      1,
      4.715303,
      3.095639,
      4,
      NULL,
      1.464789,
      NULL,
      14,
      NULL,
      NULL,
      10,
      NULL,
      36,
      34,
      3,
      2.374524,
      NULL,
      '04423',
      '14000',
      '',
      NULL,
      '',
      '',
      NULL,
      1.307379,
      '',
      '',
      '',
      2,
      NULL,
      0.810152,
      7,
      0.312271,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0.256422,
      NULL,
      NULL,
      1.292827,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.102064,
      NULL,
      NULL,
      2.712841,
      0.764358,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.724761,
      2.725422,
      0.391058,
      1,
      3,
      NULL,
      0,
      2.674119,
      NULL,
      NULL,
      3.752945,
      0.743974,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.763983,
      0.382094,
      2,
      NULL,
      NULL,
      2.943902,
      2,
      1.215232,
      3,
      2,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.194152,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.467576,
      NULL,
      NULL,
      NULL,
      0.544776,
      NULL,
      NULL,
      2.927665,
      0.547010,
      NULL,
      NULL,
      1.877592,
      1,
      0.984576,
      NULL,
      NULL,
      3.264655,
      0,
      0,
      NULL,
      0.638029,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.702756,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.405423,
      NULL,
      NULL,
      7,
      1.276521,
      0.219735,
      0,
      NULL,
      NULL,
      0.640157,
      2.258769,
      0.787453,
      2.292965,
      3.943746,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.634322,
      1,
      NULL,
      2,
      1.488955,
      2.421095,
      3.185345,
      1,
      1.783429,
      1.645578,
      2,
      0.294456,
      1.938796,
      NULL,
      4,
      2.496071,
      4.883470,
      1.885884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.382422,
      1.127170,
      0.985955,
      0.418342,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.853580,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.989222,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1.009015,
      2.163517,
      1.664887,
      0.556866,
      0,
      NULL,
      NULL,
      NULL,
      0.651572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.624676,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.712531,
      NULL,
      NULL,
      NULL,
      2.109354,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.810061,
      NULL,
      NULL,
      NULL,
      0.455910,
      NULL,
      2,
      NULL,
      0.423799,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.511365,
      NULL,
      NULL,
      NULL,
      1.726794,
      NULL,
      0.590122,
      NULL,
      0,
      NULL,
      1.206011,
      NULL,
      0.853380,
      NULL,
      1.956723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.489110,
      NULL,
      1,
      NULL,
      1.236162,
      NULL,
      3.648181,
      NULL,
      0,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.538847,
      0.538427,
      12.186349,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      45,
      3.383174,
      0.069907,
      0.354297,
      0.532015,
      1,
      NULL,
      1.302226,
      1.949932,
      0.346916,
      0,
      0,
      1,
      0,
      0.407152,
      1.637406,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.328783,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.590704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.687406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.196727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318116,
      NULL,
      NULL,
      NULL,
      NULL,
      67,
      NULL,
      NULL,
      NULL,
      2.941135,
      NULL,
      3.728373,
      NULL,
      NULL,
      0.432348,
      31,
      NULL,
      2,
      1,
      0.951029,
      0.935722,
      2,
      NULL,
      NULL,
      3.181396,
      NULL,
      3,
      3,
      1,
      0.142941,
      1.690405,
      2.567992,
      3.027726,
      0.354137,
      0,
      NULL,
      0.330482,
      0.682217,
      1,
      0.435672,
      0.990548,
      1.137109,
      0,
      1,
      0.307628,
      1.189428,
      0,
      1.606290,
      0.226755,
      NULL,
      1.460229,
      1.184329,
      NULL,
      1.969625,
      1.522313,
      2.075897,
      3,
      1.467169,
      NULL,
      NULL,
      1.553647,
      NULL,
      3,
      NULL,
      1.631877,
      1.296547,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.127855,
      1.698707,
      1.116389,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      114,
      65,
      2,
      0.375960,
      3,
      '02212',
      '33031',
      NULL,
      1.704306,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


