set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9420968';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '1230030',
      3.675688,
      0,
      4,
      1,
      '4100',
      3.487338,
      1,
      NULL,
      NULL,
      ' 5-17-1974',
      62.189434,
      NULL,
      4,
      2,
      0,
      NULL,
      NULL,
      NULL,
      337.399027,
      159.913684,
      3,
      NULL,
      NULL,
      ' 9- 1-1974',
      NULL,
      2,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.721301,
      3,
      NULL,
      30.234662,
      3,
      14,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0.616147,
      NULL,
      1,
      1.327131,
      NULL,
      0,
      1,
      2,
      0.951029,
      3,
      NULL,
      0,
      0,
      0,
      0,
      3,
      1,
      1,
      0,
      1,
      0,
      NULL,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1.519130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.288557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      2,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0,
      2,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      2,
      0,
      1,
      2,
      1,
      NULL,
      0,
      NULL,
      2,
      3,
      NULL,
      5,
      4,
      4,
      NULL,
      1,
      4,
      2,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      ' 5-17-1985',
      NULL,
      ' 0- 2-1987',
      55.589414,
      1,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      32.599259,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.717372,
      NULL,
      NULL,
      NULL,
      4.908768,
      NULL,
      1,
      0.520220,
      NULL,
      NULL,
      1,
      5,
      1.660929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.511508,
      NULL,
      0,
      3.536412,
      3.559496,
      0.257887,
      1,
      2,
      62,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      1,
      3,
      1,
      3.484275,
      2,
      2.867176,
      1,
      1,
      NULL,
      3.500355,
      0.624154,
      0.112957,
      1.425610,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1.843768,
      1,
      1,
      7,
      3,
      3,
      6,
      NULL,
      4.209400,
      2.247297,
      0,
      7.565515,
      3,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      46,
      8,
      10.854947,
      NULL,
      1.680642,
      3,
      '43112',
      '',
      '',
      1,
      '',
      '',
      '',
      0.591589,
      NULL,
      '',
      NULL,
      0.694845,
      30,
      10.233352,
      NULL,
      0,
      65,
      3.995828,
      1,
      1,
      1,
      0,
      NULL,
      1.838969,
      NULL,
      NULL,
      1.444935,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3.636996,
      3.443344,
      1.098786,
      NULL,
      NULL,
      0.472536,
      NULL,
      NULL,
      0.206379,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.877377,
      7.508028,
      7.075733,
      0,
      0.263901,
      NULL,
      NULL,
      NULL,
      1.977733,
      NULL,
      NULL,
      NULL,
      0.399142,
      NULL,
      NULL,
      0.308778,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.673539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.612706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.236396,
      NULL,
      NULL,
      3,
      2.299106,
      2,
      0,
      NULL,
      NULL,
      0.744544,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2.738152,
      NULL,
      NULL,
      NULL,
      NULL,
      1.917027,
      2.863215,
      3,
      0.075337,
      NULL,
      NULL,
      1.498848,
      NULL,
      NULL,
      0.227787,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.115097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.195070,
      0,
      0.201386,
      NULL,
      1,
      1,
      4,
      NULL,
      NULL,
      NULL,
      2,
      2.371409,
      1,
      1,
      2.332639,
      0.340428,
      0.052272,
      2,
      NULL,
      0,
      NULL,
      4,
      1,
      1.841632,
      0,
      0.349029,
      NULL,
      1,
      1.363080,
      1,
      2,
      1.019916,
      0.783242,
      3,
      9.153039,
      9,
      3,
      2.535400,
      NULL,
      NULL,
      2.074317,
      2,
      4,
      NULL,
      0.267873,
      1,
      0,
      1,
      2.558926,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.284656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.231420,
      NULL,
      NULL,
      0.929467,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.157390,
      NULL,
      NULL,
      1.012735,
      NULL,
      NULL,
      NULL,
      1,
      1.778888,
      0,
      1.933155,
      0.011545,
      0.606764,
      NULL,
      NULL,
      5.267739,
      NULL,
      NULL,
      NULL,
      57,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.228226,
      NULL,
      NULL,
      NULL,
      1.379602,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.419482,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.760929,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.932428,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.915458,
      NULL,
      NULL,
      NULL,
      0.548502,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.702505,
      NULL,
      NULL,
      NULL,
      NULL,
      8.113476,
      6.199457,
      0,
      NULL,
      2.369721,
      1.438980,
      NULL,
      NULL,
      0.442899,
      1.695401,
      2,
      1.064284,
      0,
      0.283505,
      NULL,
      NULL,
      NULL,
      1.740706,
      NULL,
      1,
      422.663169,
      1,
      NULL,
      1.919417,
      0,
      1.174571,
      NULL,
      1,
      1,
      0.097222,
      0.801400,
      NULL,
      1.658741,
      0,
      1,
      1,
      0,
      0,
      NULL,
      1.748465,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3,
      7.358488,
      NULL,
      5,
      1,
      NULL,
      10,
      1.022500,
      3,
      0,
      1.565510,
      1,
      NULL,
      0.086841,
      NULL,
      NULL,
      2.943975,
      0,
      NULL,
      NULL,
      1.280169,
      NULL,
      2,
      1.445256,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.733823,
      3,
      NULL,
      NULL,
      0.095738,
      NULL,
      0,
      NULL,
      NULL,
      3.705114,
      3,
      NULL,
      NULL,
      0.171904,
      1.646353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      6,
      5,
      0,
      NULL,
      NULL,
      5.368474,
      4,
      0,
      5.177973,
      0.289109,
      '01402',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


