set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9016374';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '4320343',
      2.406853,
      1,
      2,
      NULL,
      NULL,
      3.748053,
      0.231359,
      NULL,
      NULL,
      ' 6- 3-1982',
      64,
      NULL,
      3,
      NULL,
      1.940665,
      ' 5-27-1983',
      30,
      5.794049,
      311,
      0,
      NULL,
      ' 8-29-1986',
      '10-19-2003',
      ' 7-12-1978',
      2,
      2,
      0,
      0.087800,
      0,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      9,
      1,
      5,
      1.964007,
      3,
      1,
      5,
      3,
      2.149414,
      0,
      1,
      0,
      0.829681,
      1,
      NULL,
      0,
      NULL,
      1.670894,
      NULL,
      0.449172,
      2,
      NULL,
      NULL,
      1.184962,
      4,
      NULL,
      NULL,
      0,
      1,
      0,
      4,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.307044,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0,
      4,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      4,
      1,
      1,
      3,
      1,
      0,
      1,
      0,
      0,
      2,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      NULL,
      3,
      1,
      NULL,
      0.920032,
      ' 6-12-1988',
      0.783172,
      NULL,
      3.110642,
      1.400431,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      5,
      0,
      1,
      0,
      0,
      0,
      0,
      NULL,
      2.417068,
      NULL,
      2,
      NULL,
      23.587659,
      ' 5- 3-1982',
      21,
      0,
      0,
      0,
      1,
      NULL,
      16.492807,
      NULL,
      1,
      4,
      2.281125,
      3.422167,
      0.346659,
      NULL,
      NULL,
      2,
      1,
      0.806811,
      NULL,
      0,
      3.768551,
      0,
      NULL,
      6,
      3.207536,
      2,
      3,
      1.349977,
      NULL,
      NULL,
      NULL,
      0,
      4.449711,
      3.827474,
      1,
      2,
      2,
      4.338127,
      '10- 8-1999',
      NULL,
      '11-28-1983',
      1,
      1.028616,
      0,
      0.889244,
      NULL,
      0,
      0,
      0,
      2,
      0.697107,
      1.173553,
      1,
      29.826140,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.626505,
      3.577081,
      NULL,
      2,
      2,
      3,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      2,
      0.838676,
      0.265413,
      1.295144,
      1,
      6,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.624305,
      2.454384,
      1,
      0.294273,
      4.102782,
      1,
      3.997954,
      5.396453,
      1.218064,
      4.768828,
      NULL,
      0.640548,
      3,
      NULL,
      2,
      24.457561,
      NULL,
      0,
      NULL,
      61,
      NULL,
      NULL,
      1,
      1.868312,
      3.308547,
      '41110',
      '',
      '',
      0,
      '',
      '',
      '',
      0.668359,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.677173,
      NULL,
      1.725747,
      3.706614,
      0.423982,
      0,
      0,
      NULL,
      NULL,
      2.169906,
      0,
      879,
      2.266061,
      1.824108,
      937.315115,
      0.214803,
      NULL,
      NULL,
      1.297332,
      NULL,
      1.090271,
      150,
      1,
      NULL,
      NULL,
      1.186442,
      0.657839,
      NULL,
      0,
      0.465128,
      NULL,
      1.165879,
      1,
      0.157306,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      2.926645,
      NULL,
      0.410139,
      NULL,
      1,
      NULL,
      1.253996,
      NULL,
      0.374759,
      NULL,
      1,
      NULL,
      0.213277,
      NULL,
      0.040087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      2.693271,
      2,
      NULL,
      3.517241,
      1,
      3,
      0.463672,
      0.381289,
      NULL,
      0.255275,
      1.331973,
      NULL,
      1,
      0.696361,
      NULL,
      0.705292,
      1.283284,
      NULL,
      0.097708,
      NULL,
      NULL,
      NULL,
      1.002982,
      NULL,
      0.392321,
      0,
      NULL,
      0,
      0.419007,
      NULL,
      1,
      NULL,
      NULL,
      1.095934,
      1,
      NULL,
      1,
      0.338279,
      NULL,
      0.073440,
      1.674520,
      NULL,
      3.431614,
      1,
      1.893351,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.592602,
      NULL,
      1.028148,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.294762,
      NULL,
      NULL,
      NULL,
      3.628734,
      NULL,
      3,
      NULL,
      3.491670,
      NULL,
      3.581827,
      NULL,
      1,
      NULL,
      2.470882,
      NULL,
      1,
      NULL,
      1,
      0.343727,
      1,
      1.392055,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      3,
      0,
      1,
      NULL,
      NULL,
      141,
      NULL,
      3,
      1,
      2.460623,
      '10444',
      '',
      NULL,
      1.978273,
      '',
      '',
      '',
      1.174394,
      NULL,
      '',
      NULL);
commit;
end;
/


