set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9016374';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-10-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      NULL,
      NULL,
      '2443444',
      2.959819,
      0,
      1,
      NULL,
      '0323',
      0.489101,
      NULL,
      NULL,
      NULL,
      ' 6- 4-1983',
      20,
      NULL,
      4,
      1,
      5,
      '10- 4-1996',
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      ' 2- 3-1978',
      ' 4-13-1988',
      NULL,
      3,
      2.040537,
      3,
      0,
      NULL,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      1,
      10,
      1,
      16,
      2,
      12.521756,
      0,
      0,
      6,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.086003,
      1,
      1.459333,
      1,
      NULL,
      NULL,
      3,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3,
      1,
      1,
      0,
      1,
      0,
      0,
      5.610504,
      1,
      NULL,
      0,
      0,
      1.948632,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.337829,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      2,
      0,
      NULL,
      1,
      0,
      1.362706,
      NULL,
      0,
      2,
      1,
      0,
      2,
      NULL,
      1,
      0,
      0,
      2,
      1,
      2,
      NULL,
      2,
      1,
      0,
      3,
      5,
      4,
      4,
      3,
      5,
      3,
      3,
      0,
      0,
      7,
      3,
      '11- 7-1983',
      2,
      '10-13-1978',
      2,
      1,
      NULL,
      0,
      0,
      3,
      NULL,
      5,
      1,
      0,
      0,
      1,
      2,
      NULL,
      1,
      3,
      1,
      NULL,
      3,
      1.213184,
      NULL,
      0.706264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1.309233,
      0.668570,
      3,
      2.776955,
      2.327779,
      0.989247,
      1.631571,
      4,
      5,
      0.411978,
      2,
      NULL,
      1,
      3.927626,
      NULL,
      0,
      4,
      NULL,
      4,
      4.844798,
      1.215116,
      NULL,
      NULL,
      NULL,
      2,
      11,
      3,
      1,
      2,
      2,
      4,
      ' 9- 7-1996',
      1,
      ' 0-16-1992',
      6,
      1,
      1,
      1.489674,
      3,
      2,
      0.850057,
      0,
      0,
      0.702538,
      1.945078,
      1,
      19.833861,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.161082,
      2.538790,
      3,
      NULL,
      3,
      NULL,
      2,
      2,
      1,
      3,
      1,
      3,
      0,
      2.419493,
      3,
      54.669875,
      25.167344,
      NULL,
      4,
      0,
      1.316553,
      1,
      1,
      1.689914,
      0.872254,
      1.087457,
      0,
      NULL,
      1,
      3,
      1.947755,
      NULL,
      1,
      6,
      9,
      2,
      2,
      0,
      1.787823,
      2.921228,
      0.149936,
      0.848236,
      NULL,
      61.926609,
      3,
      3,
      NULL,
      15,
      58,
      74,
      1,
      NULL,
      1,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.441618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.096524,
      0.529148,
      1,
      NULL,
      0.560039,
      0,
      0.469926,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      73,
      0.681122,
      NULL,
      0,
      NULL,
      0.300618,
      NULL,
      0.471385,
      NULL,
      1,
      1.268887,
      NULL,
      NULL,
      1,
      NULL,
      0.042875,
      0.415938,
      1,
      0,
      NULL,
      NULL,
      1.498036,
      NULL,
      0.818121,
      NULL,
      NULL,
      NULL,
      0.810687,
      NULL,
      0.132535,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      0,
      3.149664,
      3,
      6.762155,
      3,
      0.407108,
      1.192079,
      1,
      0,
      NULL,
      0.517650,
      1.375091,
      NULL,
      NULL,
      1.584582,
      NULL,
      1,
      0,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2.787889,
      NULL,
      0.641415,
      0,
      NULL,
      1.380009,
      NULL,
      NULL,
      0,
      0.048423,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      1,
      1.366427,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.318654,
      1.152006,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1.428601,
      NULL,
      NULL,
      NULL,
      0.658273,
      NULL,
      NULL,
      NULL,
      1.895471,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      12,
      1,
      1.853354,
      0,
      NULL,
      NULL,
      NULL,
      0.142870,
      NULL,
      1,
      NULL,
      6,
      1.211132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.975529,
      1,
      NULL,
      '',
      NULL,
      1.733213,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


