set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9629037';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36.048708,
      11,
      '0030101',
      NULL,
      0.035669,
      2,
      3,
      '4243',
      3.899814,
      1.317448,
      NULL,
      NULL,
      ' 8-12-2001',
      2,
      170.013139,
      NULL,
      1,
      0.333339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 5-12-1978',
      NULL,
      NULL,
      1,
      2.255268,
      2,
      1.733613,
      1,
      3,
      1,
      1.662106,
      NULL,
      3.551353,
      4,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      6,
      0,
      3,
      0,
      3,
      1,
      2,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0,
      3.534316,
      NULL,
      1,
      1,
      0,
      1.140262,
      NULL,
      NULL,
      0.950852,
      NULL,
      NULL,
      2,
      0,
      3,
      3.396252,
      1,
      0,
      NULL,
      1,
      1.897206,
      3.606967,
      3.272336,
      3,
      NULL,
      NULL,
      0.803335,
      2.357125,
      NULL,
      0,
      0.593165,
      NULL,
      2,
      2,
      10,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      1,
      NULL,
      1.592548,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      4,
      2,
      1,
      2,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      4,
      3,
      4,
      1,
      NULL,
      ' 7-25-2001',
      330,
      NULL,
      272,
      0.496423,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.220565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.374951,
      0.715585,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.083784,
      0,
      2.910490,
      1,
      0,
      0.565225,
      2.255061,
      NULL,
      7.035590,
      NULL,
      5,
      0.497812,
      NULL,
      NULL,
      1.977552,
      7,
      1.800279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.261847,
      1,
      NULL,
      0,
      1,
      0,
      1,
      27.641312,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      2,
      2,
      NULL,
      1,
      2,
      3,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      2.815995,
      1.265492,
      1,
      1.496317,
      0.076161,
      1,
      0.578512,
      1,
      0,
      0,
      0.560231,
      NULL,
      0.662793,
      0,
      2.528131,
      0.082847,
      NULL,
      6,
      4,
      NULL,
      8,
      9.291458,
      1,
      NULL,
      3.500247,
      NULL,
      2,
      0.876151,
      3.475524,
      38.766620,
      2,
      2.844701,
      12,
      NULL,
      NULL,
      23.492677,
      1,
      2,
      1,
      '13112',
      '14103',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      2.833861,
      5.108561,
      1.379352,
      NULL,
      NULL,
      17,
      3.215805,
      4.391209,
      4,
      1,
      NULL,
      NULL,
      1.736694,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.530135,
      1,
      NULL,
      NULL,
      0.552435,
      NULL,
      NULL,
      0.242788,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      8,
      5.349042,
      3.547877,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.350655,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3,
      1.361375,
      2.339417,
      1.007017,
      NULL,
      NULL,
      2,
      1.762234,
      2.779058,
      3.523830,
      3.778219,
      1,
      0,
      0.895024,
      2,
      NULL,
      NULL,
      0,
      NULL,
      3.145867,
      3.605993,
      2,
      3.299497,
      0.176326,
      1.107174,
      0.199712,
      NULL,
      NULL,
      2,
      0.422447,
      NULL,
      1,
      4,
      9,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      2.810066,
      NULL,
      NULL,
      NULL,
      0,
      3.820119,
      1,
      3.905047,
      0,
      0.396711,
      1,
      NULL,
      NULL,
      3.854976,
      5,
      0.252567,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.385364,
      NULL,
      NULL,
      0.831741,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.614680,
      NULL,
      NULL,
      0.697469,
      NULL,
      NULL,
      1.802314,
      NULL,
      NULL,
      0.365938,
      NULL,
      NULL,
      5,
      5.638927,
      3.639639,
      0.198166,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.713469,
      1,
      NULL,
      NULL,
      NULL,
      7,
      0.205406,
      1.481876,
      0.289588,
      3.442841,
      1.763442,
      3,
      NULL,
      0.611944,
      2.457903,
      0.621778,
      2,
      1.802610,
      1.272796,
      1.621511,
      7.238325,
      NULL,
      4.481921,
      4,
      3,
      4.189540,
      NULL,
      3,
      0,
      0.071067,
      1,
      NULL,
      0,
      1,
      0.447518,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.455311,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.154025,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.831334,
      NULL,
      NULL,
      1.933235,
      NULL,
      NULL,
      0,
      NULL,
      1.338338,
      NULL,
      1.579589,
      3.576357,
      0,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      2.073115,
      NULL,
      NULL,
      NULL,
      2.700924,
      NULL,
      NULL,
      NULL,
      0.447720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.613993,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.408680,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.091474,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.479178,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.839995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      13,
      NULL,
      0,
      1.579527,
      1,
      0.154932,
      NULL,
      NULL,
      2,
      4.793694,
      8,
      1,
      NULL,
      NULL,
      1.918923,
      NULL,
      NULL,
      0.220488,
      NULL,
      0,
      290.237679,
      20.442699,
      0,
      1,
      0,
      3.531833,
      1.087999,
      3,
      1.881770,
      1,
      1.460258,
      NULL,
      0,
      2.343115,
      0.467557,
      0.731714,
      NULL,
      0.086734,
      1,
      3.068360,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      88.941887,
      NULL,
      NULL,
      12,
      6.261014,
      1.877849,
      1.299213,
      1,
      NULL,
      0,
      NULL,
      0.967278,
      NULL,
      0.903614,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1.967103,
      NULL,
      2,
      NULL,
      1.848385,
      NULL,
      1.719943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.449021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.287016,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.568079,
      0.652378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399505,
      2,
      NULL,
      0.918234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.875226,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      1.637547,
      2,
      5.541533,
      2,
      0.463636,
      0,
      1.255612,
      1,
      NULL,
      NULL,
      1.977644,
      NULL,
      1.295394,
      2.590880,
      NULL,
      0,
      2,
      NULL,
      1,
      2.884920,
      NULL,
      NULL,
      1.381440,
      NULL,
      1,
      3.331001,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.474956,
      NULL,
      1.045434,
      1,
      NULL,
      1,
      0.674410,
      0.399507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.011040,
      1.670005,
      NULL,
      1.556571,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.713842,
      NULL,
      1,
      NULL,
      0.917444,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      NULL,
      7.339510,
      2,
      NULL,
      0,
      NULL,
      3.803963,
      NULL,
      0.633071,
      NULL,
      NULL,
      5,
      2,
      1,
      NULL,
      3,
      27,
      54,
      4,
      0.394256,
      NULL,
      '31303',
      '12210',
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


