set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9665591';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '41',
      '20',
      1,
      10,
      '1222203',
      2,
      NULL,
      2,
      3,
      '2231',
      4,
      0,
      NULL,
      NULL,
      NULL,
      32,
      49,
      NULL,
      3.885471,
      4,
      ' 4-29-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 7-24-1999',
      '11- 7-1997',
      NULL,
      NULL,
      3,
      3,
      1,
      1.332449,
      1,
      0,
      0,
      0.789874,
      66.582034,
      3,
      10.301829,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.580771,
      NULL,
      0,
      1.361786,
      NULL,
      NULL,
      1.672204,
      0,
      1,
      1,
      0.827598,
      NULL,
      4,
      5,
      1.702290,
      3,
      1,
      0,
      1,
      1,
      0,
      5,
      1,
      3,
      3,
      0,
      0,
      1,
      0,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      1,
      1,
      1.857396,
      NULL,
      0.918178,
      0.818135,
      1.491673,
      0,
      2.960657,
      2,
      1.972963,
      NULL,
      0.069875,
      NULL,
      2,
      1,
      2,
      3,
      4.158574,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0.582135,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      0.740812,
      0,
      0,
      0,
      0,
      1.378364,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      4,
      5,
      1,
      NULL,
      NULL,
      4,
      0,
      4,
      2,
      3,
      2,
      3,
      4,
      NULL,
      2,
      5,
      1,
      4,
      2,
      5,
      NULL,
      0.543572,
      '11- 2-1986',
      NULL,
      ' 1-19-1982',
      11,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      1,
      0.125302,
      0.003403,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.507665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.785322,
      NULL,
      0.593100,
      1,
      1,
      1.855310,
      98,
      1.455606,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      3,
      2,
      1,
      NULL,
      3,
      NULL,
      0,
      1,
      1,
      1,
      3,
      NULL,
      5.660094,
      NULL,
      1.110339,
      0.360097,
      NULL,
      1,
      NULL,
      NULL,
      1.043711,
      1,
      NULL,
      0.994816,
      0,
      NULL,
      NULL,
      0,
      NULL,
      11.283921,
      3,
      0.808744,
      5,
      4,
      4.616817,
      NULL,
      2,
      2,
      0.178422,
      3,
      47,
      3,
      2.952933,
      NULL,
      NULL,
      52,
      26.282761,
      0,
      3,
      NULL,
      '23424',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '',
      NULL,
      '',
      1.479529,
      36.760609,
      81,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2.089117,
      1,
      NULL,
      NULL,
      0.435920,
      NULL,
      NULL,
      0,
      3,
      0.086640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.165774,
      0,
      NULL,
      NULL,
      3,
      3.204442,
      3.198067,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      4,
      1,
      2,
      0.372554,
      NULL,
      NULL,
      NULL,
      1.080399,
      NULL,
      NULL,
      NULL,
      1.628064,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.275413,
      2,
      NULL,
      3.480788,
      2,
      0.690061,
      NULL,
      3,
      0,
      2,
      1.913655,
      0.330629,
      0.430661,
      0.805223,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.326435,
      0.802952,
      1,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.710547,
      NULL,
      NULL,
      1,
      1.824680,
      2.530645,
      1.025484,
      1.819735,
      1.632194,
      1.262467,
      NULL,
      NULL,
      2.458088,
      5.074003,
      5.848154,
      NULL,
      3.484546,
      0.181175,
      1,
      NULL,
      NULL,
      3.678765,
      1.671858,
      4,
      0.899224,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281277,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.249824,
      NULL,
      NULL,
      0.033792,
      NULL,
      0,
      1.292356,
      NULL,
      1,
      1,
      2.631506,
      NULL,
      1.951349,
      2.820780,
      3,
      2.671491,
      4,
      NULL,
      2.480144,
      1.737373,
      NULL,
      2.528757,
      1.683876,
      2,
      2,
      1.164983,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3.512929,
      NULL,
      2.815341,
      3,
      3,
      0,
      2,
      0,
      3,
      2.142354,
      0,
      NULL,
      5.337042,
      0.970871,
      NULL,
      NULL,
      0.461936,
      0,
      NULL,
      NULL,
      NULL,
      0.377736,
      NULL,
      1,
      0.806652,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.387209,
      1.543520,
      1,
      1,
      1.006714,
      0.493490,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.937603,
      NULL,
      NULL,
      NULL,
      3.775236,
      3,
      1.593465,
      3.637310,
      NULL,
      1.613925,
      NULL,
      NULL,
      NULL,
      1.638060,
      NULL,
      NULL,
      0.070020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.733889,
      NULL,
      NULL,
      383.034158,
      15,
      1.080388,
      0,
      0,
      1.619373,
      0.608115,
      0,
      NULL,
      NULL,
      0.307428,
      1.290632,
      0.049557,
      1,
      1,
      NULL,
      0.637251,
      1,
      1.564578,
      0.365085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1.886618,
      1.917984,
      2.095619,
      2,
      1,
      NULL,
      NULL,
      0.298796,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.432341,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.233723,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      2,
      NULL,
      1.004067,
      3,
      NULL,
      1.304403,
      3.697332,
      NULL,
      0,
      1.182931,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422985,
      NULL,
      0.813205,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      39,
      NULL,
      NULL,
      0,
      1,
      '10001',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


