set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000796';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2,
      4.222040,
      0,
      1.693311,
      1.905711,
      NULL,
      0,
      3.135578,
      '444',
      '02412421',
      5.979217,
      46,
      '0130001',
      1.072632,
      0.055780,
      5,
      2,
      NULL,
      5,
      0,
      NULL,
      NULL,
      ' 3-15-1975',
      36.106802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      '10-23-1989',
      0,
      1,
      0,
      0,
      0.449833,
      0.804544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.075577,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0.709252,
      2,
      NULL,
      1,
      3,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      2,
      1,
      0,
      1,
      3,
      NULL,
      5,
      1,
      2,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      6.183997,
      0,
      0,
      1,
      1.222283,
      NULL,
      NULL,
      1.925166,
      1.507832,
      0.149688,
      1,
      3,
      0.859235,
      NULL,
      1,
      1.153346,
      1.651080,
      1,
      0,
      1,
      5,
      1,
      0,
      NULL,
      0.390931,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0.254947,
      4,
      1,
      NULL,
      0,
      1,
      3,
      0,
      4,
      4,
      NULL,
      NULL,
      1,
      5,
      4,
      5,
      4,
      0,
      2,
      NULL,
      0,
      0,
      2,
      2,
      4,
      2,
      NULL,
      3.456264,
      ' 5-12-2002',
      17.891379,
      ' 6- 7-1997',
      125,
      2.091297,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1.818715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.290157,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      6.551554,
      0,
      0.541538,
      7,
      0,
      0,
      NULL,
      NULL,
      1,
      4.353715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.867328,
      0,
      1.047363,
      1,
      1,
      1.713378,
      NULL,
      2.135439,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      0,
      3,
      2,
      NULL,
      3,
      2,
      1,
      1,
      NULL,
      0.514574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.429441,
      NULL,
      1,
      0,
      0.861241,
      0.854479,
      1,
      NULL,
      NULL,
      0.475547,
      6.086830,
      1.825702,
      1.115237,
      5,
      4,
      0,
      3,
      3.622586,
      NULL,
      0.258276,
      1.052353,
      0.816559,
      19.626073,
      3,
      1.377127,
      10,
      NULL,
      NULL,
      NULL,
      5,
      3.518029,
      NULL,
      '32004',
      '4044',
      NULL,
      NULL,
      NULL,
      '',
      '',
      0.758307,
      '',
      '',
      '',
      3,
      28,
      9.048570,
      10.640138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066358,
      1,
      1.964873,
      NULL,
      NULL,
      1.056722,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.219345,
      NULL,
      NULL,
      0.901180,
      NULL,
      NULL,
      1.409563,
      2,
      NULL,
      0,
      NULL,
      NULL,
      0.104754,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.896865,
      0.339480,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1.540983,
      NULL,
      NULL,
      2.018528,
      0.854240,
      3,
      NULL,
      0.732481,
      0,
      NULL,
      0,
      0.571576,
      3,
      NULL,
      1.948931,
      0,
      0.762690,
      1.591017,
      2.388067,
      3.657745,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.540603,
      3.065883,
      6,
      0,
      5.636138,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.726062,
      NULL,
      NULL,
      1,
      2.390790,
      0,
      1,
      1.188925,
      0.683295,
      1,
      NULL,
      NULL,
      1.247610,
      5.464439,
      4.083611,
      1,
      NULL,
      NULL,
      0.495628,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.893001,
      NULL,
      NULL,
      0.152317,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.063671,
      1,
      NULL,
      NULL,
      1,
      2.930451,
      NULL,
      3,
      1,
      1.292765,
      5.284381,
      NULL,
      1,
      1,
      0.639856,
      2,
      0.385271,
      NULL,
      NULL,
      1.853269,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3.676948,
      NULL,
      3.803775,
      0.818493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.979750,
      0,
      1.243889,
      0.074386,
      3,
      2.561045,
      4,
      NULL,
      4,
      0,
      1,
      1,
      1.825868,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.028503,
      NULL,
      NULL,
      0.667078,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.062711,
      1.557260,
      1,
      1.546700,
      1.562793,
      0,
      0.068067,
      NULL,
      NULL,
      0.617999,
      NULL,
      NULL,
      NULL,
      5.249776,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.755876,
      NULL,
      NULL,
      NULL,
      3.901523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.606092,
      NULL,
      NULL,
      NULL,
      1.090364,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.426793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.532635,
      NULL,
      NULL,
      NULL,
      0.871319,
      NULL,
      NULL,
      NULL,
      1.163343,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      1.980150,
      3.933373,
      2,
      NULL,
      2,
      2,
      1.103165,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.395712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.951978,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1.258583,
      NULL,
      NULL,
      0.645616,
      1.511531,
      1.041456,
      1,
      0,
      NULL,
      0.811181,
      0.528714,
      1.160803,
      0,
      NULL,
      0.592844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      2.569451,
      5,
      7.424630,
      4,
      3,
      16.288149,
      2,
      NULL,
      0.685741,
      NULL,
      3,
      NULL,
      1,
      1.971626,
      NULL,
      1.021810,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.564194,
      NULL,
      NULL,
      2.538121,
      NULL,
      NULL,
      NULL,
      0.352795,
      NULL,
      NULL,
      1.761370,
      NULL,
      1.383519,
      NULL,
      NULL,
      0,
      3,
      NULL,
      2.270708,
      3,
      NULL,
      1,
      1.636006,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.771963,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.877948,
      NULL,
      0,
      NULL,
      1.877804,
      NULL,
      4,
      0,
      2,
      1.223843,
      NULL,
      NULL,
      7,
      58.304859,
      0,
      3.557600,
      5.884314,
      '21332',
      '2013',
      NULL,
      0,
      '',
      '',
      '',
      1.375648,
      '',
      '',
      '');
commit;
end;
/


