set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015909';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '40',
      NULL,
      24,
      6,
      '2420241',
      NULL,
      0,
      2,
      0,
      '1021',
      0.619961,
      NULL,
      NULL,
      NULL,
      ' 1-28-1977',
      54,
      5,
      NULL,
      2,
      0,
      ' 3-22-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 7-20-1976',
      ' 9-28-1988',
      0.553215,
      1,
      0,
      NULL,
      3.796680,
      0,
      1,
      3.386521,
      NULL,
      NULL,
      NULL,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      1.023693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      2.988667,
      4,
      0,
      1,
      0,
      1,
      5,
      4,
      0,
      5,
      0,
      NULL,
      1,
      5,
      0,
      2,
      1,
      0,
      0.552172,
      NULL,
      NULL,
      0.689665,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.644457,
      1.774348,
      1.964421,
      2,
      1,
      0.349869,
      3.628863,
      0,
      1.104615,
      1.656417,
      1.776284,
      0,
      0,
      0,
      2.300932,
      3.285121,
      0,
      1,
      3,
      NULL,
      1,
      0,
      3.270228,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      5,
      1,
      1,
      1,
      0,
      1,
      0,
      1,
      0.315676,
      1,
      0,
      1,
      1,
      1.940533,
      NULL,
      1.613234,
      1,
      0,
      1,
      1,
      NULL,
      0,
      4,
      5,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1,
      3,
      NULL,
      3,
      1,
      0,
      NULL,
      5,
      5,
      0,
      1,
      1.756116,
      NULL,
      ' 4-22-1989',
      68.200156,
      NULL,
      9,
      1.165348,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2.965855,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646973,
      1.032959,
      1.790054,
      NULL,
      1.301275,
      0,
      3,
      22,
      NULL,
      0.361595,
      NULL,
      NULL,
      NULL,
      2,
      1,
      3,
      1,
      3,
      0,
      1,
      0,
      3,
      2,
      3,
      NULL,
      3,
      1,
      3.684402,
      3,
      1.555648,
      NULL,
      0.315755,
      1,
      0.583812,
      NULL,
      1,
      0,
      0.300279,
      0,
      NULL,
      0,
      1,
      0,
      2,
      1,
      0,
      6,
      7.498577,
      NULL,
      6.676786,
      2.928655,
      0,
      0,
      NULL,
      2.792787,
      1,
      1,
      NULL,
      0,
      2,
      12,
      NULL,
      31,
      44.414050,
      5,
      4,
      0.184878,
      '00301',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      2,
      31.106910,
      43.602384,
      NULL,
      2.838750,
      4,
      NULL,
      0.481558,
      3,
      3.763664,
      2,
      2.505916,
      1,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0.613565,
      NULL,
      NULL,
      0.112910,
      NULL,
      NULL,
      1.465028,
      NULL,
      1.068196,
      0.276825,
      NULL,
      NULL,
      0.694236,
      NULL,
      NULL,
      1.759055,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.902124,
      NULL,
      NULL,
      1.124429,
      5.606804,
      5.030945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.507369,
      1.778637,
      NULL,
      NULL,
      NULL,
      3.003166,
      NULL,
      NULL,
      2.755585,
      1,
      NULL,
      3.949421,
      1.735287,
      1,
      3.868855,
      2,
      3,
      1.725075,
      3,
      0,
      1,
      2.103994,
      0,
      1.284528,
      2,
      0,
      1.388817,
      0,
      0.033130,
      NULL,
      0,
      3,
      0,
      1.057923,
      0.979428,
      2,
      NULL,
      NULL,
      1.250615,
      NULL,
      NULL,
      NULL,
      1.045198,
      NULL,
      NULL,
      NULL,
      1.446324,
      NULL,
      NULL,
      1.846034,
      NULL,
      NULL,
      1.596841,
      NULL,
      NULL,
      0.908250,
      NULL,
      NULL,
      1.878012,
      NULL,
      NULL,
      0,
      0.459684,
      1,
      1,
      NULL,
      NULL,
      2.701260,
      NULL,
      NULL,
      0.568796,
      NULL,
      NULL,
      0.733254,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.862932,
      NULL,
      NULL,
      0.447951,
      NULL,
      NULL,
      0,
      1.820231,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.543126,
      2.971382,
      NULL,
      NULL,
      NULL,
      1.729195,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0.004300,
      0.824503,
      4.710609,
      7.003116,
      0.296264,
      3.565349,
      NULL,
      0.216292,
      2.865059,
      2.228526,
      0.866633,
      1.591711,
      NULL,
      NULL,
      0.077683,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.919086,
      1.897292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.423274,
      1,
      0,
      0.971461,
      0.547616,
      0,
      1.965233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.482131,
      NULL,
      NULL,
      NULL,
      1,
      12.939763,
      3.071732,
      0,
      3.442911,
      0,
      0.252801,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.854241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      126.884253,
      1,
      1,
      0,
      0.157095,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.832469,
      0,
      1,
      NULL,
      1.877599,
      NULL,
      NULL,
      NULL,
      1.063442,
      3.073550,
      NULL,
      3.636949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      12.806999,
      NULL,
      0,
      26.589435,
      54,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.422156,
      NULL,
      1.744663,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      0.210584,
      3.600575,
      NULL,
      1.794888,
      3,
      NULL,
      3.074606,
      0.637955,
      1,
      1.163860,
      0.004251,
      NULL,
      0,
      1.841421,
      NULL,
      0,
      3.671646,
      NULL,
      0.953017,
      0.806301,
      NULL,
      NULL,
      3.487927,
      NULL,
      0.880297,
      3,
      NULL,
      0.250126,
      2.732404,
      NULL,
      1.555420,
      0,
      NULL,
      NULL,
      0.747072,
      NULL,
      1.042754,
      3,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.529505,
      0.026037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633955,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      2,
      5,
      0.574167,
      NULL,
      NULL,
      11,
      NULL,
      2,
      2.981103,
      4,
      '34134',
      '31224',
      '',
      0,
      '',
      NULL,
      '',
      1.072234,
      '',
      NULL,
      NULL);
commit;
end;
/


