set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8315735';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-5-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      '3143003',
      3.515272,
      1.596593,
      0,
      2,
      NULL,
      1.953126,
      0,
      NULL,
      NULL,
      NULL,
      121.487497,
      NULL,
      3,
      1,
      1.317158,
      '11-10-2003',
      41,
      1,
      312.089939,
      82,
      2,
      ' 4-10-1981',
      ' 8- 5-1984',
      ' 6-16-2001',
      2.825212,
      3.490202,
      3,
      1,
      NULL,
      0,
      3,
      0,
      0,
      5.246333,
      0,
      13.456413,
      1.464574,
      0,
      37,
      4,
      17,
      4,
      NULL,
      5.581306,
      1.280672,
      NULL,
      0,
      NULL,
      1.657065,
      0.589537,
      0.871688,
      2,
      0,
      1.309451,
      1.666223,
      2,
      4,
      5,
      3,
      2,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      1,
      1.129725,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.573653,
      NULL,
      NULL,
      0,
      1,
      0.748931,
      1.405130,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      5,
      NULL,
      0,
      NULL,
      2,
      3,
      1,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      1,
      2,
      NULL,
      1,
      0.264666,
      NULL,
      1.169814,
      NULL,
      0,
      1,
      1,
      NULL,
      3,
      5,
      2,
      4,
      4,
      1,
      NULL,
      NULL,
      1,
      4,
      3,
      0,
      3,
      5,
      1,
      0,
      0,
      2,
      5,
      4,
      NULL,
      NULL,
      ' 7- 5-1985',
      179.032575,
      NULL,
      27,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.949628,
      7,
      4,
      1.366629,
      1,
      1.343549,
      3,
      3.899110,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.467586,
      0,
      0.272425,
      NULL,
      1.208537,
      0,
      0,
      2.358345,
      15,
      1.966092,
      0.976820,
      NULL,
      NULL,
      NULL,
      1,
      0.396188,
      NULL,
      1,
      3,
      0,
      3,
      2,
      NULL,
      1,
      2,
      NULL,
      3,
      5,
      1,
      0.827493,
      0,
      1,
      0.016131,
      3.601984,
      NULL,
      1.021432,
      0.238796,
      0.334839,
      1,
      1.068930,
      1,
      1.031349,
      0,
      0.769835,
      3.401188,
      0,
      1,
      3.617451,
      4,
      1.725835,
      4,
      1,
      1,
      2,
      NULL,
      1.946661,
      NULL,
      1,
      13.747365,
      3,
      NULL,
      NULL,
      0,
      40,
      22,
      4,
      2.487970,
      3.707165,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.221442,
      '',
      '',
      NULL,
      NULL,
      9.028849,
      31,
      1,
      0,
      2,
      1.715549,
      NULL,
      0,
      1.184239,
      0.012424,
      2,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.156950,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.076773,
      NULL,
      NULL,
      0.353302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.353299,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.454437,
      3.896260,
      1.591222,
      3.164883,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.108336,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.612089,
      1.989196,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.629983,
      1.686334,
      1,
      NULL,
      0,
      1,
      0.060901,
      NULL,
      NULL,
      5,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1.980508,
      0.315912,
      0.548452,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.548373,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.413333,
      1.462467,
      2,
      NULL,
      0,
      NULL,
      NULL,
      2,
      1.867604,
      0,
      3.889419,
      1,
      1.079723,
      3,
      0.351073,
      0.858739,
      10.050877,
      1.506895,
      1,
      0.144225,
      3,
      1,
      0.573365,
      1.719833,
      0.349558,
      0,
      0,
      0,
      2,
      0.403411,
      1.096559,
      8,
      NULL,
      2.791540,
      1.710415,
      0,
      1.907441,
      1,
      NULL,
      NULL,
      1,
      1,
      0.506224,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.075666,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.438190,
      0,
      1,
      NULL,
      3.267015,
      1.809526,
      NULL,
      NULL,
      0.512549,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117226,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.908566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.627231,
      3,
      1,
      3,
      0.371180,
      0,
      1.318114,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.058422,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.336440,
      1.598685,
      NULL,
      0,
      0.798195,
      0.178623,
      NULL,
      0.901402,
      0.184281,
      0.992647,
      0.329067,
      0,
      1,
      0,
      0.451710,
      0,
      1,
      1,
      0,
      0.528458,
      1.415798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.027013,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.063132,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.966440,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.549795,
      NULL,
      NULL,
      1.343228,
      0.818094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0.948232,
      2.081943,
      3,
      5.394903,
      1,
      9.273465,
      NULL,
      3,
      0.552074,
      1.666487,
      1.569709,
      NULL,
      1.876805,
      1.456174,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      0,
      NULL,
      3.990808,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      0,
      1,
      NULL,
      1.312282,
      0,
      NULL,
      3,
      1.067645,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.676229,
      NULL,
      1.574993,
      NULL,
      0,
      NULL,
      0,
      5,
      3,
      1,
      NULL,
      NULL,
      56.257776,
      93,
      5,
      1.071407,
      3,
      '33033',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      NULL,
      NULL,
      '');
commit;
end;
/


