set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9531319';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '2324342',
      2,
      0.478139,
      2,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      ' 0-18-1987',
      7.921309,
      NULL,
      4,
      0.023750,
      3.097759,
      NULL,
      NULL,
      5,
      306.208106,
      53,
      1,
      ' 4-14-2003',
      ' 1-19-2002',
      '10-27-1982',
      1.181582,
      2,
      NULL,
      3.817733,
      1,
      3,
      2,
      1.154373,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0.397568,
      NULL,
      4,
      19.434520,
      NULL,
      4,
      5.251587,
      0,
      NULL,
      1,
      1.534523,
      0,
      0.058872,
      NULL,
      NULL,
      0,
      1.181518,
      1.490231,
      1,
      1,
      2,
      3.553263,
      4,
      1,
      1,
      NULL,
      0,
      3,
      NULL,
      3,
      0,
      3,
      0,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.114105,
      NULL,
      NULL,
      1.470734,
      NULL,
      1.191440,
      0.177320,
      2,
      3.674860,
      NULL,
      1,
      2,
      2.298600,
      1.940365,
      2.394134,
      1.115945,
      0.173393,
      0,
      0,
      NULL,
      10,
      1,
      2,
      0,
      1.173767,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      5,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1.629649,
      0,
      0,
      NULL,
      NULL,
      1.644555,
      NULL,
      1,
      1,
      1,
      0,
      2,
      1,
      2,
      NULL,
      1,
      4,
      3,
      0,
      1,
      NULL,
      1,
      NULL,
      2,
      2,
      0,
      NULL,
      5,
      2,
      0,
      5,
      4,
      0,
      6.302949,
      2,
      '10-20-1995',
      109.317073,
      '10-19-1997',
      NULL,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1.153089,
      NULL,
      2,
      5.716195,
      3,
      1,
      NULL,
      1.945660,
      1.738074,
      0.852809,
      0,
      1,
      0,
      0,
      0.039709,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.726640,
      2.067879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1.797084,
      1.015607,
      1.627605,
      3.292709,
      2,
      1,
      1.282966,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2,
      0,
      1,
      0,
      NULL,
      3,
      0,
      3,
      3,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      1.143501,
      2.339206,
      1.516325,
      1,
      1,
      0,
      1,
      0.700435,
      0,
      1.333259,
      NULL,
      NULL,
      1,
      1,
      10.914588,
      NULL,
      1,
      11.282686,
      NULL,
      2,
      1.719905,
      1.079596,
      0,
      NULL,
      0,
      3,
      39.279748,
      3,
      0.994661,
      NULL,
      41,
      NULL,
      11.265935,
      NULL,
      3.621773,
      1,
      NULL,
      '',
      '',
      1,
      '1221',
      '',
      '',
      1.640136,
      NULL,
      '',
      '',
      3,
      26.148448,
      80,
      13,
      3.267923,
      5,
      NULL,
      2,
      5,
      0,
      NULL,
      NULL,
      1.574808,
      NULL,
      NULL,
      0.088817,
      NULL,
      NULL,
      0.321094,
      NULL,
      NULL,
      0.226543,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.587700,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.447575,
      NULL,
      NULL,
      1.232356,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.690447,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      2,
      4.527765,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0.171954,
      1,
      1,
      3.215543,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      0.860756,
      NULL,
      NULL,
      2.978259,
      NULL,
      NULL,
      NULL,
      3.342989,
      1,
      0.060328,
      NULL,
      NULL,
      2.983106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.082787,
      NULL,
      NULL,
      0.830003,
      NULL,
      NULL,
      0.436225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.274920,
      NULL,
      2,
      0.906319,
      NULL,
      NULL,
      0.143590,
      0.472764,
      5,
      3.699457,
      NULL,
      0,
      2.019598,
      NULL,
      NULL,
      0.921809,
      NULL,
      NULL,
      1.849616,
      0.237757,
      2.325823,
      2,
      0.987916,
      1.322824,
      NULL,
      1.893100,
      0.543825,
      NULL,
      3,
      1.577155,
      1,
      3,
      0.195989,
      NULL,
      0.403872,
      1,
      3,
      1.677498,
      NULL,
      3,
      7,
      7,
      2,
      1,
      4,
      0,
      NULL,
      NULL,
      0.417960,
      NULL,
      0,
      1.731622,
      0,
      1.724103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.635288,
      NULL,
      0,
      0.290763,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.809987,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.962499,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.578791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.058249,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.799582,
      NULL,
      NULL,
      NULL,
      0.017423,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      0.491260,
      0,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      3.732865,
      0.114982,
      1.839833,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.449143,
      0,
      0,
      NULL,
      1,
      1,
      1.211805,
      1.541967,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.830395,
      1,
      1.543443,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.571439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      6,
      NULL,
      5.652051,
      1,
      2,
      6,
      NULL,
      NULL,
      NULL,
      1.862589,
      0,
      NULL,
      0.311675,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      2.070177,
      1.626961,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.486250,
      NULL,
      0,
      1,
      NULL,
      1.874577,
      1,
      NULL,
      0.542763,
      0.372915,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119375,
      0,
      NULL,
      2.665229,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.790055,
      NULL,
      NULL,
      NULL,
      0.451490,
      NULL,
      24.828277,
      3.884648,
      NULL,
      0,
      NULL,
      2.693592,
      NULL,
      0,
      NULL,
      0,
      6,
      4,
      NULL,
      NULL,
      NULL,
      80.101770,
      59.609182,
      5,
      4,
      1,
      '41020',
      '',
      '',
      0,
      '3043',
      '',
      '',
      0,
      '',
      NULL,
      '');
commit;
end;
/


