set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6220814';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-6-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      '1111121',
      1,
      1.259582,
      NULL,
      0,
      '3201',
      0.888321,
      0,
      NULL,
      NULL,
      ' 7-16-1984',
      41,
      NULL,
      3,
      2,
      2.060573,
      ' 9-29-1982',
      61,
      1,
      NULL,
      27.453230,
      2,
      NULL,
      NULL,
      ' 7-28-1999',
      3,
      1,
      1.577937,
      3.662434,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.828882,
      6,
      16,
      11.133028,
      2,
      21.388366,
      2,
      2,
      2.922944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1.308188,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      1.512502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.753721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0.558622,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      4,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      1.976645,
      NULL,
      1,
      1,
      NULL,
      0.211447,
      NULL,
      1,
      1,
      3,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      2,
      0,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      3,
      2,
      3,
      1,
      4,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      3,
      2,
      NULL,
      2.498440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      2,
      1,
      0,
      0,
      2,
      1.057025,
      1.958185,
      3,
      0.076167,
      3.278431,
      1.713314,
      2.829287,
      NULL,
      0,
      0.842626,
      0.261212,
      NULL,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.383340,
      3.590235,
      1.405277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.800331,
      0,
      0.652152,
      0.474575,
      NULL,
      NULL,
      2.293383,
      10.618987,
      NULL,
      1.413706,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.137800,
      1,
      NULL,
      2,
      2,
      3,
      NULL,
      1,
      2,
      0,
      3,
      1,
      3.069065,
      2.396997,
      2,
      0,
      1.337951,
      0,
      0.914177,
      1.712013,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3,
      1.759005,
      NULL,
      7,
      5.788648,
      11.198332,
      1,
      4.400431,
      NULL,
      0.899042,
      0.635712,
      NULL,
      0,
      1.845667,
      14.088769,
      NULL,
      1,
      NULL,
      27,
      NULL,
      105.019175,
      1,
      1.254308,
      1,
      '',
      '',
      '',
      NULL,
      '23301',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.015937,
      22,
      58,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.475673,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.523274,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.395053,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.041953,
      NULL,
      NULL,
      0.722201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.665891,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.972194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.094469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.538369,
      NULL,
      NULL,
      1.917885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.210832,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.605752,
      NULL,
      NULL,
      0.645992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.610709,
      NULL,
      NULL,
      1.461036,
      NULL,
      NULL,
      1.793985,
      NULL,
      NULL,
      0.110527,
      NULL,
      NULL,
      0.150936,
      3.234774,
      0.252953,
      0,
      NULL,
      NULL,
      0.687475,
      NULL,
      NULL,
      1.378541,
      NULL,
      0.963436,
      0.064361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.639454,
      NULL,
      NULL,
      2.337006,
      3.568700,
      0.773554,
      1.908573,
      NULL,
      NULL,
      NULL,
      1.964455,
      3,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      3,
      5,
      1.388906,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.307953,
      1,
      1.919414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.391153,
      3.173761,
      NULL,
      0.415520,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.180647,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.151400,
      2,
      0,
      1.642292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.237594,
      NULL,
      NULL,
      1.234571,
      NULL,
      0,
      16.124042,
      NULL,
      1.437159,
      1.246685,
      NULL,
      0.045936,
      NULL,
      1.942459,
      1.941100,
      NULL,
      1.071090,
      0.174621,
      0.677407,
      0,
      1,
      0.381119,
      1,
      1.500072,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.836740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2,
      NULL,
      4,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      1.311722,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.235943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.741908,
      NULL,
      NULL,
      2.978938,
      NULL,
      NULL,
      0.603683,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.369936,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.066941,
      NULL,
      0.892000,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      22.404273,
      0.677894,
      NULL,
      1,
      NULL,
      3.575880,
      NULL,
      0,
      NULL,
      0,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      98.420718,
      3,
      0.886926,
      1,
      '',
      '',
      '',
      NULL,
      '41413',
      '01230',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


