set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8612483';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-7-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '1334234',
      1,
      NULL,
      2,
      0,
      '2300',
      1,
      2,
      1.170066,
      8.415840,
      ' 6-25-1983',
      24.784543,
      NULL,
      4,
      NULL,
      0,
      ' 1-26-2000',
      38.443036,
      0,
      270,
      143.819096,
      1,
      NULL,
      NULL,
      '11-10-1986',
      1,
      0,
      2,
      1.605125,
      NULL,
      0.885214,
      0,
      1.887618,
      NULL,
      NULL,
      NULL,
      3.878964,
      0,
      26.673647,
      NULL,
      2,
      NULL,
      0,
      3,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0.032544,
      0.030474,
      NULL,
      NULL,
      5.080296,
      0.996434,
      1,
      1,
      3,
      1,
      5,
      0,
      NULL,
      2,
      NULL,
      1,
      5,
      0,
      NULL,
      5,
      0,
      1,
      3,
      2,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0.431568,
      NULL,
      NULL,
      5,
      NULL,
      0.326459,
      NULL,
      1,
      0.111956,
      1,
      NULL,
      0.025724,
      2.542860,
      2,
      2.747775,
      0.832484,
      1,
      1.763999,
      NULL,
      2,
      2.877457,
      3,
      NULL,
      5,
      1,
      NULL,
      1,
      2,
      NULL,
      0.655578,
      NULL,
      NULL,
      0.670315,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      1.379617,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      3,
      3,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      4,
      5,
      2,
      5,
      4,
      2,
      NULL,
      4,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      253.238713,
      ' 1- 0-1990',
      267.921322,
      1.850702,
      1,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.476677,
      NULL,
      0.822155,
      4.700479,
      7.673510,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839748,
      3.050806,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.668003,
      1,
      1.664451,
      1.273969,
      NULL,
      1,
      1,
      NULL,
      2.640571,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      1,
      1,
      3,
      NULL,
      NULL,
      2,
      1,
      3,
      0,
      0,
      NULL,
      3,
      2.770713,
      0,
      NULL,
      1.708494,
      1,
      0,
      0.825973,
      1,
      1.547464,
      0,
      0.614527,
      1.786023,
      0,
      NULL,
      2.593724,
      0.938654,
      0.614360,
      7.354349,
      NULL,
      11,
      1,
      NULL,
      5.538717,
      NULL,
      NULL,
      3.432455,
      3,
      3.452947,
      15,
      2,
      0,
      34,
      NULL,
      NULL,
      NULL,
      NULL,
      1.202535,
      3,
      '02344',
      NULL,
      '34242',
      1.419559,
      '',
      '',
      NULL,
      0.902795,
      NULL,
      '',
      '',
      1.787184,
      NULL,
      172.954665,
      0.602291,
      3.079022,
      NULL,
      NULL,
      3,
      2,
      2,
      1.214931,
      NULL,
      0.915337,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.051665,
      1.737122,
      1,
      NULL,
      3.721157,
      0.317172,
      0.982626,
      NULL,
      1.933305,
      0.701692,
      3.703748,
      1,
      NULL,
      NULL,
      NULL,
      3.255827,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      4,
      5,
      1,
      0.533510,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.497442,
      0,
      1.104245,
      0,
      3,
      2,
      NULL,
      NULL,
      NULL,
      3.383600,
      0,
      1.642469,
      2,
      NULL,
      3.296328,
      3,
      NULL,
      0,
      NULL,
      2.690626,
      2.158282,
      2,
      3,
      2.050176,
      3,
      NULL,
      0,
      1,
      3,
      3.570682,
      NULL,
      NULL,
      NULL,
      NULL,
      6.076298,
      7,
      7,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.384745,
      NULL,
      NULL,
      NULL,
      0.542584,
      NULL,
      2,
      1.653325,
      3.291937,
      1,
      1.293267,
      NULL,
      0,
      NULL,
      1,
      0,
      2.570563,
      3.199730,
      5.250811,
      NULL,
      NULL,
      NULL,
      3.584845,
      NULL,
      NULL,
      NULL,
      1.880887,
      0.994565,
      1.677593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.734299,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      18,
      1.792371,
      3,
      4.653524,
      NULL,
      2.972337,
      0,
      7.964932,
      2.315445,
      2.907437,
      0.938243,
      NULL,
      NULL,
      3.611489,
      2.389793,
      1,
      1,
      3.556317,
      0,
      1.386317,
      3.426180,
      3.685778,
      0,
      8,
      1.412537,
      3.738952,
      NULL,
      1.091058,
      1.736720,
      1.441053,
      1.673593,
      0,
      1,
      0.638441,
      3.938260,
      0.981513,
      0,
      9,
      11.545037,
      5.681573,
      NULL,
      2,
      6,
      1.033857,
      3,
      0,
      0.772722,
      0,
      0,
      NULL,
      1.327005,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.582384,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.968601,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.961586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.338814,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      1.489723,
      1.056726,
      0,
      0,
      0.506173,
      3,
      1.894256,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.461749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.817366,
      NULL,
      NULL,
      NULL,
      3.998242,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.603616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.843123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.260222,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.474035,
      3.161760,
      NULL,
      0,
      1.780933,
      14,
      13,
      3.841797,
      35.362633,
      0.597466,
      0.356144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.416603,
      NULL,
      NULL,
      NULL,
      812.533534,
      1,
      2,
      1,
      1,
      1,
      0.265626,
      1,
      1,
      0.857074,
      0,
      0,
      1,
      0.121502,
      0.043458,
      0,
      0.366983,
      1.930533,
      2.307227,
      NULL,
      NULL,
      NULL,
      0.530003,
      NULL,
      0.849642,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      213.467373,
      NULL,
      0,
      26,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.449818,
      NULL,
      1.499670,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1.675844,
      NULL,
      1.978868,
      NULL,
      0.113403,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.007169,
      NULL,
      1,
      NULL,
      0.741478,
      3.460610,
      0.543496,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.915453,
      0,
      NULL,
      0.130481,
      NULL,
      0.258583,
      NULL,
      NULL,
      NULL,
      0.103000,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.916323,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      7,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.864756,
      0.485324,
      NULL,
      0,
      NULL,
      0.574539,
      NULL,
      NULL,
      NULL,
      1.861954,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.090438,
      NULL,
      1.502673,
      NULL,
      0.881511,
      NULL,
      3.477076,
      NULL,
      23.942757,
      NULL,
      3,
      2.741700,
      0,
      NULL,
      1,
      2,
      2,
      4.762544,
      1.741388,
      2,
      1,
      NULL,
      3,
      1,
      NULL,
      0.528673,
      1.196950,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.486263,
      3,
      NULL,
      0.012528,
      0.634695,
      NULL,
      1.217825,
      NULL,
      NULL,
      2.427205,
      NULL,
      NULL,
      0.839200,
      3.065927,
      NULL,
      1,
      1,
      NULL,
      0.547868,
      1,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.167582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.533355,
      NULL,
      3,
      1,
      1,
      3.332275,
      NULL,
      2.603098,
      37.560670,
      52.366289,
      1,
      0.485261,
      7,
      '31404',
      '04130',
      '01304',
      0,
      '',
      '',
      '',
      1.346483,
      '',
      '',
      '');
commit;
end;
/


