set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9334568';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      3,
      NULL,
      4.060672,
      3.684167,
      2.087618,
      2.131536,
      3.251499,
      '422',
      '41243400',
      52,
      58,
      '4242330',
      0.880459,
      0.140322,
      0,
      NULL,
      '1412',
      5,
      0,
      NULL,
      NULL,
      ' 8- 8-1999',
      111.211766,
      0.026506,
      NULL,
      0.456029,
      0.359602,
      '10- 8-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 4-1986',
      0,
      0,
      3,
      NULL,
      0,
      1.822823,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.770239,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.256921,
      1,
      1.534760,
      1.517879,
      NULL,
      NULL,
      1,
      1,
      3,
      7,
      0.532793,
      5,
      NULL,
      0,
      1,
      0,
      2,
      4,
      0,
      4,
      2,
      4,
      5,
      0.325969,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      6.588527,
      NULL,
      0,
      0.532711,
      1.518454,
      3,
      2,
      0,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      2.339739,
      NULL,
      0,
      0,
      NULL,
      3,
      4.924644,
      1,
      2,
      NULL,
      0.079855,
      NULL,
      NULL,
      1.736375,
      NULL,
      NULL,
      1,
      5,
      5,
      NULL,
      NULL,
      5,
      0,
      5,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5.023559,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.406828,
      2,
      1,
      2,
      4,
      NULL,
      1,
      NULL,
      5,
      2,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      0,
      2,
      4,
      3,
      1,
      3,
      2,
      2,
      0,
      1,
      '10-17-1999',
      62.028060,
      ' 5-24-1979',
      14,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.154790,
      NULL,
      0.492907,
      1,
      NULL,
      1.710922,
      NULL,
      2,
      1.673343,
      NULL,
      0.562977,
      1.495340,
      8,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782309,
      1.581282,
      NULL,
      1.942059,
      0,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.843829,
      2,
      0,
      2,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.804782,
      0,
      0,
      NULL,
      NULL,
      0.812689,
      NULL,
      2.124472,
      0.575946,
      1.636162,
      11.238432,
      3.799532,
      3.649379,
      1.611964,
      4.487978,
      NULL,
      NULL,
      NULL,
      16,
      3,
      0.650563,
      71,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.102767,
      '02300',
      '',
      '',
      0,
      '',
      '',
      '',
      1.790211,
      '',
      '',
      '',
      NULL,
      NULL,
      20.895017,
      13,
      0.442088,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.521062,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3.493971,
      0.724111,
      0,
      NULL,
      1,
      0.705482,
      NULL,
      1.102844,
      NULL,
      NULL,
      0,
      NULL,
      1.573892,
      NULL,
      0.796614,
      NULL,
      1,
      3,
      2,
      0.942624,
      NULL,
      0.170768,
      1.543476,
      3.115527,
      2,
      1.285827,
      NULL,
      0.371796,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0.451784,
      NULL,
      NULL,
      NULL,
      1.138332,
      3,
      NULL,
      3.643001,
      0,
      0,
      0.845335,
      0,
      NULL,
      3,
      1.493236,
      1.273155,
      0.004541,
      0,
      1.514749,
      0,
      NULL,
      1.544320,
      0.612381,
      0.855564,
      NULL,
      1,
      2,
      0.000146,
      1.629774,
      2.642439,
      NULL,
      0.346835,
      1,
      NULL,
      NULL,
      NULL,
      3.820205,
      0,
      NULL,
      8,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.928906,
      0,
      1.731332,
      1.967297,
      1,
      1,
      NULL,
      NULL,
      1,
      6.559727,
      1.100592,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      6,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      0.749454,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      4.365181,
      0,
      1.884236,
      NULL,
      NULL,
      0,
      2.247911,
      0.051195,
      NULL,
      2.450029,
      1.064183,
      3,
      3,
      3,
      4.186848,
      5.163169,
      3.671287,
      1.362832,
      3.303877,
      NULL,
      2.234276,
      NULL,
      1.592952,
      3,
      1,
      NULL,
      0.384777,
      1,
      3.922167,
      6,
      NULL,
      5,
      NULL,
      0.688373,
      0,
      2,
      2,
      3,
      NULL,
      1,
      0.394764,
      1,
      1.011881,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.033940,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.083401,
      NULL,
      NULL,
      0.806975,
      NULL,
      NULL,
      6.252115,
      NULL,
      NULL,
      1.519470,
      2,
      3.841361,
      NULL,
      0,
      2.908422,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.962546,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.277898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.844770,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.947063,
      NULL,
      NULL,
      NULL,
      1.276982,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.228521,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      15.009500,
      1,
      0.108059,
      NULL,
      NULL,
      1,
      NULL,
      3.237416,
      0.373254,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.001800,
      51.318146,
      10,
      NULL,
      0.364093,
      0,
      0.495860,
      1.906144,
      1,
      NULL,
      1.946977,
      0,
      0.775737,
      1.471773,
      0.138410,
      NULL,
      0.451418,
      NULL,
      0.785942,
      0.585102,
      1.389619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.680056,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.752809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.684542,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.899434,
      NULL,
      1,
      NULL,
      2.964108,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.172118,
      1,
      2,
      14.809533,
      33.661412,
      0.197324,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      0.472730,
      1,
      1.018297,
      0.722291,
      1.330803,
      0.906569,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.717778,
      NULL,
      0.411622,
      NULL,
      NULL,
      0,
      1.288156,
      NULL,
      1,
      1,
      NULL,
      0.678710,
      3.541150,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      0.412880,
      NULL,
      1.590916,
      3.684340,
      NULL,
      1.221883,
      1,
      1.109639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.230445,
      NULL,
      NULL,
      NULL,
      1.544061,
      NULL,
      0,
      2,
      3,
      NULL,
      NULL,
      NULL,
      100,
      91.889624,
      2,
      0.181373,
      4.958330,
      '12212',
      '22013',
      '43011',
      1.016518,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


