set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9229226';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-6-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 8-24-2003',
      8.963054,
      NULL,
      1,
      3,
      1.670731,
      ' 7-15-1981',
      NULL,
      1.847317,
      292,
      NULL,
      2,
      ' 9-25-2003',
      ' 6-14-1998',
      NULL,
      3.618290,
      NULL,
      1.602235,
      NULL,
      0,
      NULL,
      1,
      0.679287,
      NULL,
      NULL,
      NULL,
      5,
      2.908259,
      NULL,
      8,
      0,
      31,
      4,
      0,
      6.679828,
      3.797768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      5,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      0,
      3,
      4,
      0,
      2,
      2,
      0,
      1,
      2,
      0,
      1.656502,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3.134520,
      1,
      NULL,
      0,
      0,
      0,
      1.528887,
      NULL,
      0.161473,
      1.555662,
      0,
      1.594961,
      0.895075,
      3,
      0.985920,
      1,
      NULL,
      3,
      1,
      0,
      2,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      1.981927,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      2,
      5,
      4,
      NULL,
      1,
      4,
      2,
      2,
      0,
      0.285192,
      1,
      0,
      1,
      1,
      0.024041,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      5,
      1,
      1,
      0,
      0,
      0,
      0,
      2,
      3,
      4,
      2,
      3,
      NULL,
      1,
      1,
      3,
      0,
      0,
      '10- 4-1985',
      36.979810,
      ' 5-27-1998',
      24.061438,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      1.829293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.878003,
      0.914492,
      1,
      0,
      0,
      1.301282,
      NULL,
      NULL,
      NULL,
      NULL,
      0.254821,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.815632,
      1,
      NULL,
      1.827312,
      NULL,
      1,
      NULL,
      2.831699,
      29,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.396828,
      NULL,
      NULL,
      3,
      3,
      2,
      0,
      NULL,
      3,
      1,
      2,
      NULL,
      3.785435,
      0.007433,
      3,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      0.881656,
      1,
      NULL,
      0.477176,
      0,
      0,
      2,
      0,
      NULL,
      10.212265,
      4.730719,
      2,
      NULL,
      2,
      1,
      3.752855,
      5.354923,
      0.501146,
      NULL,
      1.236523,
      45,
      0,
      0.454676,
      NULL,
      44,
      45,
      NULL,
      0,
      NULL,
      7,
      NULL,
      '31223',
      '44100',
      1.047774,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      3,
      34,
      18.741382,
      20.932596,
      1.504826,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.684348,
      1.741227,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      2,
      3.318626,
      NULL,
      1.652686,
      0,
      3.859972,
      0,
      NULL,
      NULL,
      1.195485,
      3.115097,
      1.936091,
      0,
      1.980986,
      0.615021,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.259016,
      2.653045,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.920530,
      NULL,
      NULL,
      NULL,
      0.045486,
      0,
      0.942536,
      0.211771,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.678672,
      1,
      0.712750,
      0.201773,
      0.462835,
      1.458015,
      0,
      1,
      0.135553,
      NULL,
      0.253849,
      1,
      3.966076,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.083015,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.321075,
      NULL,
      NULL,
      2,
      1.255083,
      NULL,
      0.111814,
      3.275618,
      2.264359,
      NULL,
      NULL,
      NULL,
      5.494325,
      1.281660,
      4.055282,
      1.025412,
      NULL,
      NULL,
      0.704772,
      NULL,
      NULL,
      0.943502,
      NULL,
      NULL,
      0.780722,
      NULL,
      NULL,
      0.629752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.419871,
      NULL,
      NULL,
      NULL,
      3.174325,
      0,
      0,
      NULL,
      4.657322,
      5.216917,
      1.619180,
      NULL,
      1.118449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.619754,
      NULL,
      1,
      0,
      3.650021,
      1.618212,
      NULL,
      NULL,
      1.303992,
      2,
      0,
      1.196745,
      2,
      0,
      3,
      3,
      3.823705,
      3.858837,
      1.620087,
      3.733829,
      2.737136,
      1,
      NULL,
      NULL,
      0,
      4,
      0.848626,
      3.674085,
      0,
      0,
      1.656176,
      1.605301,
      0.418563,
      0.497354,
      1.054512,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.566796,
      NULL,
      NULL,
      3.718942,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0.813702,
      0,
      0,
      0.072813,
      3.793974,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.831848,
      NULL,
      NULL,
      NULL,
      3.164041,
      NULL,
      NULL,
      NULL,
      3.135257,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.192979,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.884187,
      1,
      0,
      0.151503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.764610,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      217.440144,
      3,
      2,
      1.657816,
      1,
      1.524964,
      0.400511,
      1,
      0.660618,
      1,
      1.220956,
      0.318712,
      0,
      1.530569,
      NULL,
      0,
      NULL,
      1,
      3,
      1.192045,
      0,
      NULL,
      3.480636,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      181,
      NULL,
      0,
      NULL,
      6,
      NULL,
      1.496614,
      1.115911,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.416420,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.014254,
      NULL,
      0.765346,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.957719,
      0.011061,
      1.743798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.182555,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.069227,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.946361,
      NULL,
      NULL,
      0.772108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.109303,
      NULL,
      0,
      NULL,
      1,
      NULL,
      140.780240,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.066456,
      NULL,
      3.409066,
      1,
      22,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      4,
      2,
      8,
      3,
      1,
      2.670451,
      3,
      NULL,
      1,
      1.482576,
      1,
      0.375654,
      3.367706,
      NULL,
      NULL,
      NULL,
      NULL,
      0.192744,
      2.345354,
      NULL,
      2.540780,
      NULL,
      NULL,
      0.965185,
      NULL,
      NULL,
      2,
      0.347666,
      NULL,
      NULL,
      0.470760,
      NULL,
      2.401711,
      NULL,
      NULL,
      0,
      0.024991,
      NULL,
      2.389339,
      1,
      NULL,
      0.459051,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.750057,
      NULL,
      1.117034,
      NULL,
      3,
      2,
      1,
      0,
      NULL,
      NULL,
      10,
      NULL,
      5,
      4,
      2,
      '22023',
      '20032',
      '12334',
      1,
      '',
      NULL,
      NULL,
      0.016240,
      '',
      '',
      NULL);
commit;
end;
/


