set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8731046';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '0',
      NULL,
      NULL,
      '3132341',
      1.803606,
      1,
      1,
      2,
      '0010',
      NULL,
      0.380108,
      NULL,
      NULL,
      '10-19-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 8-13-1992',
      25,
      0.324036,
      99.201215,
      74,
      NULL,
      NULL,
      ' 9- 2-1998',
      ' 1- 6-1999',
      1,
      3,
      1,
      0,
      0.731572,
      1,
      NULL,
      1.873337,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      15,
      3,
      13,
      0,
      1,
      1.621847,
      0,
      3,
      NULL,
      1.006936,
      0.481843,
      1,
      1.894823,
      3,
      0,
      0,
      0.878277,
      3,
      1,
      NULL,
      3,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      1,
      4,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1.800363,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.048854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.191638,
      NULL,
      0.970754,
      0,
      NULL,
      2,
      2,
      1,
      NULL,
      5,
      NULL,
      1,
      3,
      3,
      1,
      4,
      NULL,
      4,
      5,
      1,
      0,
      5,
      0,
      4,
      1,
      2,
      NULL,
      1,
      5,
      1.925112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      1,
      0,
      0,
      3.834550,
      7.488560,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.399519,
      0,
      8.936850,
      0.056638,
      7,
      0,
      NULL,
      NULL,
      NULL,
      1,
      2.269311,
      1.632010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992080,
      3,
      0.298489,
      2,
      1,
      2.316030,
      0.442380,
      2.094470,
      54,
      3.354075,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      3,
      3,
      3,
      1,
      1,
      2,
      NULL,
      3,
      NULL,
      2,
      2,
      NULL,
      2.251858,
      2,
      NULL,
      NULL,
      3.084384,
      NULL,
      0.176481,
      1.394254,
      1,
      0,
      0.202478,
      0.158835,
      NULL,
      0,
      1.056301,
      NULL,
      0,
      7,
      NULL,
      1.968158,
      8.599371,
      2.072435,
      NULL,
      NULL,
      NULL,
      6.056226,
      NULL,
      NULL,
      NULL,
      40.005157,
      0,
      0,
      NULL,
      75,
      30,
      39.493390,
      4,
      0,
      0,
      '20431',
      NULL,
      '',
      NULL,
      '10403',
      '',
      '',
      1,
      '',
      NULL,
      '',
      3,
      10,
      85,
      34.417133,
      3,
      1.338372,
      3.366676,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.973250,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.091603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.578618,
      3.809512,
      1.685071,
      3,
      1,
      0.627576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.732505,
      NULL,
      NULL,
      0,
      3.434313,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.773673,
      NULL,
      NULL,
      0.257861,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.097912,
      NULL,
      NULL,
      0.196322,
      1,
      3,
      1,
      NULL,
      NULL,
      4.461119,
      2,
      NULL,
      1.856188,
      NULL,
      NULL,
      0.734797,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.967493,
      NULL,
      NULL,
      0.931011,
      NULL,
      NULL,
      2,
      3.805615,
      1.613469,
      1,
      NULL,
      NULL,
      9,
      3.719149,
      3.695116,
      0,
      7.293470,
      3.796395,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      2.789759,
      1.153107,
      1.932204,
      1.491078,
      2.539714,
      NULL,
      NULL,
      7.900323,
      NULL,
      0.703256,
      3.203002,
      11.447507,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.756816,
      2,
      2.945612,
      9.893903,
      3,
      8.089868,
      NULL,
      NULL,
      NULL,
      0.127365,
      NULL,
      NULL,
      0,
      NULL,
      0.473003,
      1,
      1,
      0.499823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.034041,
      1,
      1.115766,
      0.495878,
      1.531220,
      0.386451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.626551,
      0.810026,
      NULL,
      1.170462,
      11,
      NULL,
      1.310813,
      NULL,
      NULL,
      2.051812,
      11,
      NULL,
      0.562064,
      NULL,
      NULL,
      1,
      1.624773,
      NULL,
      0.784934,
      NULL,
      NULL,
      1251,
      NULL,
      1,
      1,
      0.602166,
      1.118712,
      0,
      1.943344,
      0.746198,
      NULL,
      0.706462,
      0.215036,
      0,
      1.823975,
      1.691254,
      0,
      NULL,
      0,
      0.784239,
      1.375710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.298409,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.072509,
      1,
      0.294689,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.925824,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.756997,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.441346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.318433,
      NULL,
      NULL,
      1.310731,
      NULL,
      NULL,
      3.555982,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.394706,
      NULL,
      3,
      NULL,
      3.479542,
      NULL,
      1,
      NULL,
      1.611821,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.880015,
      NULL,
      3,
      NULL,
      24,
      NULL,
      NULL,
      1,
      NULL,
      3.827784,
      NULL,
      0.550783,
      NULL,
      1,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.948509,
      '02300',
      '',
      NULL,
      NULL,
      '43123',
      '',
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


