set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8731046';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      NULL,
      NULL,
      1.792202,
      0,
      NULL,
      '0000',
      0.763260,
      0,
      NULL,
      NULL,
      ' 1-22-2001',
      NULL,
      NULL,
      NULL,
      1,
      2.043587,
      ' 1-24-2001',
      33.672051,
      0.241708,
      169.050591,
      NULL,
      2,
      ' 6-10-1992',
      ' 2-13-1986',
      '11- 2-1984',
      0,
      0,
      1,
      2,
      0,
      1,
      3,
      NULL,
      0.258342,
      3,
      5,
      8,
      1,
      194,
      101.591654,
      2,
      18.956256,
      NULL,
      3,
      3,
      0,
      1,
      0,
      1,
      0.534914,
      0.606603,
      NULL,
      NULL,
      1,
      1,
      1.948680,
      1,
      NULL,
      NULL,
      2,
      1,
      0,
      0,
      0,
      1,
      0,
      2,
      NULL,
      NULL,
      0,
      1,
      NULL,
      5,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1.130711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      NULL,
      5,
      0,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.666707,
      NULL,
      1.886674,
      1,
      1,
      1,
      NULL,
      0,
      3,
      2,
      0,
      3,
      1,
      NULL,
      3,
      1,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      3,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0.917212,
      ' 4-20-1982',
      84,
      ' 0- 0-1981',
      7.506256,
      0.753887,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      1,
      1.141693,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      66,
      1.526365,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.067538,
      1,
      1.938651,
      3.246822,
      NULL,
      2,
      NULL,
      0.052511,
      NULL,
      NULL,
      NULL,
      5.286255,
      0.175836,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.751856,
      1,
      3.919603,
      0.539027,
      0,
      1,
      0,
      71.248209,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.608184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      2,
      '10340',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      26.697572,
      34,
      16,
      0.568821,
      33.499512,
      NULL,
      6,
      2,
      0,
      3,
      NULL,
      0.420951,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.174161,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.436883,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.440925,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      2.948940,
      1.718080,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.293448,
      NULL,
      NULL,
      1.507384,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.575346,
      NULL,
      NULL,
      0.317552,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.286456,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028795,
      0,
      2,
      3,
      0.288098,
      NULL,
      NULL,
      0.862628,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.943926,
      NULL,
      NULL,
      0.452753,
      NULL,
      NULL,
      1.610328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.467695,
      NULL,
      NULL,
      0.600061,
      1,
      2,
      1.848012,
      NULL,
      NULL,
      5,
      6,
      NULL,
      3,
      4.892174,
      2.536825,
      3,
      NULL,
      NULL,
      0.654138,
      NULL,
      NULL,
      3.427987,
      0,
      1.509356,
      1,
      NULL,
      NULL,
      NULL,
      4.918546,
      3,
      NULL,
      NULL,
      3.330650,
      3.518099,
      3.821045,
      2.464074,
      0.260266,
      NULL,
      NULL,
      2,
      1.163926,
      NULL,
      11,
      2,
      3.469334,
      1.666149,
      5.946813,
      0,
      NULL,
      2,
      1,
      1,
      0,
      0,
      1.125677,
      0.119380,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.533516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.028194,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2.747095,
      NULL,
      NULL,
      0,
      2.804980,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.095883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.345755,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.708564,
      0.093338,
      NULL,
      NULL,
      0,
      0.269233,
      NULL,
      NULL,
      1.707342,
      0,
      NULL,
      NULL,
      3.096030,
      0.718198,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      6.276263,
      NULL,
      NULL,
      NULL,
      0.094357,
      NULL,
      NULL,
      NULL,
      1.914876,
      41.128604,
      NULL,
      0,
      985,
      NULL,
      1.922782,
      NULL,
      NULL,
      0.715973,
      1248.048032,
      NULL,
      0,
      NULL,
      NULL,
      2.239689,
      1773.418739,
      NULL,
      NULL,
      NULL,
      0,
      19468.201731,
      1211.557834,
      1.481477,
      1.728064,
      1.613583,
      0,
      0,
      NULL,
      NULL,
      0.316791,
      0,
      1.794486,
      0.785891,
      1.947798,
      0,
      NULL,
      NULL,
      0.827671,
      0.368357,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      3,
      0.062975,
      1,
      1,
      0,
      13.488801,
      2.975764,
      3.080917,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.555494,
      3,
      0,
      1,
      0,
      0.502854,
      NULL,
      0.661385,
      3,
      NULL,
      0,
      0,
      0,
      0,
      1.475476,
      NULL,
      3.247095,
      3,
      0,
      2,
      1.616947,
      1.177752,
      1.663474,
      1.470994,
      3.739117,
      0,
      0.268039,
      0,
      1.912634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      4,
      NULL,
      0.969718,
      NULL,
      NULL,
      NULL,
      85.725525,
      5,
      0,
      2,
      '01211',
      '',
      NULL,
      1.933975,
      '',
      '',
      '',
      0.098006,
      '',
      '',
      '');
commit;
end;
/


