set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8731046';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-5-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '1444034',
      NULL,
      NULL,
      1,
      0,
      '3341',
      NULL,
      0,
      NULL,
      NULL,
      ' 0-27-1983',
      25.791083,
      NULL,
      1,
      NULL,
      0.635187,
      ' 9-19-2003',
      3.855876,
      0,
      NULL,
      NULL,
      0,
      ' 9-29-1977',
      ' 5- 6-2001',
      ' 2-26-1990',
      1.039306,
      NULL,
      3,
      0,
      1,
      2,
      1,
      1.572340,
      0,
      3,
      2,
      8,
      6,
      0,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      0.479526,
      1,
      2,
      1.618410,
      0,
      1.484909,
      3,
      2,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4.572942,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      1.507158,
      NULL,
      NULL,
      0,
      NULL,
      0.622146,
      1.898732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1.724028,
      4,
      0,
      1,
      NULL,
      1,
      2,
      3,
      0,
      4,
      1,
      5,
      5,
      5,
      1,
      4,
      2,
      0,
      3,
      5,
      0,
      3,
      2,
      3,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.837866,
      NULL,
      1,
      1,
      4,
      1,
      1,
      1.304898,
      3,
      NULL,
      2,
      0.335773,
      1.909916,
      NULL,
      NULL,
      NULL,
      0.257119,
      0.859146,
      0.579737,
      1.658298,
      3.185341,
      NULL,
      1.669698,
      NULL,
      NULL,
      NULL,
      NULL,
      13.960245,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268618,
      3,
      NULL,
      2.464042,
      1.615546,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      0.000791,
      2,
      NULL,
      NULL,
      1,
      3,
      2,
      1,
      2,
      2,
      1,
      0,
      3.844972,
      NULL,
      NULL,
      0.863926,
      0,
      1.747095,
      2.330836,
      NULL,
      1,
      NULL,
      0.335487,
      1.014606,
      NULL,
      0.951157,
      0,
      0,
      1,
      3,
      1.580943,
      7,
      NULL,
      5,
      2,
      4,
      5,
      NULL,
      3.398205,
      2,
      2,
      3.631442,
      1,
      57.272444,
      2,
      0.944415,
      NULL,
      35,
      56,
      14,
      1,
      0,
      3.373368,
      '24014',
      '',
      '',
      3.099544,
      '32202',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      12.045469,
      67,
      12.711635,
      NULL,
      19,
      5.521069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.699675,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245527,
      NULL,
      NULL,
      1.676491,
      2,
      3,
      2,
      NULL,
      1.284304,
      1,
      NULL,
      NULL,
      1.259559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.904367,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.509598,
      NULL,
      NULL,
      NULL,
      0.684600,
      NULL,
      NULL,
      1.860826,
      NULL,
      NULL,
      0.758314,
      NULL,
      NULL,
      1.133265,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.208705,
      NULL,
      NULL,
      0.647288,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177886,
      NULL,
      NULL,
      1.600728,
      NULL,
      NULL,
      1.759286,
      1.305056,
      NULL,
      0.363246,
      NULL,
      NULL,
      2.120032,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.220301,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.219468,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.219656,
      NULL,
      NULL,
      1,
      3.045690,
      NULL,
      1,
      NULL,
      NULL,
      2.775969,
      0,
      0.143681,
      7.979230,
      4,
      3.469276,
      2.150853,
      1.338383,
      2.401029,
      2.847784,
      NULL,
      1,
      0.134402,
      1.059543,
      3,
      0.248036,
      1.258758,
      3.291268,
      7.782371,
      4.095588,
      0.676955,
      3,
      0.912672,
      3,
      3,
      NULL,
      NULL,
      2.743418,
      1,
      3.855603,
      3.483939,
      3,
      NULL,
      4,
      NULL,
      1,
      5,
      1.137105,
      0.807405,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.191172,
      1.214376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.743445,
      0,
      0,
      1.492163,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.394094,
      2,
      0.689321,
      1,
      37,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.605511,
      NULL,
      NULL,
      NULL,
      2.568329,
      0,
      1.277605,
      NULL,
      0,
      10212.053436,
      NULL,
      NULL,
      NULL,
      0,
      1.640326,
      0,
      NULL,
      0,
      1.696379,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.270684,
      0.346738,
      1,
      0.033003,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.981043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      0.241089,
      3,
      2,
      NULL,
      0,
      NULL,
      0,
      1,
      0.691191,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.384314,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.198963,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.554094,
      NULL,
      NULL,
      1.016122,
      1.732199,
      1.931393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.643275,
      NULL,
      0,
      NULL,
      3.315805,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.034640,
      NULL,
      0,
      NULL,
      3.292941,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      29.863906,
      1,
      NULL,
      1,
      NULL,
      3.238994,
      NULL,
      NULL,
      NULL,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      55,
      NULL,
      0.719024,
      NULL,
      '24213',
      '',
      '',
      0,
      '13044',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL);
commit;
end;
/


