set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9756185';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      1.993025,
      2.679157,
      0,
      2.303829,
      3.236086,
      0.941477,
      7.868381,
      '022',
      NULL,
      34.101643,
      78,
      '0301400',
      0,
      1,
      NULL,
      0,
      '4042',
      0,
      1,
      NULL,
      NULL,
      NULL,
      39,
      4.812786,
      NULL,
      0,
      0.213930,
      '10- 1-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '10- 8-1992',
      3,
      1,
      NULL,
      1.743601,
      0,
      0,
      0,
      2.678146,
      NULL,
      NULL,
      NULL,
      13.142763,
      1.795097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      5,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      3,
      NULL,
      2,
      NULL,
      3,
      1,
      0,
      1,
      0,
      1,
      2,
      0.681264,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      0.879886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      0.110555,
      0,
      NULL,
      NULL,
      1.651079,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      0.685714,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      5,
      2,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      3,
      0,
      3,
      NULL,
      0,
      2,
      1,
      4,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.388212,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      2,
      1,
      NULL,
      0.640827,
      1,
      1,
      0,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.997162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635164,
      1.554520,
      NULL,
      NULL,
      1.720240,
      1.166088,
      0.214287,
      1.016721,
      NULL,
      1.326496,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.416045,
      0.689427,
      1,
      2,
      3,
      1,
      0,
      0,
      1,
      1,
      2,
      1,
      NULL,
      1,
      NULL,
      0,
      0.198446,
      NULL,
      1.925407,
      NULL,
      0.241398,
      0.961685,
      0,
      0,
      0.273390,
      1,
      1,
      0,
      NULL,
      3.700984,
      1,
      NULL,
      6,
      6,
      NULL,
      1.549932,
      7,
      1.934141,
      0.241944,
      6,
      2,
      3,
      0,
      2.202468,
      2,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      5,
      4.937383,
      NULL,
      '0401',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.497513,
      NULL,
      '',
      '',
      1,
      33,
      21.016617,
      0.738244,
      1.868247,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.649683,
      1.130505,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.266709,
      NULL,
      NULL,
      1.571227,
      NULL,
      NULL,
      1.743396,
      NULL,
      NULL,
      1.087937,
      NULL,
      NULL,
      1.938946,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.569141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.528192,
      3.388875,
      2.027236,
      0,
      1.046263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.316995,
      0,
      NULL,
      NULL,
      0.420583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.659667,
      NULL,
      NULL,
      1.528944,
      NULL,
      NULL,
      1.314599,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.670846,
      NULL,
      NULL,
      0.709337,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.523334,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.066256,
      NULL,
      NULL,
      3.914101,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.073225,
      1.122169,
      1,
      1,
      1.182643,
      1.935132,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.976931,
      NULL,
      NULL,
      2.797226,
      0.809395,
      3.737597,
      NULL,
      5.081116,
      5,
      3.269199,
      1,
      2.492530,
      1.975590,
      3.065513,
      2.299770,
      1.400131,
      3.760510,
      0.402796,
      1.968989,
      2,
      3.963884,
      5,
      3.364607,
      7,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.981962,
      1,
      NULL,
      0.069243,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.627625,
      NULL,
      NULL,
      NULL,
      2.331503,
      3,
      0.911157,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.455566,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.489386,
      NULL,
      NULL,
      0.769729,
      NULL,
      0,
      NULL,
      0.708823,
      NULL,
      NULL,
      0.144042,
      0,
      0.369139,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.353411,
      0,
      0.924353,
      0,
      NULL,
      0.214252,
      0.594699,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      3.314221,
      0,
      1.172208,
      0.427185,
      NULL,
      0.322980,
      0.030969,
      0.857596,
      0.320697,
      1,
      NULL,
      NULL,
      1.896722,
      NULL,
      NULL,
      0.240764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490743,
      NULL,
      NULL,
      1.041538,
      NULL,
      NULL,
      1.649144,
      NULL,
      NULL,
      1.697214,
      NULL,
      NULL,
      NULL,
      0,
      1.327077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.865939,
      NULL,
      0.918224,
      NULL,
      1.350739,
      NULL,
      NULL,
      4,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      57.151808,
      3,
      3.364423,
      1,
      '4032',
      NULL,
      '',
      0.053121,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      '');
commit;
end;
/


