set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9773907';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4.207301,
      5.962637,
      5.248631,
      2.890704,
      5.957573,
      0.173453,
      2.423135,
      5.606948,
      '002',
      '44243130',
      12.405057,
      71,
      '4343104',
      NULL,
      1.087590,
      1,
      2,
      '4134',
      4.256148,
      1,
      NULL,
      NULL,
      ' 6-27-1994',
      NULL,
      3,
      NULL,
      1,
      NULL,
      ' 6- 1-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-23-1986',
      ' 8- 7-1979',
      0.915657,
      0,
      1.805095,
      2.916356,
      2,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      10.345901,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.458919,
      0,
      1,
      NULL,
      0.191667,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      3,
      1,
      0,
      NULL,
      3,
      1,
      1,
      0,
      0,
      1,
      4,
      2,
      4,
      0,
      4,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.195017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.134499,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1,
      0,
      NULL,
      1,
      3,
      1,
      0,
      3,
      3,
      2,
      2,
      NULL,
      2,
      NULL,
      5,
      0,
      5,
      5,
      1,
      4,
      3,
      2,
      NULL,
      4,
      5,
      4,
      3,
      1,
      NULL,
      0,
      3,
      ' 8- 8-1989',
      NULL,
      ' 4- 6-1974',
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.904743,
      2.837735,
      3.487484,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.784411,
      5,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.632705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.693064,
      0.816602,
      0.681920,
      NULL,
      1,
      0.881838,
      NULL,
      0.299491,
      15.319981,
      0.758931,
      0.433659,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      3,
      2,
      NULL,
      3,
      1,
      3,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2.781241,
      0,
      0,
      0.280873,
      0,
      3.753298,
      0,
      0.521852,
      0.046517,
      1,
      0,
      1.108682,
      0,
      0.846810,
      3,
      NULL,
      0,
      0,
      7,
      4,
      4.005293,
      NULL,
      10.606007,
      6,
      NULL,
      NULL,
      4.743923,
      2.562147,
      0.249893,
      NULL,
      49,
      NULL,
      3,
      53,
      NULL,
      16,
      41.128029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      0.940791,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      9.133757,
      205.986102,
      10,
      NULL,
      NULL,
      8,
      NULL,
      5,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.619347,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751808,
      NULL,
      NULL,
      1.037055,
      NULL,
      NULL,
      1.941531,
      2.131896,
      3,
      1.416298,
      NULL,
      3,
      1,
      1,
      3,
      1.451509,
      NULL,
      NULL,
      3.147416,
      3.573194,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7.154396,
      NULL,
      0.922637,
      NULL,
      NULL,
      NULL,
      1.595511,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.305719,
      0.004086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      1.839909,
      1.450953,
      0.339486,
      3.696316,
      NULL,
      0,
      0.725731,
      1.020115,
      NULL,
      0.026097,
      0.453333,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.526291,
      NULL,
      NULL,
      2.275568,
      NULL,
      4,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.256646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.594846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.269357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.739856,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.900160,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.003653,
      2.849476,
      6,
      0,
      1.421835,
      1,
      1.530620,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.309718,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.302494,
      0.764971,
      0,
      2,
      1,
      0.009204,
      2,
      0.919243,
      1,
      2,
      0,
      3,
      2,
      NULL,
      2.911669,
      1.594058,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.111881,
      0.154499,
      1.810745,
      0,
      1,
      0.665715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.597273,
      NULL,
      NULL,
      0.092128,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.678812,
      NULL,
      NULL,
      2.219452,
      1.274028,
      0.726148,
      1.716340,
      1,
      0,
      1.351585,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      169.528060,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.109770,
      NULL,
      NULL,
      NULL,
      0.068382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.016284,
      NULL,
      NULL,
      NULL,
      1.727114,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.628077,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      15.395679,
      NULL,
      0.977028,
      7,
      0,
      0,
      NULL,
      NULL,
      1.084466,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.743625,
      NULL,
      NULL,
      0.080150,
      NULL,
      NULL,
      17.719027,
      15.427677,
      0,
      NULL,
      0.608819,
      0,
      1.474468,
      1,
      NULL,
      NULL,
      0.523239,
      0.689827,
      0.337045,
      NULL,
      NULL,
      1,
      1,
      0.579112,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.331336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      6,
      NULL,
      2.700310,
      NULL,
      2,
      16.951186,
      1,
      3,
      0,
      1,
      0.373064,
      NULL,
      1,
      2,
      NULL,
      2,
      0,
      NULL,
      1.871031,
      NULL,
      NULL,
      2.445368,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.891331,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.028422,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      1.988472,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.447462,
      NULL,
      1,
      NULL,
      4,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      53.625091,
      2,
      2,
      0.976417,
      '03101',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


