set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9100190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '0100413',
      0.923031,
      1,
      2,
      1,
      NULL,
      1.368523,
      1,
      NULL,
      NULL,
      ' 2- 9-1981',
      18.450168,
      NULL,
      4,
      2.538440,
      0.304441,
      ' 5-17-1983',
      8,
      4.325164,
      NULL,
      111.808713,
      0,
      ' 7-24-1979',
      '10- 1-1983',
      NULL,
      NULL,
      0,
      NULL,
      0.384412,
      1,
      1.399625,
      NULL,
      0,
      1,
      NULL,
      3,
      12.335878,
      NULL,
      8,
      24.262302,
      3,
      NULL,
      2,
      2,
      2,
      1,
      1,
      0,
      NULL,
      0.961032,
      NULL,
      0,
      0.541219,
      0.989941,
      0,
      0.514301,
      0,
      0,
      NULL,
      1.300342,
      2,
      1,
      2,
      1,
      5,
      2,
      5,
      2,
      NULL,
      1,
      0,
      NULL,
      10,
      1,
      1,
      1,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      0,
      3,
      0.884180,
      0.671524,
      0,
      0,
      NULL,
      1.144383,
      1,
      NULL,
      1.945714,
      0,
      0.919571,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      2,
      NULL,
      3,
      1.200000,
      1.014381,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5,
      0,
      NULL,
      0,
      NULL,
      1,
      2,
      5,
      2,
      0,
      0,
      3.952445,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      NULL,
      0,
      1,
      0,
      4,
      NULL,
      5,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      5,
      NULL,
      2,
      2,
      2,
      NULL,
      2,
      4,
      NULL,
      2,
      2,
      ' 7-21-2003',
      NULL,
      NULL,
      33.449604,
      2.723716,
      0,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0,
      3,
      NULL,
      0,
      4,
      0,
      4,
      NULL,
      5,
      5,
      4,
      2,
      0.780285,
      NULL,
      ' 8-22-1989',
      4,
      ' 2-25-1990',
      2.553845,
      1.132493,
      0,
      NULL,
      5,
      NULL,
      9.279436,
      0.152362,
      0.578143,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.368262,
      NULL,
      2,
      6.103161,
      1,
      2,
      5,
      5.712990,
      9.868304,
      1.543874,
      NULL,
      NULL,
      NULL,
      1.287733,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.319358,
      0.245167,
      1.383105,
      1,
      0.910974,
      3,
      0.731681,
      1,
      4,
      0,
      1.478706,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.535104,
      NULL,
      2,
      NULL,
      0,
      3,
      1,
      2,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0.441732,
      0.174986,
      0.429700,
      1,
      1.963597,
      1.006658,
      1.662860,
      1.818680,
      0.751390,
      NULL,
      1.368307,
      NULL,
      3,
      1.359011,
      NULL,
      4.324007,
      NULL,
      2.467542,
      3.041189,
      2,
      1.313500,
      NULL,
      1.413678,
      6.942906,
      NULL,
      3,
      2.816344,
      56.852043,
      1,
      NULL,
      NULL,
      NULL,
      5,
      53.540287,
      5,
      NULL,
      3.152926,
      '24114',
      '',
      '',
      3,
      '01222',
      '',
      '',
      0.184986,
      '',
      NULL,
      '',
      2,
      NULL,
      316,
      32,
      NULL,
      48.346773,
      0,
      5,
      NULL,
      1,
      1.295842,
      1,
      1.817272,
      NULL,
      NULL,
      NULL,
      0.423847,
      0.052082,
      NULL,
      NULL,
      NULL,
      NULL,
      1.003703,
      0,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1,
      0,
      0.679876,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.623205,
      NULL,
      NULL,
      3.020665,
      0,
      0.466641,
      0,
      0.674743,
      1.414552,
      1.315218,
      NULL,
      3,
      2.940865,
      1,
      NULL,
      1.208951,
      1.689487,
      1,
      3.484281,
      1.188909,
      1,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3,
      NULL,
      1.411651,
      NULL,
      3.213639,
      0,
      NULL,
      2,
      1,
      0.100288,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.682820,
      0,
      3.130129,
      0.861262,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.848158,
      NULL,
      0,
      1.392123,
      1.197840,
      NULL,
      1,
      NULL,
      NULL,
      9.979141,
      1.516662,
      1.126018,
      NULL,
      NULL,
      0,
      0.606568,
      0.314133,
      1,
      7.887850,
      0.776150,
      0.643682,
      0,
      NULL,
      NULL,
      1.747722,
      NULL,
      NULL,
      0.427307,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.679496,
      0.130487,
      1.872627,
      0.996842,
      1,
      1.491658,
      6.217429,
      1,
      0,
      1.133777,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.683893,
      0.704257,
      1.547093,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.179684,
      3.378485,
      1,
      0,
      3,
      0,
      NULL,
      3,
      NULL,
      1.108047,
      0.910811,
      NULL,
      0.421375,
      1.864469,
      0.056291,
      1.761188,
      0.458453,
      NULL,
      1,
      2.656974,
      NULL,
      4,
      2,
      0,
      0,
      1.614297,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      69.578200,
      NULL,
      NULL,
      1.059210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.588905,
      0,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0.966905,
      NULL,
      0.232882,
      NULL,
      NULL,
      2,
      1.775238,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.242610,
      NULL,
      11.729074,
      2,
      NULL,
      3,
      3.446174,
      NULL,
      0.110501,
      2,
      1.560918,
      NULL,
      3.487272,
      NULL,
      NULL,
      3.637471,
      0,
      9.439021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.919661,
      NULL,
      0.596868,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.649638,
      NULL,
      0.393294,
      NULL,
      3.089016,
      NULL,
      1.914803,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.108546,
      NULL,
      0,
      NULL,
      0,
      NULL,
      2.115018,
      1.621612,
      1.297065,
      NULL,
      1.972841,
      1,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      1.417987,
      1.023008,
      0,
      NULL,
      0,
      0,
      0.522767,
      NULL,
      NULL,
      1.299403,
      0,
      NULL,
      0.167021,
      0.139795,
      12.887202,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      NULL,
      2.622190,
      28,
      30,
      0.097228,
      8,
      NULL,
      1.294301,
      NULL,
      NULL,
      2,
      1,
      1.921602,
      1,
      45,
      6.814774,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7.934132,
      0,
      1.237126,
      0.455143,
      NULL,
      NULL,
      0,
      0.431498,
      0.886029,
      1.339325,
      0,
      1,
      0.014349,
      0,
      0.230715,
      1.444600,
      1.661113,
      0.327726,
      1.234809,
      0.648600,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.619902,
      1,
      1.952778,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.404567,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      NULL,
      0.861244,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.576410,
      NULL,
      1.047193,
      NULL,
      NULL,
      0.711692,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.108621,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.084331,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.721773,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0.315239,
      1.789514,
      NULL,
      3,
      NULL,
      3,
      2.602623,
      NULL,
      1,
      0,
      1.294152,
      1.091867,
      1.485031,
      NULL,
      1.727005,
      1,
      1.381588,
      0.775951,
      0.253228,
      1,
      0.437678,
      0,
      1,
      0.044291,
      NULL,
      1,
      0.586440,
      1,
      0.078998,
      1,
      0.445245,
      NULL,
      1.310258,
      1.243101,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      3,
      3.352881,
      0.178875,
      1.926474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.671725,
      0.709215,
      1.387188,
      1.569488,
      1.106527,
      0.153125,
      2,
      NULL,
      6,
      1.308213,
      NULL,
      NULL,
      73.420436,
      21,
      1,
      0,
      0.364946,
      '10401',
      '',
      '',
      1,
      '20210',
      NULL,
      '',
      1,
      '',
      NULL,
      '');
commit;
end;
/


