set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9002983';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-9-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '4133322',
      1.151549,
      NULL,
      1,
      3,
      '3044',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42.119469,
      NULL,
      NULL,
      3.019083,
      1,
      ' 0- 5-1978',
      NULL,
      3,
      361,
      162.896626,
      1,
      ' 2- 1-1998',
      ' 5-16-1982',
      NULL,
      3,
      3.110086,
      NULL,
      0.359860,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      91.150116,
      NULL,
      5,
      4.031326,
      191,
      89.016812,
      NULL,
      18,
      NULL,
      0,
      4,
      1,
      1,
      1,
      0.861558,
      NULL,
      0,
      0.186609,
      0,
      0.200391,
      1,
      33.527943,
      NULL,
      0,
      5,
      3,
      3,
      0,
      1,
      1,
      1,
      0,
      5,
      0,
      0,
      1,
      0,
      0,
      8,
      1,
      2,
      NULL,
      1,
      1.294337,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      4,
      3,
      1,
      NULL,
      0,
      1,
      0.651515,
      NULL,
      1.433606,
      1.726064,
      0.804992,
      NULL,
      0.555358,
      0,
      NULL,
      1.452132,
      1.036348,
      NULL,
      1,
      1,
      0,
      7.265741,
      1,
      2,
      0.908961,
      0,
      NULL,
      NULL,
      0.991411,
      NULL,
      NULL,
      1,
      3,
      1,
      0,
      2,
      2,
      2,
      0,
      1,
      1,
      1,
      2,
      0,
      5,
      1,
      NULL,
      1,
      1,
      0.501930,
      NULL,
      1,
      NULL,
      4,
      NULL,
      4,
      1,
      3,
      3,
      1,
      5,
      3,
      1,
      1,
      NULL,
      4,
      2,
      1,
      5,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      3,
      4,
      9.945398,
      3.343583,
      ' 9-29-2001',
      NULL,
      '11- 4-1993',
      216.162659,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.793907,
      NULL,
      1.119101,
      3.199784,
      0,
      5.719180,
      0,
      7,
      2.117213,
      0,
      1,
      1.977177,
      NULL,
      NULL,
      NULL,
      0.090327,
      NULL,
      0.619618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.727471,
      3.783845,
      NULL,
      0.596905,
      1.230225,
      0.957561,
      0.800737,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      NULL,
      3,
      0,
      NULL,
      0,
      1,
      1.565328,
      9.008990,
      12.309975,
      NULL,
      130.924653,
      58,
      5.425796,
      135,
      125,
      0.800892,
      1.369426,
      NULL,
      0.329706,
      0,
      0,
      0,
      13,
      7.486896,
      1,
      NULL,
      5.373044,
      NULL,
      1.369337,
      3,
      5.318627,
      5.820887,
      NULL,
      4,
      0.649146,
      0,
      3.289532,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      4,
      36.541128,
      NULL,
      1,
      5.124746,
      '13321',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      3.583508,
      19,
      102.396306,
      NULL,
      0,
      16,
      8,
      8,
      2,
      NULL,
      3,
      0,
      0.731611,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.726922,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.340059,
      NULL,
      1.184865,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.283631,
      5.935760,
      7.724423,
      2,
      1.417411,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.503159,
      2,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.962178,
      1,
      1.996287,
      0,
      0,
      0.550812,
      NULL,
      NULL,
      NULL,
      0.981176,
      1.955444,
      0.636615,
      0.920970,
      0.609928,
      1,
      1.450946,
      NULL,
      NULL,
      NULL,
      1.555406,
      NULL,
      NULL,
      1.459064,
      0,
      0.039319,
      0.361259,
      3.188860,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.069230,
      NULL,
      NULL,
      NULL,
      1.785820,
      NULL,
      NULL,
      0.280074,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.449413,
      4,
      4.689928,
      NULL,
      NULL,
      1,
      1.927708,
      NULL,
      NULL,
      6,
      5,
      0.569094,
      0.261263,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.824793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.009539,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      1.604157,
      0,
      2.656934,
      1.501544,
      3.909532,
      NULL,
      5,
      4,
      NULL,
      0,
      NULL,
      7.513458,
      2.534615,
      NULL,
      2.074146,
      1,
      2.119509,
      NULL,
      3,
      NULL,
      0,
      0.380630,
      7,
      5.201067,
      NULL,
      0.980833,
      NULL,
      2.160747,
      NULL,
      1,
      0.382710,
      1.118044,
      3,
      2.713630,
      2,
      1.077437,
      1,
      5.790431,
      2.838433,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1.069894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.583570,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.637064,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.091517,
      NULL,
      NULL,
      2.984799,
      NULL,
      NULL,
      1.709614,
      1.731709,
      1.632586,
      1.897894,
      1,
      3,
      0,
      NULL,
      NULL,
      0.053757,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.026795,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.855363,
      NULL,
      NULL,
      NULL,
      0.505842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594678,
      NULL,
      NULL,
      NULL,
      2.863385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.906797,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.705975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      116.326244,
      91.730016,
      1.583490,
      0.137706,
      0.539887,
      1,
      NULL,
      NULL,
      1.679239,
      1,
      1,
      1,
      NULL,
      NULL,
      1.647311,
      NULL,
      NULL,
      1.671511,
      NULL,
      0.233366,
      171.727270,
      NULL,
      0,
      3.818321,
      1.737664,
      NULL,
      0,
      NULL,
      1,
      1.104936,
      1,
      0.706965,
      0.218820,
      3,
      0,
      0.457263,
      1.019593,
      1.228031,
      0,
      3,
      NULL,
      1.962772,
      NULL,
      0,
      NULL,
      1.647856,
      NULL,
      1.911915,
      NULL,
      2,
      NULL,
      20.936258,
      NULL,
      NULL,
      7.980123,
      33.395304,
      1.287596,
      1.349811,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.790588,
      NULL,
      0,
      NULL,
      0.917463,
      NULL,
      0.481403,
      NULL,
      1,
      NULL,
      1.805555,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.494781,
      1.699453,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.032619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.536841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.228321,
      NULL,
      NULL,
      NULL,
      0.665187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0.664484,
      0.539277,
      0.254175,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.260992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.115139,
      1,
      3,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.099738,
      NULL,
      1.814242,
      NULL,
      1,
      NULL,
      2.578954,
      NULL,
      23,
      0.511301,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      8.061760,
      0.783049,
      2,
      3.301024,
      0,
      6,
      1,
      1,
      NULL,
      1.081339,
      0.724568,
      NULL,
      NULL,
      0.527962,
      NULL,
      0.179423,
      0,
      NULL,
      0.207825,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.347913,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.520208,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.180739,
      0.340188,
      0.253879,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.570732,
      NULL,
      1,
      NULL,
      1,
      2,
      2,
      2,
      1,
      1.348319,
      41,
      65,
      1,
      0.879786,
      NULL,
      '01031',
      '13144',
      '',
      1.252678,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


