set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0115805';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3,
      6,
      3.606943,
      0.434014,
      2,
      5,
      0.227799,
      0.217965,
      '223',
      '23101410',
      39,
      9,
      NULL,
      1.703837,
      0,
      1,
      NULL,
      '0403',
      NULL,
      0.638045,
      NULL,
      NULL,
      ' 6-26-1985',
      NULL,
      18,
      NULL,
      2,
      3.139072,
      ' 3-14-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 6-13-1982',
      NULL,
      ' 3-11-1984',
      3.839410,
      NULL,
      2,
      1.335462,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      8.037345,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      3,
      1,
      1,
      1,
      1.300124,
      1,
      1,
      0.209473,
      0,
      1.574353,
      4,
      0,
      2,
      3,
      3,
      1,
      4,
      1,
      0,
      1,
      3,
      0,
      0,
      1,
      1,
      NULL,
      3,
      3,
      NULL,
      0,
      1,
      0.535008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.450048,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      1,
      NULL,
      1.283987,
      1,
      NULL,
      NULL,
      3.740692,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0.120002,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1.944245,
      NULL,
      1,
      1,
      2,
      0,
      5,
      4,
      1,
      4,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      2,
      4,
      5,
      2,
      0,
      2,
      5,
      3,
      NULL,
      7.585849,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5.894166,
      NULL,
      1.892367,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.796653,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2.284489,
      NULL,
      6.758216,
      NULL,
      NULL,
      NULL,
      0.109736,
      NULL,
      NULL,
      0.215986,
      11,
      NULL,
      0,
      3,
      NULL,
      0,
      ' 6-14-1998',
      661.221497,
      ' 9-29-1999',
      155,
      2,
      NULL,
      0.417440,
      NULL,
      0,
      1,
      1.594123,
      1,
      1,
      NULL,
      0,
      4.534880,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.250787,
      0,
      3,
      3,
      0,
      0,
      NULL,
      2,
      NULL,
      3,
      1,
      1,
      NULL,
      2,
      NULL,
      0,
      0,
      1.744127,
      0.424500,
      1.515951,
      0,
      0.080121,
      0,
      0,
      0.985634,
      NULL,
      1.695682,
      NULL,
      1,
      1.287032,
      0.299560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      52,
      3,
      3.489403,
      6.993807,
      NULL,
      '122',
      '2404',
      2,
      '41333',
      '',
      '',
      1.475257,
      '',
      '',
      '',
      3,
      8,
      133,
      NULL,
      1.906069,
      NULL,
      NULL,
      NULL,
      NULL,
      1.823801,
      0.932284,
      0,
      0.437041,
      NULL,
      NULL,
      2.701293,
      1.232673,
      NULL,
      0.910852,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.735599,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.526438,
      NULL,
      NULL,
      1.130571,
      NULL,
      NULL,
      5.287745,
      0,
      0,
      1,
      0.707709,
      NULL,
      NULL,
      NULL,
      2.439535,
      2.193671,
      NULL,
      0.308582,
      2,
      NULL,
      NULL,
      0.447026,
      NULL,
      NULL,
      1.142265,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.856724,
      NULL,
      NULL,
      0.056484,
      NULL,
      NULL,
      1.126960,
      NULL,
      NULL,
      1,
      0,
      1.060885,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3.074505,
      NULL,
      0,
      1.021504,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.166857,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.699684,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.429598,
      NULL,
      NULL,
      1.212047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.529487,
      0,
      0.852503,
      0,
      NULL,
      NULL,
      4,
      3.834146,
      5.264910,
      3,
      4.649952,
      5,
      0.903531,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.721329,
      0,
      1,
      1.463372,
      3,
      2,
      NULL,
      NULL,
      4,
      3.664046,
      2.150617,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.742582,
      0.392472,
      6.242111,
      0.601136,
      NULL,
      2,
      3,
      NULL,
      0.129037,
      NULL,
      NULL,
      0.326474,
      1,
      1,
      0.558225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.663545,
      NULL,
      2,
      0.450225,
      NULL,
      0.054419,
      NULL,
      NULL,
      NULL,
      NULL,
      574.677135,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.588320,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.440488,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.131976,
      NULL,
      NULL,
      NULL,
      0.005030,
      NULL,
      NULL,
      NULL,
      2.378266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.968397,
      NULL,
      NULL,
      NULL,
      0.523242,
      NULL,
      NULL,
      NULL,
      3.292432,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.898936,
      2,
      1,
      3.607108,
      1.632749,
      0,
      NULL,
      4,
      2.359119,
      0.441983,
      NULL,
      NULL,
      1.534547,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.753566,
      0,
      1.284716,
      1,
      0.761427,
      NULL,
      0,
      1.684079,
      1,
      1,
      0,
      1,
      0.737957,
      1,
      1.447604,
      NULL,
      0.258121,
      0,
      0,
      0.708365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.421682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      6,
      5.667257,
      0.004496,
      3,
      1,
      2,
      NULL,
      3.209853,
      0.364353,
      0,
      NULL,
      NULL,
      0.856306,
      1.405035,
      NULL,
      0,
      0,
      NULL,
      1.111126,
      1.884970,
      NULL,
      0,
      0.688474,
      NULL,
      1,
      0,
      NULL,
      1.418876,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1.698615,
      NULL,
      0,
      NULL,
      NULL,
      0.732065,
      0,
      0.637029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.911405,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      5,
      NULL,
      1,
      0,
      0,
      26.267799,
      90,
      NULL,
      4,
      6.912301,
      '2144',
      '130',
      '1300',
      3,
      '20114',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


