set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9107981';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-3-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      NULL,
      1.186954,
      1.690662,
      1,
      1,
      '1112',
      0.384491,
      1,
      3,
      33.072454,
      ' 4-20-1993',
      38,
      NULL,
      5,
      1,
      0.684404,
      ' 6- 8-1979',
      NULL,
      0,
      275,
      28.381570,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.792510,
      1,
      0.694196,
      0,
      1,
      0.130415,
      1.534172,
      67.493644,
      6,
      6,
      0,
      5,
      0.522363,
      NULL,
      3,
      4,
      1,
      10,
      1.280235,
      NULL,
      0,
      0,
      0.311209,
      1.198752,
      NULL,
      0.453402,
      0,
      1,
      163.742180,
      2,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      1,
      1,
      2,
      0,
      0,
      0,
      0,
      NULL,
      3.832956,
      1,
      NULL,
      NULL,
      0,
      0.032086,
      NULL,
      NULL,
      1.683322,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      1.452150,
      0,
      1.901035,
      NULL,
      NULL,
      3.241802,
      3.366498,
      0.241953,
      1,
      NULL,
      3.896394,
      NULL,
      0.673383,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      1,
      2,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.212589,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      2,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3,
      3,
      0,
      NULL,
      NULL,
      1,
      1,
      3,
      NULL,
      2,
      1,
      0,
      NULL,
      1.250947,
      3,
      ' 5-28-1996',
      347,
      ' 2-26-1989',
      859,
      2,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.792795,
      1.619911,
      1.504396,
      1.927139,
      1,
      5.965868,
      4.260820,
      0,
      NULL,
      NULL,
      0,
      0.318368,
      0.077107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.997480,
      1,
      0.821510,
      NULL,
      3,
      1,
      0.201342,
      1.801784,
      NULL,
      1.358663,
      1.682747,
      NULL,
      NULL,
      NULL,
      3,
      1.847258,
      0,
      0,
      NULL,
      0,
      3,
      0,
      0,
      0,
      1,
      2,
      3,
      0.703669,
      0.809072,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1,
      1.462094,
      1.191179,
      1,
      1,
      0.620888,
      0,
      1,
      0,
      NULL,
      NULL,
      1.387697,
      NULL,
      6.655332,
      NULL,
      NULL,
      10.832532,
      0.795062,
      NULL,
      2.108134,
      7,
      2,
      1.221426,
      3.844401,
      NULL,
      2,
      0,
      54,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2.487670,
      NULL,
      '',
      '',
      0,
      '44323',
      '',
      NULL,
      2,
      '1103',
      '',
      '',
      NULL,
      NULL,
      186,
      NULL,
      0.240819,
      16.836221,
      NULL,
      NULL,
      5,
      3.034267,
      NULL,
      3.153495,
      0.939766,
      NULL,
      NULL,
      0.790120,
      NULL,
      NULL,
      2,
      3.647371,
      3.969234,
      1,
      1,
      1,
      1.408433,
      NULL,
      NULL,
      2,
      1.482750,
      NULL,
      3.862427,
      1,
      0.686694,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.753343,
      1.046726,
      0.262747,
      0.879821,
      NULL,
      NULL,
      5.363629,
      9,
      2,
      1,
      0.933728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.412707,
      NULL,
      3,
      1.584074,
      0,
      3,
      2.335399,
      NULL,
      3,
      0,
      0,
      0.034488,
      0.802844,
      0.664143,
      NULL,
      0,
      0,
      0.240170,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.027072,
      NULL,
      NULL,
      2.766242,
      3,
      0,
      3,
      1,
      1.461390,
      11,
      7,
      6.554182,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.643709,
      1.292836,
      0.138909,
      NULL,
      NULL,
      NULL,
      10.204864,
      4.388503,
      3,
      3,
      3.156275,
      1.874844,
      0.860412,
      NULL,
      NULL,
      3.393487,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.527082,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.001954,
      NULL,
      NULL,
      1.321963,
      NULL,
      NULL,
      1.148488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.244349,
      0,
      1,
      2.006918,
      NULL,
      NULL,
      3.571854,
      0.451190,
      1.274905,
      2,
      3.615244,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.667717,
      1,
      NULL,
      8,
      16.199092,
      0,
      NULL,
      NULL,
      2,
      NULL,
      1.046845,
      0.537391,
      3,
      2,
      4.822352,
      NULL,
      1.267098,
      4,
      1.527527,
      NULL,
      1.043725,
      2,
      0,
      0,
      0.286816,
      1,
      0.298902,
      0,
      3.574072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.740860,
      NULL,
      NULL,
      1.441683,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.477863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.735535,
      NULL,
      NULL,
      0,
      0.749441,
      1.096265,
      1,
      0,
      3.318286,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.209778,
      NULL,
      NULL,
      NULL,
      1.343999,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.809675,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.735749,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      0,
      4,
      1,
      2,
      8,
      154.158910,
      1.659005,
      NULL,
      NULL,
      0.948392,
      NULL,
      NULL,
      1.597989,
      NULL,
      NULL,
      0.936351,
      1.617869,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.063952,
      460,
      14.944006,
      1.691467,
      NULL,
      1,
      3,
      0.729418,
      0.302699,
      1.975174,
      1.414980,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1.144894,
      3,
      NULL,
      1,
      NULL,
      1.161086,
      NULL,
      NULL,
      NULL,
      0.323413,
      NULL,
      2.250558,
      NULL,
      66,
      NULL,
      1.424530,
      13.162964,
      40,
      1,
      0,
      3,
      NULL,
      1.648977,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.385602,
      NULL,
      NULL,
      NULL,
      1.293951,
      NULL,
      1.207622,
      NULL,
      0,
      NULL,
      0.418106,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.709305,
      NULL,
      0,
      3,
      1.969147,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      3,
      NULL,
      8.341935,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.157891,
      NULL,
      3,
      0,
      2.637922,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      65,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      150,
      NULL,
      1.763722,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.655009,
      0.366500,
      1.504901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      0.274815,
      NULL,
      59.633918,
      NULL,
      1.356772,
      0.785865,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      3,
      NULL,
      5.738716,
      NULL,
      0,
      NULL,
      2,
      0,
      1,
      NULL,
      NULL,
      2.524051,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      4.722061,
      5.842976,
      5,
      1,
      10.409536,
      1,
      0.841619,
      0,
      1.327887,
      1,
      NULL,
      3.496309,
      0.882875,
      NULL,
      0,
      2.521426,
      NULL,
      1.009788,
      NULL,
      NULL,
      1,
      2.798235,
      NULL,
      1,
      0,
      NULL,
      3,
      0.058988,
      NULL,
      0,
      1.701384,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.658937,
      NULL,
      1.544499,
      1.272558,
      1.485026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.586831,
      NULL,
      0,
      NULL,
      1.579154,
      NULL,
      NULL,
      3,
      7,
      NULL,
      1.949942,
      2,
      NULL,
      86.544648,
      NULL,
      0.168173,
      6,
      NULL,
      NULL,
      '43200',
      1,
      '41223',
      '',
      NULL,
      7.776267,
      '0311',
      '1403',
      '3234');
commit;
end;
/


