set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9402223';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5,
      3.507123,
      2.581111,
      0.419217,
      7,
      3.849672,
      1.902858,
      NULL,
      '321',
      NULL,
      21.759346,
      62,
      NULL,
      1,
      1,
      4,
      3,
      '3412',
      4,
      1,
      NULL,
      NULL,
      '10-16-1975',
      39,
      16,
      NULL,
      3,
      1.429984,
      ' 9-14-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      ' 3- 8-1983',
      ' 2- 1-2003',
      0.448579,
      NULL,
      2,
      3.443395,
      0.323682,
      0,
      3,
      NULL,
      1.940147,
      6,
      4,
      12.507029,
      5.177295,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0.262811,
      0.520144,
      1.076603,
      1,
      1.895788,
      1.065188,
      0,
      3,
      0,
      7,
      2.043284,
      3,
      1,
      0,
      3,
      5,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      7,
      1,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      1.723958,
      NULL,
      NULL,
      NULL,
      NULL,
      1.790161,
      1.426560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      0,
      3,
      3,
      0,
      1,
      5.159338,
      0,
      NULL,
      1,
      1,
      1.109198,
      NULL,
      0.242778,
      3,
      0,
      0,
      1,
      1,
      4,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0,
      NULL,
      1,
      2,
      2,
      1,
      4,
      4,
      4,
      1,
      2,
      5,
      NULL,
      0,
      4.210673,
      1.852736,
      NULL,
      438.224526,
      ' 4-10-1987',
      440.254849,
      0,
      1,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1,
      0,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.265999,
      1.228419,
      0.605144,
      0.980006,
      NULL,
      5,
      1.410767,
      NULL,
      NULL,
      NULL,
      0.909007,
      5.175680,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.380333,
      1,
      0.755016,
      1.561836,
      NULL,
      0.890403,
      1.461152,
      3,
      NULL,
      0,
      0.121048,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      3.912971,
      0.551920,
      0.968394,
      1,
      3.621432,
      0.334018,
      NULL,
      0.006419,
      1.670669,
      0.337074,
      1.080106,
      NULL,
      1,
      0,
      0.796561,
      3,
      0,
      4.251044,
      11,
      6,
      5.006065,
      7,
      0.490134,
      5.587190,
      1.433550,
      1.912248,
      NULL,
      2.892366,
      1,
      56,
      3,
      1,
      NULL,
      NULL,
      16,
      18,
      0,
      1,
      1,
      NULL,
      '41131',
      NULL,
      NULL,
      '',
      '',
      '',
      1.660181,
      '',
      '',
      '',
      0,
      5.550036,
      190,
      6.414541,
      0,
      18,
      3,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3.583686,
      2,
      NULL,
      NULL,
      NULL,
      0.418021,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.390358,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.571770,
      NULL,
      NULL,
      8.149908,
      2.083398,
      6.502455,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.748414,
      NULL,
      NULL,
      NULL,
      1.956188,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.818264,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.471382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.134190,
      NULL,
      NULL,
      1,
      3,
      3.217310,
      0.925992,
      0.062806,
      0.879955,
      NULL,
      NULL,
      NULL,
      3,
      4.742613,
      2,
      0.201771,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3,
      0,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.677430,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.912554,
      1,
      1,
      NULL,
      1,
      0.061140,
      0.239667,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.134016,
      3.373996,
      NULL,
      1.124064,
      0,
      1,
      2.125116,
      2.824022,
      1,
      NULL,
      4.002972,
      9.541131,
      NULL,
      0,
      1.896092,
      2,
      1.671457,
      NULL,
      1.729768,
      0,
      0.372548,
      1.711731,
      1,
      3,
      2,
      1,
      NULL,
      2.461106,
      5.330712,
      1.593110,
      1.400413,
      NULL,
      1,
      NULL,
      1,
      1.355228,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.630156,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.623395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.624046,
      1,
      NULL,
      0.427189,
      3.698673,
      0,
      NULL,
      NULL,
      0.746557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.623834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.562914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.323623,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.684339,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.729252,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.225364,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.144469,
      NULL,
      0,
      280,
      1.117337,
      1,
      3.356908,
      1.344754,
      1,
      0.195011,
      0,
      1.986953,
      NULL,
      0,
      0.351119,
      0,
      1.141749,
      1.871427,
      0,
      1,
      0.823463,
      NULL,
      3.522009,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.840164,
      NULL,
      NULL,
      NULL,
      2.497635,
      NULL,
      110.966811,
      NULL,
      0,
      11,
      8.571658,
      1.015960,
      1.292780,
      NULL,
      NULL,
      1.101207,
      NULL,
      0.802513,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.442532,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.076249,
      NULL,
      NULL,
      NULL,
      0.250766,
      2,
      NULL,
      1.701045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.338047,
      0.513041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.472186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.242445,
      1.659375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.836975,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      0.517809,
      1,
      1.276987,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.232061,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.898451,
      NULL,
      NULL,
      NULL,
      1.721512,
      NULL,
      0,
      NULL,
      NULL,
      1.461010,
      NULL,
      NULL,
      1.912803,
      0.815391,
      NULL,
      1.936377,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      5,
      NULL,
      0.082519,
      1.385414,
      0.870647,
      0.669897,
      22,
      NULL,
      1,
      4.842814,
      '41013',
      '31122',
      '',
      0.464920,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


