set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7729873';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-7-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      1.053000,
      0,
      3,
      NULL,
      NULL,
      1.531996,
      NULL,
      NULL,
      NULL,
      '10-18-2001',
      NULL,
      NULL,
      NULL,
      2,
      0,
      ' 4-14-1994',
      NULL,
      NULL,
      307,
      78.422317,
      NULL,
      ' 9-15-1989',
      ' 9- 2-1980',
      NULL,
      0.680021,
      0,
      3,
      1,
      0.649290,
      0.980520,
      3,
      1.593753,
      NULL,
      NULL,
      NULL,
      4.140522,
      2,
      17.728163,
      147.113990,
      1,
      40,
      0,
      0,
      0,
      3.584414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1.143982,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4,
      6.334207,
      NULL,
      0.845795,
      1.294240,
      NULL,
      2.726680,
      0,
      3.848823,
      0.239503,
      NULL,
      1.042887,
      1.401657,
      NULL,
      1.691035,
      2,
      1.857100,
      NULL,
      NULL,
      1,
      1,
      3.924159,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      1,
      1,
      1.018410,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      3,
      0,
      1,
      0,
      NULL,
      0,
      2,
      0,
      1,
      0,
      3,
      0,
      1,
      0.842927,
      0.643191,
      ' 0-25-1978',
      41.071477,
      ' 8- 6-1989',
      3,
      3.715647,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0.943764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.443774,
      NULL,
      1.200605,
      0,
      0.746704,
      NULL,
      0.146693,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.540384,
      1.272333,
      1,
      0,
      1,
      0.811822,
      NULL,
      0.785100,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      7.405306,
      2.310428,
      5,
      11,
      4.176569,
      1.504573,
      1,
      NULL,
      NULL,
      0.762092,
      2,
      NULL,
      0,
      NULL,
      NULL,
      65,
      12,
      72,
      0,
      1,
      1,
      '34031',
      NULL,
      '',
      1.624481,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      0.350845,
      29,
      25,
      0.197610,
      1.851001,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.030655,
      3,
      0.364340,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.398335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.881647,
      2.741933,
      NULL,
      1.348837,
      NULL,
      NULL,
      3.226291,
      NULL,
      1.233709,
      0.211411,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      6.199607,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2.804553,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      2,
      0.859028,
      NULL,
      3,
      3,
      NULL,
      2,
      NULL,
      2,
      0,
      NULL,
      1,
      1.620689,
      1.841300,
      0,
      1.579462,
      1.708022,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.791287,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.953528,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.531367,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.697454,
      NULL,
      NULL,
      0.534301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.979878,
      NULL,
      NULL,
      1.734162,
      NULL,
      NULL,
      1.157373,
      NULL,
      NULL,
      0.139617,
      NULL,
      NULL,
      2.525887,
      NULL,
      1,
      0,
      NULL,
      1.204281,
      1,
      0.170221,
      3,
      2.160146,
      4.609928,
      NULL,
      NULL,
      NULL,
      NULL,
      2.759061,
      0,
      2,
      1.433288,
      1,
      0.727018,
      0.260374,
      1,
      NULL,
      NULL,
      NULL,
      1.269073,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.734770,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.647215,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.493712,
      NULL,
      NULL,
      0,
      1.608764,
      1.722209,
      0.113775,
      0.937831,
      2,
      1.851716,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.019568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.423213,
      NULL,
      NULL,
      NULL,
      1.456811,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.542810,
      NULL,
      NULL,
      NULL,
      1.893471,
      NULL,
      NULL,
      NULL,
      0.073304,
      NULL,
      NULL,
      NULL,
      1.037168,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.503277,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.170088,
      NULL,
      NULL,
      0.390347,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.054138,
      NULL,
      NULL,
      NULL,
      NULL,
      0.581714,
      2016,
      494.941283,
      0.972941,
      NULL,
      0,
      1.608790,
      1.541991,
      0.119884,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      0.406282,
      1.121785,
      1,
      NULL,
      0,
      1.720193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.563543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      4.554524,
      1,
      NULL,
      1.178793,
      NULL,
      2,
      2,
      2.521954,
      0.586056,
      NULL,
      13,
      NULL,
      11.282076,
      10.869362,
      NULL,
      5,
      8.795425,
      NULL,
      0.228340,
      NULL,
      NULL,
      1,
      18,
      NULL,
      16,
      19.802905,
      NULL,
      10.891411,
      16,
      NULL,
      11.938616,
      1.664275,
      NULL,
      9,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      1.066044,
      NULL,
      1.413183,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.892028,
      NULL,
      1.070978,
      NULL,
      1,
      2,
      7,
      1,
      NULL,
      NULL,
      25.743506,
      134,
      4,
      0,
      2.122615,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '');
commit;
end;
/


