set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7409886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-11-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '2004222',
      0.286041,
      NULL,
      2,
      0,
      '2414',
      0,
      1.534472,
      NULL,
      NULL,
      ' 5- 6-1982',
      57.414000,
      NULL,
      0,
      1.031167,
      NULL,
      ' 1- 5-2001',
      34,
      2.727309,
      10,
      35.634640,
      2,
      ' 4- 8-1999',
      ' 4-11-1981',
      ' 6-22-1981',
      1.686607,
      0,
      0,
      NULL,
      0.472007,
      2.523837,
      1,
      0.288807,
      0,
      53,
      2,
      2,
      6.955579,
      24,
      15.702888,
      2,
      NULL,
      NULL,
      3,
      2,
      1.052967,
      0,
      1,
      1.097573,
      NULL,
      1,
      NULL,
      0,
      1,
      0.697886,
      1.663567,
      1,
      4,
      NULL,
      1.290471,
      NULL,
      1,
      0,
      1,
      1,
      1,
      3,
      3,
      3,
      0,
      0,
      NULL,
      2,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      1.755381,
      3.781794,
      3.049651,
      2.293110,
      NULL,
      0,
      0,
      2,
      0.049799,
      NULL,
      0.389922,
      2,
      NULL,
      0,
      0,
      1,
      NULL,
      5.489381,
      0,
      NULL,
      0.204117,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1,
      0,
      3,
      5,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      1.929674,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      3,
      1,
      0,
      1,
      4,
      3,
      1,
      4,
      1,
      1,
      NULL,
      1,
      5,
      NULL,
      1,
      1,
      2,
      1,
      7,
      NULL,
      '11- 4-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      0,
      0,
      0,
      0.212170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.267108,
      0,
      4,
      2.978106,
      0,
      5.332533,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.226560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.164934,
      NULL,
      1.232810,
      0,
      0,
      0,
      0.006764,
      14,
      2,
      2,
      7,
      113.809820,
      NULL,
      1,
      0,
      3.231182,
      NULL,
      1,
      1,
      3,
      NULL,
      3,
      NULL,
      3,
      1,
      1,
      2.318601,
      1,
      1,
      2,
      1,
      0,
      3.663781,
      0,
      NULL,
      NULL,
      NULL,
      1.483995,
      1,
      0,
      1.437254,
      NULL,
      0,
      3.025582,
      0,
      NULL,
      10,
      NULL,
      6.817453,
      2,
      4.533582,
      NULL,
      3,
      5.492737,
      0,
      2,
      0,
      37.088380,
      NULL,
      2.282082,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.658631,
      0.359144,
      NULL,
      '',
      '',
      0.209842,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      3,
      28.966513,
      286,
      43,
      2.734977,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3.463816,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      0.235570,
      2.961058,
      0,
      0,
      0.088497,
      NULL,
      NULL,
      NULL,
      2.325346,
      1.090082,
      1.355234,
      NULL,
      NULL,
      0.590482,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0.599351,
      NULL,
      NULL,
      0.573730,
      NULL,
      NULL,
      7.521585,
      7,
      2,
      NULL,
      0,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.869180,
      0.246091,
      3,
      0.407671,
      0.105077,
      NULL,
      NULL,
      2,
      3.342225,
      3.946413,
      3.331104,
      0,
      3,
      2.049939,
      NULL,
      1.619699,
      1,
      NULL,
      2.577044,
      3,
      1.514131,
      1.653260,
      3.024019,
      NULL,
      0.546350,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.716740,
      NULL,
      NULL,
      3.803809,
      3.575474,
      7,
      NULL,
      3.688624,
      1,
      0,
      1.094652,
      0.418103,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      3,
      0,
      3,
      1.555680,
      1.775729,
      1,
      NULL,
      NULL,
      6,
      NULL,
      0,
      NULL,
      3.243811,
      NULL,
      3.320760,
      1,
      NULL,
      2.823181,
      NULL,
      1.322024,
      1,
      NULL,
      NULL,
      0.090853,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.938521,
      NULL,
      1.258190,
      NULL,
      0,
      NULL,
      3.561985,
      1.311143,
      5.187329,
      0,
      NULL,
      NULL,
      7,
      5.387731,
      1,
      3.632203,
      1,
      3,
      0,
      3,
      3,
      NULL,
      3,
      1,
      4.059064,
      4,
      2,
      NULL,
      1,
      0,
      3,
      2.949239,
      3,
      2,
      1,
      0.488463,
      NULL,
      2,
      2,
      5,
      3.246944,
      NULL,
      3,
      2.872836,
      1.161283,
      2,
      0,
      2,
      NULL,
      3,
      0.186106,
      1,
      1,
      3.406267,
      NULL,
      6.043592,
      0,
      NULL,
      15,
      NULL,
      NULL,
      0.007427,
      NULL,
      NULL,
      3.635981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.549340,
      1,
      NULL,
      3.466034,
      0.908226,
      NULL,
      2.577931,
      NULL,
      NULL,
      NULL,
      0.026938,
      NULL,
      2,
      1,
      NULL,
      0,
      3,
      NULL,
      NULL,
      5.721605,
      NULL,
      NULL,
      1,
      1.440678,
      2.698269,
      0,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.165146,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.706730,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.961265,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.637934,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.538935,
      0,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      3.610830,
      3.022510,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.542877,
      NULL,
      NULL,
      0.280745,
      0.553514,
      NULL,
      NULL,
      10.773545,
      1.703731,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.861867,
      NULL,
      11,
      3.816847,
      6,
      3.038431,
      1.889226,
      NULL,
      NULL,
      1,
      NULL,
      4,
      1.073052,
      74.110317,
      NULL,
      NULL,
      46.000802,
      2,
      1,
      NULL,
      1.325878,
      233,
      1.414923,
      1.654872,
      0.304004,
      NULL,
      0.614949,
      0,
      1,
      1,
      0.119010,
      0.417077,
      1.352498,
      1.309229,
      1,
      1,
      NULL,
      1,
      1,
      0.337157,
      0.658058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.303806,
      1.981037,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.031956,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.124262,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.483403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414521,
      NULL,
      NULL,
      NULL,
      0.174755,
      NULL,
      1,
      NULL,
      1.494720,
      1.404161,
      0.273155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0.966997,
      1.941684,
      0.448360,
      2,
      1.859373,
      NULL,
      2,
      1,
      0.362630,
      0.884298,
      NULL,
      1,
      1,
      3,
      0.645690,
      0,
      NULL,
      1.571355,
      0.506139,
      0,
      1.128452,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0.945372,
      1,
      0,
      1,
      NULL,
      0.411093,
      0,
      NULL,
      3,
      1,
      1,
      3.963042,
      1,
      1.653594,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.466116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.192107,
      1,
      NULL,
      1.756621,
      1,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      122.674562,
      22.426879,
      4,
      NULL,
      3,
      '12102',
      '',
      '',
      1.498859,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


