set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8910324';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      '1112111',
      1.242999,
      1,
      0,
      2,
      '1312',
      2.233787,
      1,
      NULL,
      NULL,
      NULL,
      14.162652,
      NULL,
      4,
      3,
      0,
      ' 1-26-1981',
      NULL,
      1,
      253,
      120.569561,
      2,
      NULL,
      NULL,
      ' 2- 1-1981',
      1.425891,
      1.943298,
      1,
      NULL,
      0.842152,
      1,
      NULL,
      NULL,
      NULL,
      9.981653,
      1,
      17.955273,
      3.758485,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.072362,
      NULL,
      1,
      0.220540,
      1,
      1.960282,
      0,
      0,
      1.315997,
      NULL,
      0,
      0,
      2,
      NULL,
      2.358816,
      5,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.629391,
      NULL,
      NULL,
      0,
      1,
      1.707159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1,
      4,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1.760063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      5,
      0,
      4,
      1,
      1,
      3,
      1,
      4,
      1,
      1,
      NULL,
      2,
      ' 2-10-1985',
      123,
      ' 3-14-1982',
      NULL,
      0.181530,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0.877772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1435,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.166900,
      NULL,
      1.535990,
      1,
      NULL,
      NULL,
      0.347430,
      5.430795,
      0,
      5,
      NULL,
      0.937861,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.844078,
      0,
      1,
      NULL,
      3.852651,
      1,
      NULL,
      1.162619,
      46,
      2,
      0.611042,
      NULL,
      NULL,
      NULL,
      1,
      1.225760,
      1,
      3,
      3,
      2,
      NULL,
      2,
      3,
      2,
      3,
      1,
      0,
      3,
      NULL,
      NULL,
      0.329632,
      NULL,
      0,
      0,
      0.850369,
      0.612511,
      1.695570,
      1,
      0.014016,
      1,
      0.726122,
      NULL,
      1,
      1.072347,
      3.800003,
      0,
      1,
      0,
      1.329288,
      11,
      3,
      4,
      NULL,
      2.404791,
      3,
      1.808091,
      1,
      2.283026,
      62.810166,
      0,
      3,
      NULL,
      70,
      NULL,
      104.952178,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      '0431',
      '2320',
      '1240',
      3.274375,
      30,
      422.630758,
      2.673942,
      NULL,
      10,
      14.659593,
      NULL,
      2,
      NULL,
      3.851681,
      2.842133,
      0.978764,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.957946,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.248101,
      NULL,
      NULL,
      0.102027,
      NULL,
      NULL,
      1.382889,
      NULL,
      2.605498,
      0,
      1.657261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.117251,
      NULL,
      NULL,
      0,
      1,
      2,
      0.761542,
      NULL,
      NULL,
      NULL,
      NULL,
      5.913967,
      0.424042,
      NULL,
      NULL,
      0.995555,
      NULL,
      NULL,
      0.528537,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.237977,
      NULL,
      NULL,
      0.595822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.245134,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.622108,
      NULL,
      NULL,
      1.511751,
      NULL,
      NULL,
      0.762685,
      NULL,
      NULL,
      0.015002,
      NULL,
      2.552899,
      0,
      1.076284,
      1,
      7.733923,
      6,
      3,
      2.254608,
      0.682775,
      3.019938,
      1.172766,
      0,
      3.046860,
      0.092255,
      0.476348,
      0.680673,
      0.940784,
      0,
      1,
      10.308885,
      NULL,
      8.978437,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      0.587199,
      0.684509,
      0.908735,
      3.075348,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.529825,
      NULL,
      NULL,
      0.052071,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.097991,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.167741,
      NULL,
      NULL,
      1.695408,
      NULL,
      NULL,
      0.732941,
      NULL,
      NULL,
      NULL,
      3.219989,
      0.033635,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.106608,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.044450,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.895951,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.507842,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      2.450105,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.952788,
      NULL,
      NULL,
      3.252883,
      NULL,
      NULL,
      NULL,
      4.039749,
      1.494614,
      NULL,
      NULL,
      0,
      2.986376,
      NULL,
      1,
      3,
      46.251030,
      2,
      2.749815,
      3.426346,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      295,
      0.652677,
      0,
      0.835219,
      NULL,
      0.506879,
      0,
      1.266043,
      0.698170,
      0,
      0,
      1,
      0.490707,
      0,
      NULL,
      1,
      NULL,
      0.145573,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.744163,
      5,
      0.003702,
      0.689794,
      0,
      7,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.277841,
      NULL,
      NULL,
      1.012802,
      1,
      2.813017,
      NULL,
      1.501213,
      0.498460,
      1.514333,
      1,
      0,
      2,
      0,
      0,
      0.618570,
      2,
      1,
      3,
      1,
      3.877464,
      3,
      0,
      0.182286,
      NULL,
      0.708157,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      3,
      1.112196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643020,
      3.463934,
      NULL,
      0.181834,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      0.904816,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.240498,
      NULL,
      NULL,
      NULL,
      3.298683,
      NULL,
      0.720611,
      8,
      3.301640,
      NULL,
      0,
      0.070966,
      1,
      NULL,
      1,
      0.247693,
      NULL,
      5,
      3,
      3.824862,
      1.123873,
      0.022705,
      48.555050,
      9.980451,
      0,
      0,
      0.792075,
      NULL,
      '',
      '',
      2.881020,
      '21041',
      '',
      NULL,
      2.910664,
      '2303',
      NULL,
      '4013');
commit;
end;
/


