set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8723633';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-1-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '4004243',
      3,
      0.495955,
      3,
      2,
      '0022',
      NULL,
      1,
      NULL,
      NULL,
      ' 0- 1-1990',
      NULL,
      NULL,
      2,
      2,
      0,
      ' 7- 1-1983',
      4.885688,
      0,
      217.784279,
      12,
      1,
      ' 7-22-1986',
      ' 5-17-1987',
      ' 2-21-1997',
      3,
      NULL,
      0.541053,
      1.292187,
      0,
      0,
      NULL,
      2.334978,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      2.856029,
      154,
      1,
      6.379703,
      3,
      NULL,
      9,
      0,
      3,
      1,
      0,
      1.815363,
      0.654903,
      NULL,
      1,
      1.640862,
      1.279526,
      NULL,
      3,
      4,
      4,
      1.762976,
      3,
      0,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      4.712361,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0,
      5,
      2,
      0.862866,
      0,
      1,
      3.443880,
      2,
      1.758814,
      3,
      2.850204,
      2.736373,
      3,
      3,
      NULL,
      0.094594,
      0.192387,
      1,
      1,
      NULL,
      NULL,
      2.771469,
      1,
      2,
      3.070915,
      0.110980,
      NULL,
      NULL,
      0.837580,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      3,
      1,
      3,
      1,
      0,
      0,
      0,
      0,
      1,
      3,
      0,
      0,
      0,
      1,
      0,
      NULL,
      0.085700,
      0,
      1,
      0,
      0,
      NULL,
      3,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      3,
      NULL,
      2,
      5,
      3,
      2,
      NULL,
      3,
      2,
      0,
      1,
      0,
      2,
      2,
      NULL,
      NULL,
      ' 3-15-1978',
      NULL,
      1,
      NULL,
      1,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      19.899914,
      689,
      0,
      1,
      0,
      1,
      1,
      1,
      1.319595,
      0,
      NULL,
      0.943503,
      NULL,
      3.945994,
      1,
      3,
      0.793535,
      0,
      0,
      NULL,
      NULL,
      0,
      5,
      0.738461,
      NULL,
      NULL,
      0,
      1.106274,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      0.665321,
      0,
      1.000163,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      2,
      2,
      2,
      NULL,
      3,
      NULL,
      1,
      1,
      2,
      2,
      0.469737,
      9.787718,
      0.243704,
      NULL,
      1,
      5.827795,
      1,
      0,
      0.274990,
      NULL,
      NULL,
      1,
      1.657755,
      0.482391,
      NULL,
      2.129748,
      1.988337,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      26,
      NULL,
      23,
      4,
      0.848732,
      3,
      '32211',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.716901,
      '',
      '',
      '',
      0.955674,
      29,
      4,
      1.479994,
      0,
      16.574625,
      NULL,
      3,
      4,
      1,
      2.277198,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.934012,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.974876,
      NULL,
      0.744170,
      NULL,
      NULL,
      2.783886,
      2.250981,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747299,
      NULL,
      NULL,
      0.738287,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.264901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.705058,
      0.247404,
      NULL,
      1,
      1.962502,
      NULL,
      0,
      0,
      1,
      NULL,
      1.743986,
      NULL,
      NULL,
      3.900680,
      0.938061,
      1.873689,
      2.193382,
      1,
      1,
      1.130235,
      3,
      1.459389,
      NULL,
      NULL,
      1.837101,
      NULL,
      NULL,
      1.850337,
      NULL,
      NULL,
      0.223933,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.280448,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.251437,
      0,
      1.677451,
      NULL,
      0.469942,
      1,
      NULL,
      NULL,
      7,
      3.348514,
      0,
      1,
      NULL,
      NULL,
      1.478523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.790615,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.889917,
      NULL,
      NULL,
      0.536873,
      NULL,
      NULL,
      0.753501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0.453394,
      NULL,
      NULL,
      0.636811,
      NULL,
      NULL,
      3,
      3.994995,
      0,
      2.781941,
      3,
      0.192224,
      1.340382,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.748365,
      NULL,
      NULL,
      2.760539,
      0.223799,
      1.247218,
      3,
      3,
      1,
      9,
      4,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.270256,
      0,
      NULL,
      1.089312,
      3.855885,
      NULL,
      NULL,
      0.412955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.444330,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215340,
      NULL,
      NULL,
      1.146937,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.890571,
      1.333181,
      1,
      1.339542,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.392781,
      3.371710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.770657,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.254237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.022139,
      1.993036,
      NULL,
      NULL,
      1.036145,
      1.464012,
      NULL,
      NULL,
      1.565384,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.714444,
      1.292821,
      NULL,
      NULL,
      NULL,
      0.719619,
      NULL,
      NULL,
      NULL,
      0.074607,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.106446,
      1.046737,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.564185,
      NULL,
      NULL,
      NULL,
      1.399171,
      NULL,
      NULL,
      NULL,
      2,
      3.243994,
      2,
      1.339237,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      2.646219,
      1,
      NULL,
      NULL,
      1.465820,
      NULL,
      NULL,
      1.852589,
      NULL,
      NULL,
      2630,
      NULL,
      0.713057,
      1.768912,
      NULL,
      0,
      0,
      0,
      0.392690,
      1.433900,
      1.894016,
      0.700485,
      NULL,
      1.828793,
      0.696208,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      4,
      3.662986,
      3,
      5,
      3,
      NULL,
      2.022753,
      1.879045,
      NULL,
      0.340381,
      1.094866,
      0.110095,
      0.699540,
      1.876029,
      1,
      NULL,
      2.539776,
      2,
      1.825594,
      0,
      0,
      NULL,
      1.022149,
      2,
      1.789930,
      1.197385,
      NULL,
      NULL,
      0,
      0,
      1.841646,
      0.287580,
      NULL,
      NULL,
      2,
      1.764630,
      3,
      3,
      1.078526,
      1,
      2,
      3,
      NULL,
      2,
      0.122934,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.336845,
      NULL,
      2.875298,
      NULL,
      0.313643,
      NULL,
      2.335301,
      NULL,
      3.761708,
      NULL,
      1.210551,
      NULL,
      2.881368,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.889830,
      NULL,
      0,
      NULL,
      2.036934,
      NULL,
      0,
      7,
      0,
      NULL,
      1.739873,
      0.204525,
      1,
      0.393267,
      1,
      NULL,
      0,
      0,
      4,
      NULL,
      NULL,
      NULL,
      32.628353,
      94,
      1,
      NULL,
      3,
      '11230',
      '',
      '',
      0.505996,
      '',
      '',
      '',
      0.629382,
      '',
      '',
      '');
commit;
end;
/


