set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9659695';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-6-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '02',
      '42',
      22,
      27,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '3214',
      5.288161,
      1,
      NULL,
      NULL,
      ' 4- 9-1991',
      39,
      13.828940,
      NULL,
      2,
      0,
      ' 1-27-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '10- 1-1974',
      NULL,
      '10- 5-1994',
      0,
      3,
      2.941358,
      1.199639,
      0.505929,
      3.902654,
      1,
      NULL,
      NULL,
      NULL,
      8,
      19.767234,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      1.283152,
      2,
      0,
      0,
      0,
      NULL,
      0,
      0,
      2.123205,
      0.975195,
      1,
      NULL,
      4,
      1,
      3.451652,
      2,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      1.701155,
      NULL,
      NULL,
      0.282492,
      NULL,
      NULL,
      2,
      0,
      1,
      3,
      1.635899,
      1,
      1,
      0,
      0,
      1,
      NULL,
      3,
      0,
      0.768663,
      1.462915,
      0.105788,
      1,
      0,
      0,
      0,
      0,
      NULL,
      2,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      5,
      1,
      1,
      NULL,
      4,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      0.749057,
      NULL,
      0.032975,
      1,
      3,
      1,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      2,
      0,
      1,
      2,
      NULL,
      NULL,
      4,
      NULL,
      1,
      NULL,
      NULL,
      4,
      NULL,
      3,
      1,
      0,
      5,
      1,
      ' 1-25-1978',
      102.403999,
      ' 6-10-1995',
      28.957944,
      NULL,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      5,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.976776,
      1.929112,
      0,
      0,
      NULL,
      NULL,
      0.164977,
      NULL,
      0.034686,
      1,
      0.692714,
      NULL,
      NULL,
      NULL,
      1.400519,
      0.312301,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.494962,
      1.068928,
      3.126240,
      NULL,
      1,
      0.688920,
      2.326023,
      25.933400,
      0.075028,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.217445,
      0,
      3,
      0,
      3,
      2,
      0,
      0,
      NULL,
      3,
      0,
      NULL,
      3,
      2.317596,
      2.623792,
      0,
      1.120225,
      5.598156,
      1,
      0.786667,
      0.597579,
      0.011615,
      NULL,
      0,
      0.429552,
      0,
      0,
      0.883188,
      1,
      1.933366,
      2.214360,
      2.790411,
      5.989011,
      NULL,
      4,
      5,
      3,
      0,
      3.575303,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      29,
      0,
      1,
      3.116784,
      3,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      1.173833,
      27,
      4,
      NULL,
      0,
      6.074625,
      3.252880,
      4,
      5,
      NULL,
      0.146896,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.131022,
      3,
      2,
      0,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.721950,
      NULL,
      NULL,
      0.207980,
      NULL,
      NULL,
      1.570023,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      0,
      0.505949,
      NULL,
      NULL,
      NULL,
      0.041428,
      NULL,
      NULL,
      NULL,
      0.393184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.930602,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.571818,
      0,
      0,
      0.542984,
      3,
      NULL,
      1,
      NULL,
      NULL,
      5,
      7,
      6,
      2,
      2.496922,
      1.168996,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0.738296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.182055,
      NULL,
      NULL,
      1.547619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.811431,
      NULL,
      NULL,
      NULL,
      NULL,
      5.864693,
      4.020630,
      NULL,
      1.496913,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.464654,
      3.919126,
      2,
      1.677043,
      NULL,
      NULL,
      NULL,
      NULL,
      1.993270,
      1,
      NULL,
      NULL,
      1.963631,
      NULL,
      NULL,
      0.672569,
      1.520723,
      NULL,
      3,
      3.774703,
      3,
      2,
      6,
      NULL,
      5,
      0.965636,
      1.096338,
      2.252031,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0.576716,
      0,
      1,
      NULL,
      NULL,
      0.461255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.818337,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5.208030,
      NULL,
      NULL,
      0.058597,
      0,
      1.328106,
      1.179951,
      0,
      0.510173,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.311871,
      NULL,
      NULL,
      NULL,
      1.303883,
      NULL,
      NULL,
      NULL,
      0.578586,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.380712,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.316309,
      NULL,
      0,
      NULL,
      NULL,
      1.476638,
      NULL,
      NULL,
      2.756787,
      1.888860,
      7,
      0.995732,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.360382,
      23.312160,
      348.695384,
      0,
      0,
      NULL,
      1.315371,
      NULL,
      0,
      NULL,
      1,
      1.511302,
      0.845239,
      0,
      NULL,
      NULL,
      0,
      0.375018,
      NULL,
      NULL,
      0.293797,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.401458,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.431111,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.463630,
      1.288762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.342656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      2,
      6.460574,
      NULL,
      1,
      11,
      3.081565,
      3,
      1.040933,
      0.224682,
      3.920934,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.810292,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3.751794,
      0,
      NULL,
      1,
      1.609825,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.294730,
      0.686144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830537,
      NULL,
      0.150106,
      NULL,
      1,
      NULL,
      2,
      1.816680,
      NULL,
      NULL,
      49.183729,
      66,
      1,
      NULL,
      1.565895,
      '01140',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      1.990102,
      '',
      '',
      '');
commit;
end;
/


