set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7931775';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-8-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      3,
      0,
      '1423',
      0,
      0,
      NULL,
      NULL,
      ' 0-15-1992',
      5.939187,
      NULL,
      2,
      1,
      0,
      ' 2-18-1996',
      7,
      2.963815,
      NULL,
      663.889884,
      2,
      ' 2- 1-1982',
      ' 9-24-1996',
      NULL,
      0.409157,
      NULL,
      NULL,
      1,
      1,
      NULL,
      2,
      1,
      1,
      146,
      3,
      1.303135,
      1.378740,
      NULL,
      37.322572,
      4,
      13.886381,
      2,
      3,
      3.136019,
      0.257741,
      1,
      0,
      NULL,
      1,
      NULL,
      0.495728,
      NULL,
      1,
      1,
      NULL,
      0,
      6,
      7,
      0.615805,
      1,
      0,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0,
      10.958703,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.760040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      4,
      2,
      2,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1.414887,
      1,
      0,
      0,
      1,
      1,
      NULL,
      0,
      5,
      1,
      0,
      1,
      2,
      0,
      NULL,
      3,
      NULL,
      0,
      3,
      0,
      1,
      NULL,
      5,
      1,
      3,
      5,
      1,
      0,
      2,
      NULL,
      1,
      2,
      NULL,
      5.577308,
      0,
      ' 8- 7-1976',
      NULL,
      ' 7-14-1979',
      NULL,
      2,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      1.627123,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.015034,
      0,
      0,
      0.171184,
      0.215907,
      2,
      4077,
      1.559322,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.001144,
      10,
      3.607072,
      3.442880,
      NULL,
      NULL,
      2.782023,
      1.747886,
      5,
      2,
      3,
      0.196258,
      70.645395,
      NULL,
      1.500692,
      NULL,
      NULL,
      9,
      NULL,
      5,
      0,
      0.519534,
      '43304',
      '',
      '',
      0.427074,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      17.670238,
      126,
      14.373789,
      NULL,
      0.582057,
      NULL,
      257.932458,
      4,
      0,
      0.268524,
      2.583545,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.383014,
      NULL,
      NULL,
      2.868333,
      2.809968,
      3.759951,
      0.003395,
      NULL,
      NULL,
      1,
      1.534088,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.306194,
      NULL,
      NULL,
      0.297780,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.293749,
      6.264677,
      1,
      0.914906,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.501295,
      1.698556,
      2.674762,
      0.869354,
      NULL,
      NULL,
      1.777457,
      NULL,
      NULL,
      NULL,
      1.501040,
      0,
      0,
      0,
      1.313970,
      1,
      0.073056,
      NULL,
      0.155352,
      1.078553,
      1,
      NULL,
      0,
      0.916694,
      1.741319,
      0.017993,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7.179570,
      7.119231,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.694993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.227569,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      5.382460,
      NULL,
      NULL,
      3,
      0.416726,
      NULL,
      NULL,
      8,
      2.253169,
      NULL,
      0.367442,
      NULL,
      NULL,
      1.967442,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.523288,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2.078507,
      1,
      NULL,
      3.469480,
      6,
      NULL,
      1,
      NULL,
      1,
      4,
      2,
      NULL,
      NULL,
      1.077881,
      0.449216,
      0.582791,
      2,
      NULL,
      2.993121,
      NULL,
      0,
      3.938619,
      2.205291,
      10.034258,
      0,
      0,
      2.881498,
      0.427958,
      0.594525,
      1,
      2,
      2,
      3,
      2,
      0.374497,
      NULL,
      3,
      NULL,
      5.256758,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      4,
      1,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.967124,
      NULL,
      NULL,
      0.461984,
      NULL,
      NULL,
      2.947573,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1.248673,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.432302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.677335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.688246,
      NULL,
      NULL,
      NULL,
      2,
      0.794942,
      NULL,
      NULL,
      0.190332,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.613113,
      0.282405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      6,
      0.919720,
      140,
      35,
      1.653094,
      105.003762,
      7,
      1.021441,
      NULL,
      NULL,
      3,
      125,
      1747.288326,
      1.772121,
      1028,
      447.822220,
      NULL,
      NULL,
      851,
      NULL,
      15.037972,
      1.774690,
      19475,
      975.794157,
      1.249328,
      0.591722,
      1,
      1.403251,
      0.148346,
      0.686640,
      0,
      1.708499,
      1,
      1.565406,
      0,
      NULL,
      0,
      0,
      1.235208,
      1.160377,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.679198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      12.898577,
      3.654764,
      2.713263,
      3,
      2,
      13,
      0,
      0.065825,
      3.691060,
      4.494658,
      1.614131,
      NULL,
      8.266473,
      9,
      1.535878,
      NULL,
      0,
      2,
      17,
      1.465897,
      1.148149,
      NULL,
      1.238701,
      0,
      NULL,
      17,
      1,
      1.449521,
      2,
      1.683331,
      6,
      0,
      1,
      NULL,
      NULL,
      1.743963,
      NULL,
      3,
      0,
      2,
      1,
      0,
      3.517190,
      0,
      0.541662,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635819,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.033003,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.395186,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.867932,
      2.071862,
      NULL,
      1.807199,
      1,
      1.220038,
      2.692667,
      0.557099,
      0.993897,
      2,
      NULL,
      0,
      1,
      2,
      NULL,
      0,
      9,
      5,
      NULL,
      3,
      '21002',
      '',
      '',
      1.333094,
      '',
      '',
      '',
      0.866230,
      '',
      '',
      '');
commit;
end;
/


