set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9333174';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-12-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      0.376291,
      4,
      3,
      '4024',
      1,
      0,
      NULL,
      NULL,
      ' 9-23-1977',
      40,
      NULL,
      1,
      3,
      0.671853,
      ' 1-28-1988',
      0,
      NULL,
      NULL,
      107.074287,
      NULL,
      ' 5-18-1979',
      NULL,
      ' 1- 7-1975',
      2,
      0.866075,
      0.125729,
      0,
      1,
      0.721134,
      3,
      1.359464,
      1.848851,
      NULL,
      5,
      NULL,
      4,
      6.159041,
      17,
      0,
      1,
      0,
      NULL,
      3,
      1,
      0,
      1,
      1,
      0,
      1.531556,
      1.183541,
      3.214576,
      1,
      NULL,
      0,
      3,
      NULL,
      0,
      0,
      1,
      NULL,
      1,
      4,
      2,
      0,
      3,
      1,
      2,
      0,
      1,
      1,
      8,
      NULL,
      1,
      0,
      0,
      1.813639,
      NULL,
      NULL,
      0.173325,
      NULL,
      NULL,
      1,
      0,
      0.563016,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      3,
      5,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      0.353462,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      2,
      5,
      0,
      1,
      0,
      4,
      1,
      0,
      2,
      NULL,
      1,
      2,
      5,
      NULL,
      2,
      5,
      NULL,
      NULL,
      2,
      1.093627,
      ' 6-14-1977',
      NULL,
      ' 3- 4-1989',
      37.845574,
      1.767850,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5,
      NULL,
      1,
      1,
      1,
      0.424383,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      15.847070,
      2.370838,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.314089,
      NULL,
      1.550850,
      0.575724,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      0.759193,
      1.442398,
      NULL,
      NULL,
      2.491032,
      5,
      1,
      1.362555,
      NULL,
      NULL,
      NULL,
      NULL,
      0.532512,
      1,
      2,
      1,
      NULL,
      0,
      0,
      3,
      3,
      0,
      NULL,
      2,
      2,
      0.537152,
      0,
      NULL,
      0.137309,
      1.081128,
      0,
      NULL,
      0,
      0.555959,
      0.066562,
      1,
      0.008304,
      1.421503,
      1.583011,
      0,
      1.525487,
      NULL,
      1,
      11.101993,
      0,
      NULL,
      4,
      8,
      3,
      1.064133,
      NULL,
      6.838098,
      0,
      0.372157,
      0,
      38,
      0,
      2.675103,
      NULL,
      39,
      56,
      4,
      5,
      1.100898,
      0,
      '00040',
      NULL,
      NULL,
      0.283174,
      '',
      '',
      '',
      1.768500,
      '',
      '',
      NULL,
      NULL,
      NULL,
      21,
      51.983227,
      0.865582,
      37,
      NULL,
      0,
      2,
      0.847230,
      0,
      0,
      1.211803,
      NULL,
      NULL,
      2.688811,
      1.556616,
      1.237898,
      0.579037,
      NULL,
      0.890790,
      2.286080,
      NULL,
      3.448569,
      1.992184,
      NULL,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.073914,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.448429,
      2.995556,
      2.904535,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.898495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.471408,
      NULL,
      NULL,
      1.121314,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.487714,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.503439,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.712029,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.956790,
      3,
      NULL,
      1,
      NULL,
      NULL,
      0,
      2.628402,
      0.632937,
      1,
      4.791456,
      0.945260,
      3,
      NULL,
      NULL,
      0.295922,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.464986,
      NULL,
      3,
      3,
      1.306641,
      1.464261,
      1,
      2.840794,
      1,
      0,
      2,
      3,
      2,
      0,
      3.250367,
      0,
      0.259983,
      NULL,
      3,
      NULL,
      4.690251,
      4,
      1.202838,
      0.187359,
      3,
      2,
      1.890264,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.511344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.649111,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.969067,
      NULL,
      NULL,
      0.889819,
      NULL,
      NULL,
      0.665892,
      NULL,
      NULL,
      1.126591,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.940438,
      1,
      1.010008,
      NULL,
      NULL,
      3.657072,
      NULL,
      NULL,
      NULL,
      2.088506,
      NULL,
      NULL,
      NULL,
      87.890726,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.898558,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.098335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.412716,
      NULL,
      NULL,
      NULL,
      2.073037,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.758720,
      NULL,
      NULL,
      NULL,
      2.976806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.193844,
      NULL,
      NULL,
      NULL,
      0.438494,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.370521,
      0.477858,
      NULL,
      2.883747,
      0,
      1.302008,
      0,
      NULL,
      NULL,
      2.745205,
      2,
      1,
      1.910858,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.837464,
      NULL,
      0.833827,
      87.421991,
      1,
      NULL,
      0,
      0,
      2,
      NULL,
      NULL,
      1.821657,
      0,
      NULL,
      1.316791,
      NULL,
      NULL,
      0.700271,
      NULL,
      0.487918,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      4,
      28,
      38,
      0.295211,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.932556,
      NULL,
      0.710599,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.301929,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.401925,
      NULL,
      1.196408,
      NULL,
      0,
      NULL,
      0,
      1.750149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      2,
      1,
      NULL,
      3,
      0,
      10.158982,
      0.257193,
      1,
      0,
      0.705347,
      0.527207,
      NULL,
      0,
      0.556033,
      NULL,
      1.909897,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      0.199750,
      1,
      NULL,
      0.975663,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.470534,
      NULL,
      0.814624,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.413256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.861672,
      NULL,
      2,
      4,
      5,
      0,
      NULL,
      NULL,
      43.580389,
      9,
      4,
      0,
      NULL,
      '21432',
      NULL,
      '',
      0.064251,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


