set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8621104';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      4.894016,
      0.252380,
      5.964775,
      0,
      0,
      6.135891,
      0.725026,
      '233',
      '24041003',
      NULL,
      69,
      '2023041',
      3.058064,
      1.403076,
      2,
      0,
      '0303',
      5,
      1,
      NULL,
      NULL,
      NULL,
      49.424886,
      54,
      NULL,
      3,
      0,
      ' 7-14-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-28-1990',
      ' 0-17-1976',
      NULL,
      0,
      1.518119,
      NULL,
      0.827038,
      1,
      0.597829,
      0,
      1,
      NULL,
      NULL,
      NULL,
      4,
      7.672881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.238035,
      3,
      0,
      1,
      1,
      0,
      1.225090,
      3.303734,
      0.870333,
      NULL,
      1.419200,
      3,
      2,
      NULL,
      2.744695,
      2,
      NULL,
      4,
      0,
      4,
      4,
      0,
      2,
      4,
      1,
      NULL,
      2,
      6,
      1,
      NULL,
      0,
      2,
      1.524805,
      NULL,
      NULL,
      2,
      0,
      2,
      2,
      5,
      0.718937,
      3.206598,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.967879,
      3.843389,
      1,
      1,
      2,
      1,
      2,
      2.718742,
      0.626995,
      1,
      0,
      NULL,
      0,
      5,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      2.960304,
      1,
      0,
      0,
      2,
      5,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      4,
      0,
      1,
      NULL,
      2,
      4,
      1,
      4,
      0,
      1,
      NULL,
      1,
      NULL,
      4,
      0,
      0,
      1,
      NULL,
      NULL,
      3,
      2,
      0,
      NULL,
      2,
      ' 8-20-1979',
      6,
      NULL,
      5.041918,
      3.668156,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3,
      NULL,
      0,
      1,
      0.083519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.206551,
      3.958930,
      0,
      0,
      0.938895,
      1,
      1,
      2.585684,
      8.676204,
      5,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      5.858210,
      3.367507,
      3.717516,
      3.904763,
      0,
      5.441647,
      0,
      0,
      0,
      3.052482,
      10.804830,
      0,
      0,
      2,
      NULL,
      5.507101,
      ' 3-11-1992',
      6.905859,
      ' 4- 6-1994',
      1,
      0,
      0,
      0,
      2.648099,
      1.927049,
      0,
      1.873447,
      1.397690,
      NULL,
      1,
      2.890218,
      NULL,
      1.734885,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.164502,
      3,
      2,
      2,
      1,
      1,
      2,
      3,
      2,
      3,
      3,
      0,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.763272,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      0.154118,
      3,
      NULL,
      0,
      0.235798,
      4.164318,
      0,
      5.907514,
      1,
      7.148597,
      0,
      3.523103,
      2,
      45,
      2,
      2.004658,
      50,
      NULL,
      NULL,
      19,
      4,
      5.813788,
      3.950540,
      '44220',
      '44312',
      '10401',
      NULL,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      15,
      36.699744,
      31.724829,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.456857,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.927406,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.654965,
      NULL,
      NULL,
      0.163204,
      NULL,
      NULL,
      0.395255,
      NULL,
      NULL,
      0.742191,
      NULL,
      NULL,
      0.816839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.366915,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.362192,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842975,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.833895,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0.700596,
      NULL,
      NULL,
      2,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.922526,
      NULL,
      NULL,
      1.488988,
      NULL,
      NULL,
      1.958275,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      NULL,
      5.742878,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2.220069,
      0.250390,
      0,
      0,
      2,
      0,
      1,
      5,
      2,
      2.963868,
      3.117163,
      0,
      NULL,
      NULL,
      0.492142,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      NULL,
      1,
      0,
      NULL,
      0.363105,
      NULL,
      NULL,
      1,
      1,
      0.840559,
      1,
      0.892902,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      3,
      1.509870,
      0.958766,
      0,
      1,
      NULL,
      NULL,
      NULL,
      38.850688,
      NULL,
      NULL,
      NULL,
      1.337084,
      NULL,
      NULL,
      NULL,
      3.545663,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.461730,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.750568,
      NULL,
      NULL,
      NULL,
      1.293749,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323687,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.594947,
      1,
      3,
      12.341220,
      NULL,
      0.562884,
      NULL,
      NULL,
      0.892471,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.604784,
      NULL,
      NULL,
      237,
      NULL,
      1,
      0.566428,
      1,
      0.787637,
      NULL,
      NULL,
      3,
      1.442650,
      NULL,
      1,
      NULL,
      1.773186,
      NULL,
      1.418378,
      0.247854,
      0.521835,
      3.819167,
      NULL,
      0.661256,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.540727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298199,
      NULL,
      3,
      NULL,
      2,
      0.866038,
      NULL,
      0.144505,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.132644,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.228305,
      NULL,
      0.509165,
      0.697716,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.203203,
      3.633574,
      NULL,
      0,
      NULL,
      1.570887,
      NULL,
      NULL,
      NULL,
      1.640641,
      NULL,
      1.931741,
      NULL,
      0,
      NULL,
      NULL,
      0.089684,
      NULL,
      NULL,
      0,
      NULL,
      0.402268,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.217288,
      NULL,
      NULL,
      NULL,
      1.526586,
      0.789338,
      3.815173,
      NULL,
      1.112271,
      NULL,
      0.121742,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.975260,
      NULL,
      NULL,
      0.656771,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.548845,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.287814,
      NULL,
      0,
      1.741054,
      NULL,
      2.776232,
      NULL,
      32.790253,
      NULL,
      3,
      NULL,
      3,
      NULL,
      3,
      NULL,
      NULL,
      1.147305,
      19.816303,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      2,
      0,
      3.746691,
      2,
      0.142765,
      1,
      2,
      NULL,
      3.553514,
      1,
      1,
      NULL,
      1,
      NULL,
      0.529430,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.109076,
      0,
      NULL,
      1.158178,
      1,
      NULL,
      3.166751,
      NULL,
      NULL,
      1,
      2.581863,
      NULL,
      NULL,
      2.181701,
      NULL,
      0.529431,
      0.971240,
      NULL,
      1.443948,
      NULL,
      NULL,
      NULL,
      0.105053,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      0.467144,
      1.559815,
      3,
      35,
      39.751629,
      4,
      0,
      NULL,
      '34400',
      '21312',
      '03434',
      0.524711,
      '',
      '',
      '',
      0.094847,
      NULL,
      NULL,
      '');
commit;
end;
/


