set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0153407';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.956224,
      1,
      NULL,
      1.926963,
      NULL,
      3.606159,
      1,
      0.897193,
      '411',
      '04103111',
      NULL,
      58.935619,
      '4243000',
      2,
      1,
      4,
      1,
      '1410',
      3,
      0,
      NULL,
      NULL,
      '10- 5-1982',
      NULL,
      28.491742,
      NULL,
      0,
      3.355625,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 5-27-1976',
      0,
      0.505051,
      2.930396,
      3,
      1.804530,
      NULL,
      0,
      2.091643,
      NULL,
      NULL,
      NULL,
      11.564052,
      0.976978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633164,
      3,
      0,
      1.157701,
      0,
      NULL,
      1.245666,
      0,
      1.340264,
      NULL,
      0,
      NULL,
      2,
      1,
      1.185689,
      2,
      NULL,
      3,
      0,
      3,
      0,
      5,
      1,
      1,
      0,
      0,
      1,
      6.308838,
      1,
      1,
      1,
      1,
      1.391071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      0.304635,
      3.583359,
      0,
      NULL,
      1.371272,
      NULL,
      NULL,
      1.471018,
      0.552554,
      0.016266,
      0.310554,
      1,
      0.958804,
      1.301634,
      1.845835,
      0,
      0,
      1,
      0,
      4,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.470730,
      NULL,
      NULL,
      0,
      NULL,
      0,
      4,
      NULL,
      3,
      2,
      1,
      1,
      0,
      NULL,
      0,
      0,
      2,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      1.571757,
      NULL,
      1,
      0,
      2,
      0,
      3,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      4,
      5,
      NULL,
      5,
      NULL,
      0,
      2,
      3,
      1,
      0,
      3,
      3,
      0,
      NULL,
      NULL,
      ' 7-24-1994',
      NULL,
      '11- 4-1981',
      80,
      3,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      8.926756,
      3.811715,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4,
      1,
      4,
      NULL,
      0.700442,
      NULL,
      NULL,
      NULL,
      0,
      2.954946,
      1.093015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.006616,
      0.996057,
      NULL,
      NULL,
      1,
      1.250960,
      0,
      1.073648,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2,
      3,
      2,
      2.826735,
      2.639493,
      3,
      1,
      1.479217,
      0,
      0,
      NULL,
      0,
      NULL,
      1.271847,
      0.557952,
      1,
      0,
      1,
      NULL,
      1,
      0.792974,
      0,
      11,
      0,
      7,
      0,
      7,
      7,
      NULL,
      2,
      7,
      0,
      1.755677,
      0,
      53,
      NULL,
      0,
      65,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2,
      '21213',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.103688,
      1,
      NULL,
      0,
      NULL,
      NULL,
      3.679863,
      2.785332,
      2,
      0,
      NULL,
      NULL,
      0.773507,
      3,
      NULL,
      1.870094,
      NULL,
      NULL,
      0,
      3.619850,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.353794,
      NULL,
      NULL,
      1.052522,
      NULL,
      NULL,
      0,
      0.369668,
      2.789402,
      1,
      1.963895,
      NULL,
      NULL,
      NULL,
      0,
      2.915635,
      NULL,
      0.969010,
      0.811671,
      2.275713,
      NULL,
      1.371035,
      NULL,
      NULL,
      0.897786,
      NULL,
      NULL,
      2.187335,
      NULL,
      0,
      1.031667,
      0,
      1,
      3.257469,
      3,
      0,
      3.031353,
      1,
      0,
      0,
      0.094987,
      0.589083,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.148128,
      NULL,
      NULL,
      3,
      5,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      0.256207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2.198945,
      0,
      1.996574,
      4,
      1,
      2.705994,
      2,
      1,
      0.489586,
      NULL,
      NULL,
      2,
      5,
      0.490552,
      0.482128,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.206495,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.456202,
      1.425569,
      NULL,
      0,
      3,
      0,
      5,
      1.354954,
      NULL,
      5.945254,
      7,
      5.356834,
      NULL,
      1.681285,
      4.873496,
      1.361250,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1,
      3,
      5.490151,
      7,
      3.764255,
      0.232973,
      0,
      2,
      2,
      0.561631,
      NULL,
      1,
      1,
      2,
      1,
      1,
      2.525756,
      6,
      NULL,
      9.477843,
      NULL,
      7.328975,
      NULL,
      2,
      1,
      0,
      1.316191,
      NULL,
      0.527081,
      1,
      1.053016,
      2,
      NULL,
      NULL,
      0.634995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.728436,
      NULL,
      NULL,
      0.504535,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.302333,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.634161,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.272323,
      1,
      1,
      0.172924,
      0.625673,
      NULL,
      1.006013,
      NULL,
      NULL,
      4.209058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.638288,
      NULL,
      NULL,
      NULL,
      3.104408,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.610017,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.559378,
      NULL,
      NULL,
      NULL,
      1.076508,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.527244,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3.743336,
      26,
      4.126010,
      0,
      NULL,
      NULL,
      0.058068,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.630279,
      NULL,
      1.414674,
      0.912534,
      0,
      0,
      1.989140,
      0.802582,
      0.955782,
      NULL,
      0,
      1,
      1.084544,
      NULL,
      1.650643,
      1.454534,
      NULL,
      1,
      1,
      NULL,
      0.852543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      4,
      0,
      NULL,
      0,
      0,
      1.172494,
      3,
      3,
      1.687106,
      NULL,
      0.455335,
      NULL,
      0.781267,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.527955,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3.343650,
      NULL,
      0.173961,
      NULL,
      NULL,
      1,
      1.889718,
      NULL,
      0.139102,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2.210891,
      1,
      0.478735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.955752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.963806,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      3,
      4,
      1.790229,
      NULL,
      NULL,
      49,
      58,
      1,
      1,
      2.511425,
      NULL,
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


