set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9134475';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      NULL,
      NULL,
      NULL,
      '2413430',
      0,
      NULL,
      0,
      NULL,
      '4121',
      0.412258,
      1,
      NULL,
      NULL,
      ' 0-10-1975',
      39,
      NULL,
      NULL,
      0,
      NULL,
      ' 0- 9-1980',
      56,
      2,
      153.956921,
      90,
      NULL,
      ' 1-20-1992',
      ' 3- 8-1977',
      '11- 2-1989',
      0,
      0.062069,
      2.176264,
      0.523434,
      0.025913,
      1.359632,
      0,
      0.198642,
      0,
      111.616619,
      6,
      13.763535,
      3.235596,
      NULL,
      22.296378,
      5,
      27,
      NULL,
      3,
      6,
      1.206030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      1.165379,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.702942,
      0.705960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0.638637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      4,
      2,
      4,
      4,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.677339,
      1,
      0,
      0,
      1,
      1,
      1,
      0.889668,
      4,
      5,
      NULL,
      5,
      4,
      1,
      1,
      1,
      1,
      1,
      1,
      NULL,
      5,
      NULL,
      NULL,
      0,
      5,
      2,
      2,
      2,
      0,
      NULL,
      NULL,
      3,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.728310,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.010368,
      4.310178,
      3.095923,
      5.430302,
      2,
      4.710925,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993834,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.492855,
      1.951493,
      1,
      0,
      1,
      NULL,
      2.805481,
      342,
      1,
      1,
      6,
      NULL,
      0,
      1,
      NULL,
      NULL,
      3,
      2,
      NULL,
      0,
      0,
      3,
      1,
      0,
      2,
      1,
      2.000502,
      3.040076,
      2.930507,
      5.343174,
      1,
      NULL,
      3.721724,
      0.967959,
      NULL,
      0.946799,
      0.226866,
      0.496065,
      NULL,
      0,
      1,
      1,
      0.361515,
      0.858510,
      NULL,
      4.074028,
      NULL,
      NULL,
      10,
      6,
      2.409669,
      5.010653,
      1.994465,
      0,
      1,
      1,
      NULL,
      54.771357,
      0,
      0.545168,
      NULL,
      19,
      NULL,
      24.324280,
      4,
      NULL,
      2.706116,
      '10024',
      '',
      '',
      NULL,
      '24222',
      '',
      '',
      0.332328,
      '',
      NULL,
      NULL,
      1.365030,
      NULL,
      105,
      4,
      NULL,
      44,
      1,
      10,
      3,
      0.388257,
      1.980121,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.714232,
      NULL,
      NULL,
      3,
      1.742591,
      NULL,
      0,
      NULL,
      NULL,
      1.322983,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.313799,
      NULL,
      NULL,
      2.725099,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.891421,
      NULL,
      NULL,
      1.496981,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.203604,
      NULL,
      2,
      2,
      0.235012,
      2.527807,
      1,
      NULL,
      NULL,
      2.939933,
      0.483784,
      1.052990,
      1.483260,
      1.429766,
      7,
      2,
      1,
      2,
      0.635635,
      NULL,
      NULL,
      NULL,
      1.736072,
      0.120194,
      3,
      1.832460,
      NULL,
      NULL,
      1.362539,
      2.695555,
      0.772179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      4.421069,
      3,
      5.562515,
      1.107501,
      0.382739,
      1,
      1.859872,
      NULL,
      NULL,
      6,
      2.883693,
      2.571138,
      4,
      5,
      4,
      NULL,
      1.328514,
      1,
      NULL,
      1,
      3.741780,
      2.622283,
      1.908645,
      2,
      2.028423,
      1.936948,
      1,
      2.705528,
      2.559756,
      2.445283,
      0,
      3,
      1.448652,
      NULL,
      3,
      2.164743,
      1.578232,
      3.653225,
      2.564884,
      2.709074,
      NULL,
      3.060311,
      NULL,
      5.729841,
      7.669845,
      3,
      NULL,
      NULL,
      2.106270,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      1.356584,
      7.888976,
      NULL,
      NULL,
      56.878455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.115940,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.787397,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.750370,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      0.777469,
      NULL,
      0.759584,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.080613,
      8.146105,
      6,
      2,
      9.885999,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      5,
      2.497277,
      1.605762,
      NULL,
      NULL,
      0.402276,
      NULL,
      1,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1.934152,
      0.331464,
      0.035392,
      1,
      NULL,
      0.177405,
      NULL,
      0,
      NULL,
      1.932460,
      1.259400,
      0,
      0.150606,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      8.778950,
      2,
      4,
      2,
      2,
      10.842694,
      NULL,
      NULL,
      NULL,
      2.796191,
      2,
      1,
      NULL,
      0.973104,
      0,
      1,
      0.187091,
      1.692510,
      1.923809,
      0,
      1,
      1.529246,
      1,
      3,
      2.527365,
      0.935911,
      0,
      3.876326,
      2.761568,
      1,
      3.336678,
      2,
      NULL,
      1,
      NULL,
      1.296074,
      1.292132,
      2,
      0,
      NULL,
      2,
      NULL,
      0.392168,
      0,
      1.340437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.193876,
      NULL,
      0,
      NULL,
      2,
      6,
      1,
      0.950498,
      1,
      2,
      37,
      34,
      NULL,
      0,
      NULL,
      '34342',
      '',
      '',
      0,
      '12320',
      '',
      '',
      0.039662,
      NULL,
      '',
      '');
commit;
end;
/


