set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9427817';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-11-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22',
      NULL,
      31.370981,
      '0344143',
      2,
      NULL,
      2,
      2,
      '1303',
      4,
      1.804671,
      NULL,
      NULL,
      ' 2- 4-1983',
      56,
      11.760600,
      NULL,
      2,
      1.257458,
      ' 4-18-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 9-16-2000',
      ' 7- 9-1975',
      ' 6- 7-2003',
      1,
      NULL,
      1.500827,
      1.559985,
      1.694237,
      0,
      8,
      NULL,
      0.964181,
      44,
      4,
      14.170272,
      3.579962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.594753,
      NULL,
      0,
      1.660533,
      1,
      0,
      1,
      0,
      0.541039,
      4,
      1.791928,
      0,
      NULL,
      4,
      1.606719,
      5,
      0,
      0,
      NULL,
      NULL,
      1,
      4,
      NULL,
      0,
      1,
      2,
      0,
      5,
      NULL,
      2,
      2,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2,
      3.853558,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      2,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      2,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.575308,
      NULL,
      NULL,
      0,
      3,
      NULL,
      5,
      NULL,
      4,
      NULL,
      2,
      2,
      NULL,
      0,
      1,
      NULL,
      3,
      2,
      0,
      3,
      NULL,
      NULL,
      1,
      3,
      4,
      NULL,
      1.356503,
      3.124040,
      NULL,
      159,
      ' 0-16-2002',
      14,
      3.761392,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.910058,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      2,
      NULL,
      1.467246,
      1.211930,
      4.771394,
      0,
      1.398289,
      2,
      6.419542,
      0,
      NULL,
      NULL,
      NULL,
      1,
      5.038062,
      0.259486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.853650,
      0.584495,
      NULL,
      1,
      NULL,
      1.631782,
      1.931223,
      13.568408,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.069259,
      1,
      3,
      1,
      0,
      3,
      2,
      3,
      1,
      3,
      1,
      0,
      3,
      2.655443,
      2.086420,
      1,
      1,
      1.458841,
      1,
      1.272272,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0.679847,
      0,
      1,
      NULL,
      0,
      3.897657,
      5,
      4,
      3.200126,
      9,
      3,
      NULL,
      0,
      1.821874,
      1.724130,
      2.586328,
      1,
      47.119619,
      1,
      NULL,
      14,
      NULL,
      62,
      32.828284,
      0,
      0,
      0.266395,
      NULL,
      '',
      '',
      0.762845,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      21.697824,
      6.642812,
      3.966946,
      30.706486,
      NULL,
      0.847704,
      4,
      2,
      2,
      1.907110,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.647645,
      1,
      NULL,
      0.665804,
      3,
      1.233342,
      1,
      NULL,
      NULL,
      2.340646,
      1,
      2.721370,
      1.611470,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.416708,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.180058,
      NULL,
      NULL,
      8,
      6,
      NULL,
      0,
      0.007163,
      NULL,
      NULL,
      NULL,
      1.612987,
      NULL,
      NULL,
      NULL,
      0.216721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.752265,
      1,
      0.778673,
      1.317614,
      3,
      2.361404,
      1.680004,
      NULL,
      NULL,
      1.143838,
      NULL,
      NULL,
      5.051810,
      2.443622,
      0,
      NULL,
      0.676719,
      2.787487,
      1.940918,
      NULL,
      NULL,
      4.940542,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.954680,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.395908,
      2.932790,
      NULL,
      3,
      1,
      4,
      NULL,
      2,
      5.114062,
      NULL,
      3.217656,
      0.970293,
      NULL,
      3.551447,
      2,
      2,
      3,
      NULL,
      3.383922,
      NULL,
      3.484275,
      2,
      NULL,
      2,
      2.294479,
      0.278733,
      NULL,
      0.740179,
      2.560577,
      2.724989,
      3.554232,
      0.824312,
      3,
      NULL,
      0,
      NULL,
      1,
      2.532537,
      6.285252,
      5.777646,
      7,
      4,
      NULL,
      4.469204,
      1.902942,
      0,
      0,
      NULL,
      1.748878,
      1.122903,
      0,
      1.759534,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.055861,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      1.236251,
      1,
      0.009250,
      1.857688,
      NULL,
      0,
      NULL,
      NULL,
      0.684674,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.552844,
      NULL,
      NULL,
      NULL,
      3.658939,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.155024,
      NULL,
      NULL,
      NULL,
      0.288909,
      NULL,
      NULL,
      NULL,
      0.358869,
      NULL,
      NULL,
      NULL,
      1.962550,
      NULL,
      NULL,
      NULL,
      7.304422,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      21.689085,
      5.567688,
      3,
      3.112386,
      730,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.829867,
      NULL,
      NULL,
      1.213434,
      NULL,
      NULL,
      0.433830,
      NULL,
      1.639692,
      0.329766,
      12005,
      1,
      0,
      0.125318,
      NULL,
      1.996400,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.780444,
      0,
      NULL,
      1,
      1.388312,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.528441,
      NULL,
      0.010647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.680201,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.674664,
      3.819837,
      NULL,
      0.505889,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.677917,
      NULL,
      0.583965,
      NULL,
      0.376530,
      1.650630,
      1.440788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.462634,
      1.062546,
      NULL,
      1,
      NULL,
      1.297747,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3,
      NULL,
      0.514919,
      0,
      0.947062,
      0,
      0,
      NULL,
      1,
      3.236619,
      NULL,
      NULL,
      3.905679,
      NULL,
      0.688445,
      NULL,
      NULL,
      0,
      0.151834,
      NULL,
      1,
      0,
      NULL,
      3.424691,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.964728,
      0,
      NULL,
      2.979820,
      3.403261,
      NULL,
      1.892055,
      0.026833,
      1.444509,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      6,
      1,
      0,
      NULL,
      0,
      64,
      60,
      5,
      NULL,
      3.496626,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


