set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433921';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-11-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '4034031',
      1,
      NULL,
      5,
      3,
      '1233',
      1.513695,
      0.538371,
      NULL,
      NULL,
      NULL,
      64,
      NULL,
      1,
      NULL,
      2.907153,
      ' 8-27-1996',
      43,
      NULL,
      351,
      87.257164,
      NULL,
      ' 6- 6-1994',
      ' 7- 1-2002',
      ' 0- 2-1994',
      0,
      NULL,
      1,
      1.702508,
      NULL,
      1,
      3,
      2.808941,
      NULL,
      NULL,
      NULL,
      5,
      7.379170,
      20.581901,
      NULL,
      1,
      NULL,
      2,
      4,
      5.301238,
      1,
      NULL,
      0,
      1,
      1,
      1.191835,
      1.769923,
      0.715238,
      0,
      NULL,
      1.812706,
      NULL,
      NULL,
      NULL,
      1.918696,
      4,
      1,
      NULL,
      4,
      2,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      6.878102,
      0,
      0,
      1,
      0,
      0.071314,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      1.382226,
      1.435432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      3.399835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      0,
      0.302979,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      1,
      2,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      3,
      NULL,
      3,
      4,
      1,
      NULL,
      1,
      1,
      0.217120,
      2,
      '10-19-1985',
      NULL,
      ' 0-29-1985',
      NULL,
      2.395244,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      5,
      NULL,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.256317,
      0,
      2,
      0,
      0.858356,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.973429,
      1.661249,
      1,
      0.447161,
      1,
      0.218275,
      2.706594,
      11,
      0,
      0.682412,
      NULL,
      NULL,
      NULL,
      0,
      0.862661,
      3,
      1,
      3,
      0,
      0,
      1,
      3,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      2,
      4,
      0.856238,
      NULL,
      4,
      2,
      1.252059,
      1,
      1.516079,
      1.239015,
      1.451811,
      0,
      NULL,
      0,
      1,
      1.385836,
      1,
      NULL,
      3.348176,
      NULL,
      8,
      1.533341,
      6,
      3,
      3.492169,
      2,
      0,
      3.845545,
      3,
      56,
      3,
      NULL,
      NULL,
      0,
      71,
      66,
      0,
      2.440657,
      1.223272,
      NULL,
      NULL,
      '',
      0.348819,
      NULL,
      '',
      '',
      0,
      '',
      NULL,
      '',
      2,
      15,
      NULL,
      36.852652,
      2.555154,
      2.265896,
      1,
      0,
      NULL,
      NULL,
      2.114321,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.468042,
      0.324782,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.657091,
      2.991016,
      NULL,
      NULL,
      NULL,
      0.825053,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.312696,
      NULL,
      NULL,
      NULL,
      7.592756,
      4,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.872714,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.227145,
      NULL,
      NULL,
      1.212595,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.101165,
      NULL,
      NULL,
      1.082726,
      NULL,
      NULL,
      1.459793,
      NULL,
      NULL,
      0.734929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.418610,
      0.651177,
      0.162833,
      NULL,
      NULL,
      4,
      7.270916,
      NULL,
      0.472907,
      NULL,
      NULL,
      1.365203,
      NULL,
      NULL,
      1.015622,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.382756,
      NULL,
      NULL,
      1.286012,
      NULL,
      NULL,
      0.758938,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.437669,
      NULL,
      NULL,
      0.060444,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.246756,
      NULL,
      NULL,
      0,
      1,
      0.854116,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.140945,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.606120,
      0,
      3.244433,
      1,
      3.488474,
      3.270319,
      0.952779,
      1,
      3,
      1.993132,
      1,
      NULL,
      4,
      2.823590,
      7,
      0,
      NULL,
      NULL,
      1.509603,
      3,
      0,
      0,
      0.897829,
      NULL,
      NULL,
      1.683641,
      NULL,
      NULL,
      NULL,
      0.937530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.419171,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354075,
      0,
      0.359911,
      1,
      1.409787,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.487656,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.807646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      1,
      NULL,
      NULL,
      1.330253,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.554911,
      NULL,
      NULL,
      0.804963,
      NULL,
      NULL,
      0.309776,
      NULL,
      0.592180,
      76,
      1.494885,
      1.860921,
      1,
      1.955502,
      0,
      0.202398,
      0,
      1,
      1.084037,
      0,
      0,
      0.591771,
      1.485935,
      0,
      NULL,
      1.288595,
      0.992910,
      0.438877,
      1.645665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.227818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      4,
      0,
      NULL,
      2,
      NULL,
      5.397478,
      1,
      3,
      NULL,
      0.262637,
      NULL,
      NULL,
      0,
      0.779576,
      NULL,
      NULL,
      NULL,
      NULL,
      1.400007,
      1,
      NULL,
      1,
      0,
      NULL,
      0.350189,
      0,
      NULL,
      1,
      1,
      NULL,
      1.803338,
      1.727059,
      NULL,
      1.122579,
      2.995358,
      NULL,
      0,
      2.755949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.100528,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.601802,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      NULL,
      4,
      0.106452,
      NULL,
      NULL,
      62,
      23,
      3,
      5,
      0.691291,
      '20412',
      '',
      '',
      0.085246,
      '',
      '',
      NULL,
      0.559595,
      '',
      NULL,
      '');
commit;
end;
/


