set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908063';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      4,
      5.713276,
      4,
      1,
      NULL,
      2,
      1,
      3,
      '300',
      '20303341',
      63,
      32.179542,
      '4012044',
      3,
      1,
      2,
      1,
      '3022',
      4.429359,
      NULL,
      NULL,
      NULL,
      ' 3-27-1994',
      NULL,
      47.525643,
      NULL,
      1.176410,
      1.291941,
      ' 9- 1-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 1- 9-1994',
      1.110638,
      0,
      0.161169,
      2.121445,
      0.752905,
      1.913760,
      2,
      0.829276,
      1.034754,
      47,
      4,
      NULL,
      3.817118,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      2.972226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1,
      1.641908,
      NULL,
      NULL,
      0.467689,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      6,
      NULL,
      2,
      NULL,
      0.721968,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      2,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      1,
      1.681632,
      NULL,
      1.262254,
      NULL,
      1,
      NULL,
      5,
      1,
      4,
      4,
      5,
      1,
      4,
      0,
      1,
      3,
      1,
      4,
      3,
      2,
      3,
      4,
      0,
      1,
      2,
      5,
      1,
      3,
      1,
      2.871657,
      ' 0-29-1979',
      163,
      '11- 3-1982',
      300.780951,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.323620,
      0,
      5.415318,
      5.439398,
      1,
      NULL,
      1.237508,
      NULL,
      NULL,
      NULL,
      0.436666,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.451554,
      0.621896,
      0.181362,
      3.890544,
      1.304032,
      1.788971,
      0,
      2,
      NULL,
      0.884576,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.192848,
      NULL,
      3,
      NULL,
      0,
      NULL,
      2,
      2,
      3,
      3,
      1,
      3,
      3.286496,
      0,
      3,
      1.887879,
      0.092493,
      NULL,
      NULL,
      0,
      1.273540,
      1.268889,
      NULL,
      0,
      0.894792,
      0,
      1.190149,
      1,
      NULL,
      2,
      NULL,
      0.235441,
      2,
      4.137811,
      1.573696,
      6.620365,
      3,
      4.410252,
      3.863055,
      7.880101,
      0,
      NULL,
      1.756644,
      44,
      2,
      1,
      50,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.159220,
      '',
      '',
      NULL,
      0,
      33.532272,
      7,
      35,
      0,
      40,
      0.842086,
      1.970041,
      5,
      2.893736,
      0.106422,
      1,
      0.940663,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.689687,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      NULL,
      NULL,
      2,
      1,
      0,
      0.677915,
      NULL,
      NULL,
      2,
      2.795853,
      3.224768,
      1,
      NULL,
      NULL,
      NULL,
      3.714866,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.725795,
      NULL,
      NULL,
      NULL,
      0.307087,
      NULL,
      3,
      NULL,
      NULL,
      2.183159,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.413399,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.294139,
      NULL,
      7,
      0,
      1.677937,
      NULL,
      NULL,
      NULL,
      0.958828,
      NULL,
      NULL,
      NULL,
      0.858290,
      0.118634,
      NULL,
      0.369026,
      NULL,
      NULL,
      0.412090,
      NULL,
      1,
      1.981020,
      NULL,
      NULL,
      2.518770,
      7.135363,
      6,
      0,
      3.860093,
      1.625791,
      1,
      NULL,
      NULL,
      3,
      1,
      0,
      0.059153,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.436796,
      2,
      1.759866,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      3,
      NULL,
      1,
      1.998760,
      3.812673,
      1.719252,
      NULL,
      NULL,
      NULL,
      0.259687,
      5,
      7,
      4.582963,
      NULL,
      2,
      6,
      0.189773,
      0.955476,
      0.199383,
      NULL,
      3.028787,
      1.419799,
      NULL,
      0,
      0,
      2.899190,
      5,
      3.645693,
      4,
      2.817341,
      0.620631,
      2.546640,
      3,
      2,
      3,
      1.426639,
      2,
      1.972443,
      1,
      0.087539,
      1.439925,
      NULL,
      9.764603,
      4,
      3,
      2,
      2.281204,
      3.269023,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.895080,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.704867,
      NULL,
      NULL,
      2.146854,
      NULL,
      NULL,
      0.959834,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0,
      1,
      1.643076,
      1.938553,
      2.191455,
      0.603750,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.383432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.587475,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.236150,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.775559,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.714552,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.311933,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.524521,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.128206,
      1.321633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.024282,
      0,
      NULL,
      1,
      NULL,
      0.162822,
      3,
      1,
      0,
      NULL,
      2,
      0.377340,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0.061265,
      0.839785,
      3.917074,
      NULL,
      1.471897,
      NULL,
      3.034479,
      NULL,
      0.160132,
      NULL,
      0.859043,
      NULL,
      0.868129,
      NULL,
      19,
      NULL,
      2,
      37,
      22.380710,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0.939208,
      NULL,
      NULL,
      NULL,
      2.024697,
      NULL,
      1.386806,
      NULL,
      2.974262,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.215517,
      2.984973,
      0.753081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.173901,
      1.807423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.618493,
      3.323424,
      NULL,
      0.889245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.951260,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.123628,
      NULL,
      0,
      NULL,
      0.259658,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.297586,
      NULL,
      0.603639,
      NULL,
      0.534308,
      NULL,
      1.246069,
      1.748281,
      0.257496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.911831,
      1.147694,
      NULL,
      0,
      NULL,
      0.823314,
      NULL,
      205.317593,
      NULL,
      2,
      NULL,
      1.460923,
      NULL,
      NULL,
      1,
      3.355639,
      2.973433,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      1.793186,
      0,
      2,
      7,
      1.263074,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.865925,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.722851,
      0.721998,
      NULL,
      3,
      2.254340,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.608595,
      NULL,
      NULL,
      2.632523,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.353991,
      1.622185,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.025272,
      NULL,
      1.984054,
      NULL,
      0,
      NULL,
      4,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      83,
      5,
      1.047710,
      NULL,
      '02440',
      '10101',
      '30000',
      0,
      '',
      '',
      '',
      3,
      '4411',
      '',
      '');
commit;
end;
/


