set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908205';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-4-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      '1020',
      0,
      0.061593,
      NULL,
      NULL,
      NULL,
      10.886960,
      NULL,
      NULL,
      2,
      2,
      NULL,
      25,
      2,
      93.730399,
      NULL,
      2,
      NULL,
      '10-27-1991',
      ' 6-10-1989',
      2.253284,
      1.177309,
      0.323712,
      2,
      1.014403,
      3,
      2,
      1,
      0.295979,
      4,
      NULL,
      1,
      NULL,
      NULL,
      12.346509,
      5,
      23.580029,
      NULL,
      3,
      0,
      1,
      1,
      NULL,
      1.150065,
      0.435410,
      NULL,
      0,
      0,
      0.500814,
      2.493072,
      1,
      8,
      2,
      2,
      2.207347,
      4,
      0,
      1,
      NULL,
      0,
      1,
      2,
      0,
      1,
      0,
      0,
      3,
      NULL,
      3,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3.435133,
      1,
      0,
      5,
      1,
      NULL,
      0,
      0.506447,
      1.543589,
      1,
      0.038316,
      1.725472,
      1,
      NULL,
      NULL,
      1,
      1.352695,
      1.411648,
      1.065186,
      3.259706,
      NULL,
      1.860011,
      NULL,
      0,
      2,
      5,
      0,
      1,
      NULL,
      1.244640,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      1,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      3.338505,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0,
      3,
      0,
      NULL,
      3,
      0,
      3,
      4,
      1,
      0,
      3,
      NULL,
      4,
      3,
      NULL,
      1,
      2,
      0,
      4,
      3,
      NULL,
      0,
      NULL,
      0.524809,
      3.457208,
      ' 3-16-1976',
      83,
      NULL,
      2.254390,
      1.044692,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      27.739555,
      1.365700,
      1.788718,
      3,
      1.344981,
      NULL,
      1.907054,
      1,
      6.210025,
      3,
      2.864551,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.152314,
      5,
      2.448712,
      4.182818,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0,
      6.148391,
      2,
      2,
      3,
      0,
      3.118396,
      '11- 7-2001',
      59,
      NULL,
      29,
      1.561845,
      0,
      1,
      0,
      3.911367,
      NULL,
      1,
      0.689211,
      0,
      NULL,
      0,
      41.222463,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.026121,
      NULL,
      0,
      2,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      2.984682,
      2,
      2,
      2,
      NULL,
      0.588216,
      NULL,
      NULL,
      0.168447,
      0.282475,
      NULL,
      0.037647,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4.421348,
      0.431614,
      6.688955,
      NULL,
      3.922599,
      NULL,
      2,
      3,
      7,
      NULL,
      NULL,
      1,
      63,
      2,
      2,
      NULL,
      19,
      18,
      40.108905,
      3,
      3,
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      2.813122,
      '3332',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.665958,
      3.622141,
      1.588841,
      1.515982,
      0.027387,
      1,
      0.608153,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.355828,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.638141,
      0,
      1,
      NULL,
      0,
      1,
      0.977040,
      1.601938,
      0.504526,
      0,
      1,
      0.935344,
      0.475395,
      1.518999,
      NULL,
      1.197513,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      8,
      0,
      NULL,
      1,
      3,
      2,
      1,
      0,
      NULL,
      0.329833,
      1.607170,
      NULL,
      0.225245,
      3,
      NULL,
      0.484065,
      NULL,
      NULL,
      0,
      0.623324,
      NULL,
      1.044185,
      NULL,
      NULL,
      1,
      0.741832,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.013626,
      NULL,
      0,
      0.113859,
      NULL,
      0,
      1.049427,
      NULL,
      0,
      0,
      NULL,
      3.923714,
      NULL,
      2.720559,
      3.480142,
      NULL,
      0.301806,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.848214,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.727247,
      NULL,
      0.281963,
      NULL,
      1,
      NULL,
      0.539709,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.210759,
      0.407603,
      2,
      1.025576,
      NULL,
      3.663941,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.406652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1976.115158,
      0,
      NULL,
      1.497875,
      NULL,
      0.452210,
      NULL,
      1,
      1,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '43210',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '3024',
      '',
      '');
commit;
end;
/


