set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7923979';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-1-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      NULL,
      NULL,
      '2141444',
      2,
      0.260537,
      3,
      0,
      '4201',
      2,
      NULL,
      NULL,
      NULL,
      ' 3-25-2001',
      5,
      NULL,
      2,
      3.768811,
      0,
      NULL,
      54.917945,
      2,
      277.633627,
      74.935629,
      NULL,
      ' 6-11-1992',
      ' 3-13-1982',
      NULL,
      NULL,
      0,
      NULL,
      0.679633,
      1,
      2.793005,
      NULL,
      1,
      NULL,
      173.596255,
      1,
      NULL,
      2,
      4.214274,
      0,
      0,
      0,
      3,
      3,
      2.777243,
      1,
      1,
      1,
      0.398603,
      0.267380,
      1.773133,
      1,
      0,
      1,
      1,
      NULL,
      2,
      1,
      5,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      1,
      5.070700,
      1,
      0,
      0,
      1,
      0.312069,
      NULL,
      NULL,
      0.143917,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.617819,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      4,
      NULL,
      NULL,
      NULL,
      3,
      5,
      NULL,
      0,
      0,
      0,
      1,
      1,
      NULL,
      0,
      0.819081,
      NULL,
      1.694005,
      NULL,
      0,
      0,
      0,
      0,
      2,
      0,
      1,
      5,
      1,
      NULL,
      2,
      5,
      0,
      3,
      1,
      4,
      0,
      5,
      0,
      0,
      3,
      2,
      0,
      0,
      0.478014,
      0.336438,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.395871,
      NULL,
      6.781408,
      1.628902,
      0.186362,
      1.200405,
      1,
      NULL,
      NULL,
      NULL,
      0.626616,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424781,
      0.499105,
      0.518731,
      2.739041,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      1.778072,
      NULL,
      NULL,
      NULL,
      0,
      1.654547,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      NULL,
      2,
      NULL,
      3,
      1,
      NULL,
      2.126011,
      2.541819,
      1,
      0.856214,
      NULL,
      0.281908,
      1.540471,
      0,
      1.003671,
      NULL,
      1.350840,
      1.891258,
      1,
      1,
      1,
      0.437776,
      NULL,
      0,
      NULL,
      5,
      1.717207,
      2,
      NULL,
      0.076382,
      0,
      3.988521,
      NULL,
      2.262210,
      1,
      1.834221,
      22,
      2,
      1,
      NULL,
      37,
      NULL,
      68,
      1,
      0,
      2,
      '14222',
      '',
      '',
      1.554491,
      '',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      4,
      36.827646,
      27.375163,
      3.292828,
      42,
      48,
      165,
      1,
      1.356762,
      NULL,
      NULL,
      NULL,
      0.580264,
      1.823983,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.614446,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.944992,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      0.285009,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.877152,
      2.476870,
      NULL,
      0.811069,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.830558,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.261019,
      NULL,
      1.825630,
      0,
      NULL,
      NULL,
      1,
      6.708354,
      NULL,
      0,
      3.743080,
      2,
      0.492338,
      NULL,
      NULL,
      4,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.510418,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.732826,
      0,
      NULL,
      NULL,
      3.165093,
      2.847070,
      4,
      4.951814,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.809425,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0.084130,
      0,
      4,
      0.264271,
      9.834976,
      NULL,
      0,
      2.573587,
      0,
      3.862130,
      1,
      1.585495,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      4.176209,
      4.313781,
      2.208261,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0.615106,
      NULL,
      NULL,
      0,
      1.256732,
      NULL,
      NULL,
      NULL,
      1.446673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.791800,
      NULL,
      NULL,
      1.666009,
      NULL,
      NULL,
      0.742901,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.267050,
      NULL,
      NULL,
      3,
      0,
      2.173369,
      0,
      3.488278,
      2.708856,
      3,
      NULL,
      7.193894,
      0.227600,
      NULL,
      NULL,
      12.502488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.601612,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.088985,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.215537,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.824053,
      3.443011,
      0.849066,
      NULL,
      0.014945,
      1,
      NULL,
      NULL,
      3,
      3,
      2,
      NULL,
      3,
      3.842599,
      3,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      6,
      NULL,
      NULL,
      3,
      7,
      NULL,
      1,
      0,
      84.565964,
      206.372129,
      1.083810,
      45,
      0,
      0,
      NULL,
      NULL,
      NULL,
      8.610327,
      8.704757,
      1.695653,
      15.362578,
      NULL,
      1.866339,
      11.638896,
      6,
      0.824555,
      NULL,
      1.100504,
      62.008378,
      0,
      0,
      1.816670,
      NULL,
      1.385345,
      1,
      1.694247,
      1,
      1.183712,
      0.810590,
      1,
      NULL,
      0.512205,
      NULL,
      0,
      0,
      1,
      0,
      1.549160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.892171,
      5,
      1,
      6,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      1.575134,
      0.670626,
      0,
      1,
      3,
      1,
      0,
      0,
      2,
      NULL,
      3,
      NULL,
      0,
      2,
      0.890826,
      0,
      NULL,
      1.275116,
      NULL,
      1.853465,
      1.764430,
      1.015197,
      1.213367,
      1,
      0,
      2.901696,
      0.677404,
      NULL,
      NULL,
      0.395151,
      NULL,
      1.087277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.900422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402589,
      0.219784,
      NULL,
      1,
      0.331322,
      0,
      NULL,
      NULL,
      2,
      2,
      NULL,
      2,
      NULL,
      77.003167,
      5,
      0.507312,
      NULL,
      '01142',
      '42144',
      '',
      NULL,
      NULL,
      '',
      '',
      0.495897,
      '',
      '',
      '');
commit;
end;
/


