set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206943';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-8-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      NULL,
      3.346497,
      0.618622,
      NULL,
      0,
      1.112333,
      3.505150,
      '202',
      '1',
      NULL,
      54.380410,
      '3003402',
      NULL,
      NULL,
      3,
      2,
      '2400',
      2.450513,
      1.712649,
      NULL,
      NULL,
      NULL,
      NULL,
      25.434133,
      NULL,
      2,
      0.778900,
      ' 7- 7-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      ' 8-10-1983',
      0,
      1,
      3.309172,
      NULL,
      NULL,
      NULL,
      1,
      0.113525,
      1.412742,
      129.855935,
      0,
      9.410604,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      0.841179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      0,
      4,
      3,
      3,
      3,
      1,
      1,
      1,
      4.471606,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      1,
      NULL,
      1,
      0.787409,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.782980,
      NULL,
      3,
      1.307658,
      1,
      0.226125,
      1,
      NULL,
      0,
      7.892612,
      0,
      2,
      2,
      1,
      NULL,
      NULL,
      0.889913,
      NULL,
      NULL,
      3,
      0,
      1,
      0,
      NULL,
      2,
      0,
      0,
      1,
      NULL,
      0,
      0,
      1,
      3.875029,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      0.020924,
      0,
      0,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      3,
      4,
      0,
      NULL,
      3,
      NULL,
      1,
      0.782596,
      1,
      ' 2- 9-1980',
      1932,
      ' 6-28-1989',
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      0.380897,
      0.704586,
      NULL,
      4,
      1.878754,
      NULL,
      NULL,
      1,
      3.383394,
      1.989876,
      NULL,
      NULL,
      1,
      1,
      1,
      0.041766,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.241758,
      3.133095,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.532984,
      2,
      NULL,
      NULL,
      0,
      3,
      3,
      NULL,
      2,
      2,
      0,
      3,
      1,
      2,
      1,
      3.144894,
      1.499943,
      0,
      0.662787,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.863088,
      0.557047,
      0,
      0,
      0.120347,
      1,
      NULL,
      10.655435,
      9,
      NULL,
      4,
      8.538024,
      3,
      4.632418,
      2.190588,
      7.863402,
      0.541206,
      2,
      NULL,
      NULL,
      NULL,
      0,
      23,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      0,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      1,
      NULL,
      225,
      37,
      1,
      33.919073,
      NULL,
      8.959364,
      NULL,
      NULL,
      3.827272,
      0.438123,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.962729,
      3.782727,
      0.458532,
      1,
      NULL,
      NULL,
      NULL,
      3.193377,
      1.996937,
      1,
      NULL,
      2.639876,
      3.613858,
      3,
      2.123895,
      1,
      3,
      3,
      3.903317,
      NULL,
      2,
      NULL,
      3.364015,
      0,
      0.223638,
      NULL,
      0.853369,
      1,
      8,
      0.009071,
      2.569509,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.512012,
      1,
      0,
      NULL,
      3.830475,
      3.246286,
      1,
      0,
      2.463323,
      1.398247,
      2.864892,
      2,
      3,
      2,
      1,
      0,
      2,
      3.121651,
      1,
      0,
      3,
      0,
      1.932976,
      0.808205,
      NULL,
      0.863825,
      2,
      0.310248,
      NULL,
      2.325500,
      1,
      0.011710,
      3.045805,
      0,
      NULL,
      3,
      1.089631,
      NULL,
      9.143185,
      NULL,
      6.724464,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.103073,
      3.060460,
      3.322681,
      1,
      2.126866,
      1.422543,
      NULL,
      NULL,
      1,
      1.723109,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.557257,
      NULL,
      1.008113,
      1,
      NULL,
      NULL,
      0.862190,
      1.050342,
      3.418040,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.502962,
      NULL,
      NULL,
      0.929876,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.671038,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      3,
      1,
      NULL,
      NULL,
      0.459030,
      1,
      1.500666,
      3,
      7.858384,
      4.078796,
      NULL,
      0,
      1.751707,
      0,
      0.249916,
      2,
      2,
      2,
      0.476412,
      1,
      2.395763,
      2,
      3.481950,
      NULL,
      NULL,
      0.935590,
      NULL,
      NULL,
      5,
      0,
      0,
      1,
      1.824398,
      1.476240,
      NULL,
      0.054824,
      1.017238,
      3,
      NULL,
      NULL,
      1.966163,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012627,
      1,
      3.361818,
      1.506091,
      NULL,
      3.113290,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.517090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.971848,
      NULL,
      NULL,
      NULL,
      3.000350,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.712755,
      0.048351,
      NULL,
      NULL,
      2.608680,
      1,
      NULL,
      NULL,
      NULL,
      2.635953,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.166957,
      0,
      NULL,
      NULL,
      1.549530,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2.213439,
      NULL,
      NULL,
      NULL,
      0.642348,
      NULL,
      NULL,
      0.886208,
      1.123600,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.927127,
      NULL,
      NULL,
      6,
      0.652084,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      36.918403,
      1.673083,
      NULL,
      NULL,
      1,
      1,
      6,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.661685,
      128.162020,
      2.887535,
      0,
      NULL,
      0.419249,
      0.421300,
      1,
      NULL,
      1,
      NULL,
      1.641422,
      1.666290,
      NULL,
      1.897830,
      1,
      1.728173,
      1.918001,
      1,
      0,
      2,
      NULL,
      0.353593,
      NULL,
      2,
      NULL,
      1.679463,
      NULL,
      0,
      NULL,
      0.365698,
      NULL,
      106,
      NULL,
      1,
      24.656037,
      6.590879,
      1,
      0.471068,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.233148,
      NULL,
      1.313739,
      NULL,
      2.772360,
      NULL,
      1.678285,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.156696,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.083409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.109750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.994875,
      NULL,
      1,
      NULL,
      1.704985,
      NULL,
      NULL,
      NULL,
      1.513866,
      NULL,
      NULL,
      NULL,
      0,
      0.044380,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      2.911707,
      0,
      3.549458,
      3.342226,
      2,
      NULL,
      1,
      2,
      0.263428,
      1,
      1.756710,
      0,
      1,
      0,
      NULL,
      1.813051,
      0.414031,
      3,
      1,
      3.277358,
      3,
      1.075885,
      0.137924,
      NULL,
      0.954652,
      2,
      2.097735,
      1,
      2,
      1.407003,
      1,
      2.055558,
      0.778505,
      1.466768,
      0,
      0,
      0,
      3,
      1.423993,
      1.641523,
      1.132145,
      1,
      NULL,
      0.933575,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.126159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.721400,
      NULL,
      0,
      0.191987,
      NULL,
      NULL,
      NULL,
      3,
      5,
      NULL,
      NULL,
      NULL,
      69.052147,
      50,
      5,
      3.920118,
      3,
      '20442',
      '43321',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '4443',
      '',
      '');
commit;
end;
/


