set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8935322';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      NULL,
      '4141022',
      1.886978,
      1.001545,
      1,
      0,
      '2101',
      2.579630,
      0,
      5.456127,
      NULL,
      ' 9-15-1995',
      10.400265,
      NULL,
      0,
      2.116156,
      0,
      NULL,
      NULL,
      3,
      184.209281,
      NULL,
      1,
      ' 1- 9-1991',
      ' 9-24-1989',
      '10-15-1994',
      3,
      NULL,
      1.092319,
      0.863605,
      0,
      1.546475,
      7,
      1,
      NULL,
      NULL,
      4,
      17.904869,
      2.202589,
      95.824972,
      91.894360,
      5,
      11,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      0,
      0.118847,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      0,
      NULL,
      0,
      0.803201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      5,
      1,
      0.866039,
      0,
      0.985764,
      2.793347,
      1.234753,
      1,
      1.355034,
      0.801690,
      NULL,
      3,
      0,
      1.427988,
      0.338281,
      1.167204,
      1.735551,
      0,
      1,
      1,
      9,
      NULL,
      0,
      NULL,
      1.866634,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0,
      0,
      1,
      0.314021,
      1,
      1,
      1,
      1,
      1,
      NULL,
      0,
      2,
      1,
      1,
      0,
      1,
      2,
      NULL,
      1,
      1,
      0,
      0,
      1,
      3,
      1,
      NULL,
      4,
      0,
      4,
      0,
      3,
      NULL,
      1,
      3,
      1,
      1,
      4,
      2,
      ' 0-10-1978',
      322.172760,
      NULL,
      14,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      0,
      1.485569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.834185,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      0.664748,
      0,
      3.977482,
      34,
      0,
      0.706262,
      NULL,
      NULL,
      NULL,
      NULL,
      0.944289,
      2,
      3,
      1,
      NULL,
      0,
      1,
      0,
      2,
      3,
      1,
      3,
      3,
      2,
      15,
      NULL,
      1,
      NULL,
      NULL,
      139.822755,
      114,
      82.561478,
      16,
      175.511797,
      53.266936,
      74.821571,
      157.212533,
      1,
      NULL,
      0,
      NULL,
      NULL,
      11,
      0,
      NULL,
      0.715628,
      5.738836,
      4,
      2.621883,
      5.621567,
      NULL,
      1,
      2,
      43,
      0,
      1.042371,
      NULL,
      35,
      60,
      4.854593,
      5,
      1,
      NULL,
      '43000',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      '00312',
      '22141',
      3,
      NULL,
      NULL,
      18,
      3.671961,
      19,
      8.970560,
      NULL,
      3,
      0,
      1.074338,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.280450,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      19,
      1,
      3.253934,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.956885,
      NULL,
      NULL,
      0,
      NULL,
      1.180832,
      1,
      1.400451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.546742,
      0,
      3.335676,
      2.728801,
      NULL,
      1,
      1.197773,
      1,
      2,
      1,
      1.222940,
      2,
      2.091689,
      0.418121,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1.776376,
      0.630927,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      1,
      8.301682,
      4.687918,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.215756,
      NULL,
      NULL,
      NULL,
      0.147222,
      NULL,
      0,
      2,
      1,
      1,
      NULL,
      2.494500,
      0.136710,
      0.724085,
      NULL,
      NULL,
      1.054773,
      5.523396,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.467792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.921502,
      0.005922,
      NULL,
      NULL,
      5,
      0,
      5.619651,
      6,
      4,
      NULL,
      1.385538,
      NULL,
      NULL,
      3,
      1.935755,
      0.567831,
      3,
      0.912560,
      3,
      1,
      NULL,
      NULL,
      5.128216,
      9,
      7,
      NULL,
      0.594825,
      2.898406,
      1,
      1.888609,
      2,
      NULL,
      NULL,
      NULL,
      3.732268,
      3,
      2,
      NULL,
      7,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      1.933232,
      0,
      0.757009,
      3.827197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.136536,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.745285,
      NULL,
      NULL,
      3.205261,
      1.458149,
      0.915354,
      1.832632,
      1.767138,
      2,
      3,
      NULL,
      NULL,
      1,
      5.927079,
      NULL,
      NULL,
      2.891016,
      3,
      NULL,
      NULL,
      NULL,
      2.570144,
      NULL,
      NULL,
      0.079876,
      1,
      NULL,
      NULL,
      NULL,
      1.051566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.728587,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.611838,
      NULL,
      NULL,
      NULL,
      3,
      2.526944,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.687480,
      1.818832,
      NULL,
      NULL,
      0,
      0.064780,
      NULL,
      NULL,
      1.527222,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.691978,
      NULL,
      NULL,
      NULL,
      3,
      114.724072,
      51,
      1.105060,
      NULL,
      NULL,
      1.598305,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.164352,
      NULL,
      0,
      408.163163,
      0,
      NULL,
      1,
      1.969677,
      NULL,
      NULL,
      0.606571,
      0,
      1.066404,
      0.599129,
      NULL,
      0,
      1.767168,
      0,
      0.809180,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.175050,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      1.812393,
      1.119190,
      1,
      3.481406,
      2,
      2,
      3,
      0,
      NULL,
      0.149635,
      1.055570,
      0,
      0.188411,
      1,
      1,
      NULL,
      0,
      1.456105,
      3.161718,
      1.800640,
      1.213263,
      1,
      1.942708,
      0,
      NULL,
      0,
      0,
      NULL,
      0.327741,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1.856775,
      3.082963,
      NULL,
      3,
      NULL,
      NULL,
      2.359331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.676381,
      1.826745,
      NULL,
      0.786831,
      1,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      18.654373,
      3,
      0.623188,
      1.951505,
      '23413',
      '',
      '',
      0.391286,
      '',
      '',
      '',
      7.051930,
      '22202',
      NULL,
      '14243');
commit;
end;
/


