set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8130151';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1986-11-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1230024',
      1,
      0.435726,
      1,
      2,
      '4102',
      2.282066,
      3.408140,
      0,
      5.230149,
      ' 7- 3-1980',
      NULL,
      NULL,
      4,
      1,
      1.156982,
      ' 2-11-2001',
      NULL,
      2.937256,
      227,
      127,
      0,
      ' 3- 4-1997',
      ' 3- 7-1999',
      NULL,
      3.712720,
      0,
      3,
      1,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      9,
      3,
      14,
      15.213910,
      1,
      20,
      NULL,
      3,
      0,
      0,
      1,
      0,
      NULL,
      1.383020,
      1.254380,
      0.467481,
      0,
      1,
      0.664896,
      1,
      2,
      2,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      NULL,
      4,
      3,
      0.223616,
      NULL,
      2,
      NULL,
      0.178480,
      0,
      3.163265,
      3,
      2.822257,
      3.497903,
      0.603216,
      NULL,
      1.195124,
      1,
      0.002120,
      NULL,
      4,
      4,
      6,
      1,
      0,
      0.367425,
      NULL,
      NULL,
      NULL,
      1.263283,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      4,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      NULL,
      4,
      5,
      3,
      0,
      2,
      3,
      0,
      5,
      4,
      NULL,
      1,
      4,
      0,
      2,
      1,
      3,
      5,
      2,
      4,
      3,
      1,
      4,
      4,
      NULL,
      5.096445,
      NULL,
      ' 9- 3-1991',
      469.212510,
      ' 3-19-1995',
      408.077912,
      3,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      1.069551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0.489519,
      1,
      3.254487,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      7,
      NULL,
      NULL,
      NULL,
      1.581072,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.395157,
      NULL,
      NULL,
      0.108489,
      1.691008,
      1.810347,
      0,
      2,
      2.065888,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.084220,
      0,
      0,
      1,
      3,
      3,
      NULL,
      3,
      NULL,
      3,
      2,
      NULL,
      2,
      1.875512,
      3.004451,
      4,
      1,
      NULL,
      NULL,
      NULL,
      0.587600,
      1.366819,
      1,
      0.127151,
      0.979429,
      1.984131,
      1,
      NULL,
      1.313665,
      3.599460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33.155438,
      2,
      NULL,
      NULL,
      29,
      42,
      28.401337,
      5,
      1.875238,
      2,
      '23243',
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      2,
      NULL,
      6.826989,
      NULL,
      0,
      29,
      2,
      1.537160,
      0,
      1,
      NULL,
      0,
      1.848021,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.726658,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0.200456,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.282791,
      NULL,
      NULL,
      11,
      NULL,
      2,
      1,
      1.702935,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.898336,
      2.486769,
      NULL,
      2,
      1.004656,
      NULL,
      2.540693,
      0.404183,
      1,
      2,
      1.079524,
      NULL,
      0,
      3,
      2,
      1,
      1.484154,
      2,
      1.288731,
      3.898836,
      NULL,
      0,
      NULL,
      NULL,
      1.118786,
      2,
      NULL,
      0,
      0,
      NULL,
      0.707939,
      3.093242,
      0,
      0.226429,
      2,
      8.809670,
      8,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.735713,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      4,
      5.180475,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      7,
      NULL,
      4,
      1,
      NULL,
      NULL,
      0.714654,
      NULL,
      NULL,
      0.178945,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.633689,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      2.399352,
      NULL,
      0.819911,
      NULL,
      NULL,
      5,
      3,
      3.293155,
      NULL,
      NULL,
      3,
      0.067926,
      NULL,
      NULL,
      3,
      0,
      2.379804,
      1,
      NULL,
      2,
      0.099913,
      1,
      1,
      NULL,
      2.349346,
      3.613095,
      3.106245,
      2,
      1,
      3.329470,
      3.931577,
      0.667506,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.765042,
      NULL,
      3,
      2,
      8.993504,
      2,
      1,
      1,
      0,
      2,
      NULL,
      1.084048,
      NULL,
      1.272166,
      0.099507,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900213,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.505689,
      NULL,
      NULL,
      0.642442,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.809893,
      NULL,
      NULL,
      2.592412,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.436795,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2.814314,
      NULL,
      NULL,
      0.951326,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.216040,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.278240,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.112427,
      NULL,
      NULL,
      NULL,
      1.485377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.490581,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      0,
      1.844869,
      NULL,
      NULL,
      NULL,
      0.521081,
      NULL,
      NULL,
      0.222972,
      1.994780,
      NULL,
      NULL,
      NULL,
      0.512496,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      12,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.818000,
      18.836130,
      3.892052,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.557019,
      NULL,
      NULL,
      0.986258,
      NULL,
      NULL,
      1,
      NULL,
      1.939415,
      14951,
      1258,
      NULL,
      1,
      0,
      1.816623,
      0.988046,
      0.644094,
      0.851771,
      0.499779,
      0.401460,
      NULL,
      1,
      1.248770,
      0,
      0.264208,
      0,
      NULL,
      1.872199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.973623,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      2,
      6,
      5,
      NULL,
      2,
      1,
      9.188613,
      2.233555,
      1,
      3,
      1.103454,
      0.355540,
      0.123020,
      0.404307,
      NULL,
      NULL,
      0.216630,
      NULL,
      2,
      0.697345,
      1.602858,
      3.198978,
      3,
      0,
      1,
      0.272823,
      0,
      3,
      NULL,
      0,
      2.845357,
      NULL,
      1.689709,
      NULL,
      0.008333,
      1.060757,
      NULL,
      0.514922,
      NULL,
      1.313748,
      1,
      3,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.347781,
      1.876218,
      1,
      1.211117,
      0.174251,
      1,
      NULL,
      0,
      6,
      NULL,
      0,
      NULL,
      38.499105,
      NULL,
      1,
      NULL,
      3.012823,
      '03140',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '',
      1.448389,
      '',
      '',
      '');
commit;
end;
/


