set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9000189';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-6-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '3232001',
      2,
      0.952396,
      0,
      0,
      NULL,
      0.043046,
      0,
      NULL,
      NULL,
      ' 6-21-1990',
      24,
      NULL,
      3,
      2.290954,
      0.260355,
      ' 6-29-1982',
      61,
      2,
      353,
      116.404493,
      NULL,
      NULL,
      NULL,
      '11-28-1983',
      NULL,
      2,
      2.696691,
      1.808600,
      NULL,
      0.118518,
      NULL,
      0,
      1,
      102,
      5,
      1,
      5,
      8,
      6.205677,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0.015893,
      NULL,
      0.453910,
      NULL,
      1,
      1,
      NULL,
      51.719135,
      1,
      3,
      3,
      0,
      2,
      0,
      0,
      NULL,
      0,
      1,
      0,
      2,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      NULL,
      3,
      0,
      0,
      0,
      1,
      NULL,
      0,
      8.091032,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      4,
      4,
      0,
      4,
      2,
      1,
      NULL,
      5,
      4,
      5,
      0,
      3,
      3,
      NULL,
      0,
      2,
      2,
      4,
      3,
      4,
      5,
      3,
      NULL,
      NULL,
      5,
      0,
      NULL,
      '11-15-1986',
      1167.235250,
      ' 0-18-1989',
      378,
      0.888714,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      1,
      0.587285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      14.414534,
      1576,
      1,
      1.296737,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.959092,
      1,
      1.666800,
      0.431105,
      0.431294,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.665646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.343652,
      NULL,
      0,
      NULL,
      0,
      2.556393,
      NULL,
      1,
      1,
      47,
      787.890906,
      754.496317,
      NULL,
      NULL,
      1,
      3,
      0,
      1,
      0,
      1,
      2,
      3,
      NULL,
      2,
      3,
      0,
      2.327598,
      0,
      3.168754,
      2.495306,
      NULL,
      3.049477,
      NULL,
      0,
      1.523352,
      0,
      1.403090,
      0,
      0,
      NULL,
      NULL,
      0.327643,
      2.287857,
      NULL,
      NULL,
      1,
      NULL,
      0.521882,
      5.697245,
      5.459906,
      0.514957,
      2.495887,
      4,
      NULL,
      0.051826,
      0.071337,
      14.391933,
      0,
      1,
      NULL,
      12,
      NULL,
      25.919520,
      1,
      NULL,
      3.669560,
      '00434',
      NULL,
      '',
      1,
      '',
      '',
      '',
      5,
      '1430',
      NULL,
      '1322',
      3.408095,
      54.483547,
      603.252241,
      0.484463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.865370,
      1.949430,
      0,
      0.178525,
      1,
      1.094225,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.492281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.424002,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.237087,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.808879,
      1,
      NULL,
      NULL,
      0.991258,
      NULL,
      NULL,
      2,
      NULL,
      1.811465,
      0,
      1.262412,
      1,
      1,
      2.242565,
      0.838316,
      0.143436,
      1,
      NULL,
      0,
      1.608112,
      0.871701,
      1.801384,
      1,
      NULL,
      NULL,
      1.389205,
      NULL,
      NULL,
      0.819407,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.101147,
      0,
      2.488680,
      1.337294,
      NULL,
      0.657489,
      2,
      2,
      2.906259,
      0.374806,
      NULL,
      NULL,
      NULL,
      0,
      3.248461,
      3.290521,
      NULL,
      0.333699,
      NULL,
      1,
      0,
      1,
      NULL,
      3,
      0.710752,
      NULL,
      NULL,
      0.701190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.739099,
      NULL,
      NULL,
      0.189913,
      NULL,
      NULL,
      0.352231,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.136956,
      NULL,
      NULL,
      5,
      0.500983,
      NULL,
      9.825490,
      4,
      4,
      0.650026,
      0.814258,
      NULL,
      3,
      1.709720,
      2,
      1,
      NULL,
      NULL,
      9,
      NULL,
      3,
      3.394291,
      2,
      2,
      0.782964,
      0.486341,
      1,
      2.470936,
      0,
      1.615176,
      1,
      2.948240,
      NULL,
      NULL,
      5,
      NULL,
      0.010500,
      NULL,
      NULL,
      1.330015,
      1,
      NULL,
      1.880986,
      NULL,
      NULL,
      0.408773,
      1.662686,
      1,
      NULL,
      NULL,
      2.337530,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.354901,
      NULL,
      NULL,
      1.280625,
      NULL,
      NULL,
      0.423077,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.666656,
      NULL,
      NULL,
      0.198334,
      NULL,
      NULL,
      0.200615,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      1.904950,
      0.157833,
      0.352107,
      0.625438,
      1.306827,
      1,
      NULL,
      NULL,
      2.046543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.270846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.186847,
      NULL,
      NULL,
      NULL,
      1.019640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.050705,
      NULL,
      NULL,
      NULL,
      1.847358,
      NULL,
      NULL,
      NULL,
      5.369602,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.185802,
      923.734357,
      1310,
      1.518110,
      NULL,
      NULL,
      NULL,
      944,
      442.776535,
      1,
      NULL,
      1864.881537,
      0,
      599.976309,
      NULL,
      0,
      127.741897,
      0,
      7389.456710,
      32.762242,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      0.443856,
      0,
      1,
      1.191376,
      0.181511,
      1,
      0,
      0,
      1,
      0.077158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.585210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      3.394363,
      1,
      2,
      1,
      1,
      NULL,
      3.984981,
      NULL,
      0,
      1,
      0,
      NULL,
      0.587710,
      0.026670,
      NULL,
      0.454943,
      2.526191,
      NULL,
      0,
      0,
      NULL,
      0.333451,
      3.228640,
      NULL,
      1,
      2.335316,
      NULL,
      3,
      1.805047,
      NULL,
      0,
      2.263320,
      NULL,
      1,
      1,
      NULL,
      0,
      2.828880,
      NULL,
      2,
      3,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.041224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.532787,
      0,
      1,
      1.792304,
      1.428817,
      0.805192,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3,
      34,
      28,
      NULL,
      0,
      0.653564,
      '11421',
      '10314',
      '',
      1.110252,
      NULL,
      '',
      '',
      0.194781,
      '3143',
      '2321',
      '2334');
commit;
end;
/


