set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6118005';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-10-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '3',
      NULL,
      NULL,
      '4141314',
      NULL,
      1,
      0,
      3,
      '0031',
      2.486498,
      3,
      2.733431,
      NULL,
      ' 4- 6-1989',
      0,
      NULL,
      5,
      0,
      1.232820,
      ' 2- 5-1975',
      72,
      3,
      NULL,
      81.916460,
      0,
      ' 7-15-1984',
      NULL,
      ' 5-27-1979',
      2.567298,
      3.590941,
      NULL,
      0.151189,
      0,
      2.413728,
      1,
      NULL,
      0,
      96.860183,
      0,
      5,
      3,
      NULL,
      NULL,
      0,
      29,
      4,
      2,
      3.930607,
      1,
      NULL,
      3,
      1,
      0,
      1.325522,
      0,
      1.737639,
      1,
      0,
      NULL,
      NULL,
      2,
      3,
      2.330823,
      2,
      0,
      1,
      5,
      NULL,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      NULL,
      2,
      1,
      0.821712,
      3.219254,
      NULL,
      2,
      NULL,
      1.301003,
      1,
      NULL,
      1,
      1,
      0,
      0,
      3.892388,
      1,
      0,
      5,
      3,
      1,
      1,
      1.420781,
      0.905196,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      0,
      0,
      5,
      1,
      0,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1.002545,
      NULL,
      1,
      NULL,
      2,
      1,
      0,
      1,
      0,
      2,
      NULL,
      0,
      2,
      3,
      1,
      1,
      0,
      3,
      2,
      4,
      1,
      1,
      2,
      0,
      1,
      0,
      4,
      0,
      NULL,
      NULL,
      ' 5-18-2001',
      1011,
      ' 6-23-1997',
      5.422916,
      0,
      0,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      0.583090,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.674835,
      1,
      0.916450,
      0.995348,
      3.473035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.368292,
      0,
      1.442894,
      1.717015,
      NULL,
      2.156949,
      28,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      3,
      2,
      NULL,
      1,
      2,
      1,
      2,
      3,
      NULL,
      3,
      1,
      3,
      7.457738,
      NULL,
      0.480976,
      6,
      0,
      1.677428,
      0,
      NULL,
      1.997154,
      0,
      NULL,
      0.614140,
      3,
      0,
      3,
      NULL,
      1.560661,
      2,
      7,
      10,
      11,
      NULL,
      NULL,
      0.375583,
      NULL,
      NULL,
      0,
      NULL,
      24,
      NULL,
      NULL,
      NULL,
      46,
      15,
      62,
      2,
      0,
      1,
      '00424',
      '',
      '',
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      12.363209,
      111.654918,
      33,
      1,
      13.672385,
      NULL,
      14.856340,
      2,
      NULL,
      13,
      0,
      NULL,
      NULL,
      NULL,
      1.947199,
      0,
      2,
      1.241327,
      2.941547,
      NULL,
      2,
      0,
      0.530285,
      1.423012,
      NULL,
      NULL,
      2,
      0.814238,
      3.967538,
      0.591137,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      0,
      1.307457,
      1.046487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.464750,
      5.178405,
      7,
      0,
      0.054875,
      NULL,
      NULL,
      NULL,
      1,
      1.680675,
      3.015286,
      1.005368,
      0.478851,
      1,
      1.282824,
      NULL,
      3,
      NULL,
      0.471960,
      NULL,
      NULL,
      1,
      NULL,
      0.872688,
      1,
      0,
      2.515772,
      NULL,
      1,
      0.641811,
      NULL,
      1,
      NULL,
      3.886517,
      0,
      NULL,
      0,
      2.005443,
      0,
      1,
      0.049492,
      NULL,
      NULL,
      3,
      NULL,
      0.531233,
      NULL,
      4.061776,
      6.325909,
      1,
      1.729061,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.633260,
      0.934486,
      NULL,
      3.969539,
      1.944496,
      3,
      14,
      NULL,
      3.969220,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      0.320495,
      NULL,
      1.768412,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.447920,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.311044,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.361184,
      NULL,
      NULL,
      1.856811,
      NULL,
      NULL,
      0,
      2.212146,
      1.382300,
      2.615649,
      1.950254,
      0.111309,
      8.111453,
      3.130196,
      NULL,
      11.936800,
      7.361813,
      7.237662,
      2.572909,
      NULL,
      NULL,
      3.509109,
      1.326267,
      1.763119,
      0.721882,
      NULL,
      0,
      0,
      1,
      3,
      9,
      1,
      NULL,
      0,
      3,
      1,
      3.964236,
      2.302085,
      1.936710,
      0.272324,
      NULL,
      NULL,
      1.638267,
      3.929567,
      0.529133,
      3.300050,
      0.895733,
      7,
      2.763838,
      5.810301,
      2.595598,
      NULL,
      NULL,
      NULL,
      1.396988,
      NULL,
      1,
      1.519136,
      1,
      0.363910,
      NULL,
      NULL,
      5.090091,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.148342,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.132219,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.477575,
      NULL,
      NULL,
      1.885526,
      NULL,
      NULL,
      1.767840,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.338615,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.179934,
      1,
      3,
      1.242155,
      2.105492,
      3.255449,
      NULL,
      NULL,
      NULL,
      5.326350,
      2,
      NULL,
      24.251970,
      3,
      NULL,
      NULL,
      1.982332,
      1.572901,
      0.540253,
      NULL,
      NULL,
      2,
      0.721366,
      NULL,
      2.520732,
      1.761879,
      NULL,
      NULL,
      1.752582,
      NULL,
      0,
      NULL,
      3,
      NULL,
      3.178934,
      NULL,
      2,
      NULL,
      0.995138,
      NULL,
      NULL,
      1.416474,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      1.851045,
      1.337545,
      NULL,
      1,
      3.309531,
      2.467310,
      NULL,
      1.656508,
      0,
      3,
      NULL,
      0.663858,
      1,
      1,
      NULL,
      1.162910,
      NULL,
      NULL,
      NULL,
      0.554111,
      1.425266,
      3.521120,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.529200,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      7,
      6.311614,
      5,
      NULL,
      0,
      2,
      4,
      9,
      0,
      2.320589,
      NULL,
      13,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.070663,
      9,
      1,
      2,
      11,
      3.007477,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.751160,
      97.133092,
      NULL,
      1.956264,
      2.978277,
      0.325594,
      1.994886,
      NULL,
      0.077026,
      1,
      1.364716,
      1.447453,
      1,
      NULL,
      1,
      1,
      1.247937,
      0,
      1.493361,
      0.256736,
      1,
      NULL,
      0.710858,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.575602,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.748812,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.660125,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.426914,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.256685,
      0,
      1.417548,
      NULL,
      0.999974,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.442139,
      NULL,
      NULL,
      1,
      1.117776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.599134,
      0,
      3.137701,
      0,
      1,
      0,
      1,
      0,
      NULL,
      1.122856,
      1,
      NULL,
      1.880647,
      1,
      NULL,
      NULL,
      1.133214,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.722275,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.470461,
      3.938947,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.342337,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.408233,
      NULL,
      1.877595,
      NULL,
      1.106634,
      NULL,
      2,
      6,
      NULL,
      2,
      1.046919,
      3,
      42.504373,
      63,
      3,
      0.660834,
      0,
      '30412',
      '',
      '',
      1.433810,
      NULL,
      NULL,
      '',
      0.317838,
      '',
      '',
      NULL);
commit;
end;
/


