set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5607545';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1986-10-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      NULL,
      '4111232',
      NULL,
      NULL,
      3,
      0,
      '2230',
      0.124447,
      NULL,
      3.069199,
      NULL,
      ' 9-14-1975',
      NULL,
      NULL,
      5,
      NULL,
      0.489274,
      ' 9-24-2003',
      20.749526,
      3,
      262,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-18-1988',
      NULL,
      0.981731,
      0,
      0,
      1.339332,
      1,
      0,
      3.816872,
      NULL,
      NULL,
      NULL,
      4.436700,
      0.428721,
      0,
      NULL,
      5,
      0.550364,
      4,
      1,
      3.088139,
      1,
      3,
      0,
      NULL,
      1.624631,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      3,
      0,
      0.568871,
      5,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      2,
      0,
      0,
      3.031627,
      0,
      2,
      1,
      0,
      0.936232,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.497893,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1.597969,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      1,
      1,
      3,
      0,
      2,
      1,
      1,
      5,
      4,
      2,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.270698,
      2,
      4.799228,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.428300,
      NULL,
      1,
      0,
      1.319579,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.620037,
      1,
      NULL,
      0,
      3,
      3,
      NULL,
      2,
      NULL,
      NULL,
      2,
      3,
      1.520512,
      2,
      0,
      1.823577,
      1,
      NULL,
      2,
      1.093107,
      0.605486,
      0,
      0.687235,
      0.209100,
      1.236877,
      1.969327,
      0,
      1,
      0,
      3.814520,
      0.288829,
      7,
      6,
      4.008860,
      NULL,
      NULL,
      6.372657,
      0.505714,
      2.682188,
      7,
      0,
      NULL,
      0.070932,
      6.354878,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '30240',
      NULL,
      '',
      0.726326,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.448273,
      2,
      NULL,
      NULL,
      2,
      7.361996,
      1.543667,
      3,
      1,
      0,
      3,
      NULL,
      0.802074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.729043,
      1.937767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.143156,
      0.444211,
      3,
      0.549675,
      1,
      0,
      1,
      NULL,
      NULL,
      1.058404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.800203,
      NULL,
      NULL,
      7,
      6.802350,
      3,
      1,
      0.784269,
      NULL,
      NULL,
      NULL,
      1.987687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.088630,
      2,
      0.336905,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.120747,
      0.435803,
      3.287730,
      1,
      NULL,
      2.153255,
      1.365249,
      1.373073,
      1.941097,
      2,
      0,
      1,
      1.758534,
      0,
      NULL,
      NULL,
      0,
      2.432528,
      1.428371,
      1,
      NULL,
      NULL,
      2.559305,
      7.815282,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.573057,
      NULL,
      NULL,
      NULL,
      1.161547,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.918306,
      NULL,
      1.341415,
      0.238332,
      NULL,
      NULL,
      3.630875,
      0.044367,
      0.714024,
      1.891606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.936202,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.166301,
      NULL,
      NULL,
      2,
      2.782754,
      3.141197,
      3,
      NULL,
      2,
      NULL,
      6.992737,
      NULL,
      0.417529,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.865537,
      2,
      1,
      1.521785,
      0,
      0.191255,
      1,
      NULL,
      NULL,
      1,
      4.915649,
      NULL,
      NULL,
      3,
      1.162896,
      1.105338,
      0.096794,
      1,
      0.386586,
      0.799737,
      1,
      1.394955,
      2.090799,
      NULL,
      5.450590,
      4.380240,
      7.281016,
      7.201022,
      6,
      1.292930,
      3.465100,
      3,
      1,
      0,
      NULL,
      1.087116,
      1,
      0.331341,
      2.693489,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.806751,
      NULL,
      NULL,
      1.058755,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.345528,
      NULL,
      NULL,
      1.880444,
      0.150552,
      0.643305,
      1.093181,
      0.603984,
      2,
      1.842698,
      NULL,
      NULL,
      NULL,
      2.280990,
      NULL,
      NULL,
      1.838018,
      NULL,
      NULL,
      NULL,
      2.213220,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.530430,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937255,
      1.249351,
      NULL,
      NULL,
      1.287127,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.996276,
      NULL,
      NULL,
      0.847788,
      1,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.428984,
      NULL,
      1,
      0.022725,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.256337,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980888,
      NULL,
      NULL,
      14497,
      1129.419518,
      1,
      1,
      1,
      1,
      1.679791,
      0,
      0.137779,
      1.720702,
      1,
      1,
      1.394316,
      1,
      0,
      1,
      1,
      0.219775,
      NULL,
      3.148269,
      NULL,
      1.468163,
      NULL,
      0.716520,
      NULL,
      0.617623,
      NULL,
      1.674142,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.268721,
      1.936942,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.397725,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.780194,
      1.219224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.725035,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.021647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.490293,
      NULL,
      3.230192,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.982938,
      0,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      9.899555,
      2,
      4.811801,
      1,
      3,
      5.094479,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1.453487,
      NULL,
      NULL,
      2,
      13.060155,
      12.495944,
      5.338953,
      17.660367,
      3.218640,
      11.234313,
      10.045995,
      0.206571,
      6.060873,
      16.753284,
      0,
      3,
      0,
      3.785522,
      0.112379,
      NULL,
      17.513927,
      2,
      0.969725,
      NULL,
      1.868729,
      1,
      0.292891,
      0,
      1.944164,
      0,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1.466688,
      0,
      0.735764,
      1.573928,
      NULL,
      2,
      0,
      1,
      NULL,
      1,
      1,
      0,
      2.536413,
      0,
      2,
      NULL,
      NULL,
      NULL,
      2.294985,
      3,
      1,
      0,
      0.098331,
      80,
      NULL,
      NULL,
      NULL,
      1.560673,
      NULL,
      2,
      1,
      1,
      1,
      6,
      3,
      2,
      NULL,
      0.581701,
      59,
      69,
      4,
      0.943081,
      5.565871,
      NULL,
      NULL,
      '',
      1.523637,
      NULL,
      '',
      '',
      1,
      NULL,
      NULL,
      '');
commit;
end;
/


