set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5607545';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '01',
      '42',
      4.650430,
      26,
      '1203104',
      3,
      0.086064,
      2,
      2,
      '0332',
      4.033653,
      0,
      NULL,
      NULL,
      ' 2-10-2000',
      4.784209,
      23,
      NULL,
      0.018785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      '11-24-1980',
      NULL,
      1,
      2.988112,
      0.241890,
      0,
      1.311030,
      0,
      2,
      NULL,
      NULL,
      NULL,
      10.503716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      1.048309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      5,
      2.612255,
      0,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.143561,
      1.264750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      2,
      0,
      2,
      2,
      0,
      4,
      NULL,
      NULL,
      5,
      0,
      0,
      1,
      0,
      0,
      3,
      1,
      0,
      0,
      1,
      4,
      1,
      1,
      0.292646,
      0.502077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      1,
      0,
      0.503816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.444436,
      NULL,
      2.786041,
      1.559047,
      0.822388,
      0.602953,
      NULL,
      NULL,
      NULL,
      NULL,
      0.549151,
      0.401467,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.665287,
      3.929894,
      0,
      NULL,
      NULL,
      1.497284,
      1.175851,
      1,
      NULL,
      0,
      3.030256,
      NULL,
      NULL,
      NULL,
      0,
      1.784119,
      3,
      1,
      3,
      NULL,
      3,
      1,
      NULL,
      2,
      0,
      0,
      1,
      3.955043,
      0.752735,
      1,
      NULL,
      0,
      1.420312,
      3,
      1.858403,
      0,
      NULL,
      1,
      1.367221,
      0.185970,
      1.614681,
      1,
      1,
      1.641333,
      3.622113,
      NULL,
      1.335220,
      1,
      2,
      2,
      1,
      NULL,
      NULL,
      1,
      6.163609,
      2.072633,
      2.856877,
      NULL,
      24,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      '13401',
      '',
      '',
      1,
      '',
      NULL,
      '',
      2.830081,
      '4440',
      '',
      '',
      NULL,
      17,
      491,
      15,
      0,
      30.443459,
      3,
      NULL,
      1,
      2,
      3.936063,
      0.254038,
      0,
      NULL,
      NULL,
      0.627315,
      NULL,
      NULL,
      NULL,
      1.855596,
      NULL,
      0.496983,
      0,
      1,
      3.881829,
      2,
      0.836491,
      1,
      1.121600,
      0.966638,
      0,
      1.791938,
      1,
      2,
      3,
      1,
      2.054260,
      NULL,
      NULL,
      0.265355,
      NULL,
      NULL,
      0.587737,
      1,
      1,
      11.846553,
      9.096054,
      7,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.120992,
      1.165710,
      2,
      0,
      1.269198,
      1.943979,
      3.828053,
      1,
      0,
      2.376014,
      0.071432,
      1,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      2.968194,
      NULL,
      1.999142,
      NULL,
      NULL,
      1.162190,
      3.426960,
      1.327111,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.878393,
      NULL,
      NULL,
      10.126075,
      8.399395,
      6.406050,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.452560,
      NULL,
      NULL,
      NULL,
      0.937364,
      NULL,
      NULL,
      3,
      1.719235,
      0,
      0,
      NULL,
      NULL,
      0.872887,
      NULL,
      NULL,
      NULL,
      6.783071,
      0.721942,
      0.067649,
      3.371807,
      1,
      1,
      NULL,
      NULL,
      5.199834,
      7,
      0.511447,
      0.305803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.315016,
      NULL,
      NULL,
      0,
      0,
      1,
      0.713768,
      NULL,
      NULL,
      3.037929,
      1,
      4,
      4.703094,
      0.628682,
      2,
      2.358124,
      NULL,
      NULL,
      3.789574,
      0,
      1.657491,
      0,
      NULL,
      3,
      3,
      1,
      0,
      4.060528,
      8.930659,
      0,
      0.037946,
      2.693104,
      1,
      NULL,
      NULL,
      2.226054,
      1,
      NULL,
      NULL,
      1,
      2,
      1.106566,
      3,
      6.124706,
      NULL,
      3,
      NULL,
      NULL,
      0,
      3,
      0,
      0,
      1,
      0,
      0,
      0.182378,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.479361,
      NULL,
      NULL,
      0.569641,
      NULL,
      NULL,
      1.671530,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.820267,
      NULL,
      NULL,
      2,
      2.173309,
      NULL,
      1.033741,
      0.358314,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.292959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.736362,
      NULL,
      NULL,
      1.724361,
      0.559739,
      NULL,
      NULL,
      NULL,
      1.814528,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.484686,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1.377196,
      0.082961,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3.850051,
      NULL,
      NULL,
      0.379618,
      1,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.086246,
      NULL,
      NULL,
      NULL,
      2.055158,
      5,
      22,
      2,
      40,
      2168,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1669,
      3,
      22,
      6526,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      39.928142,
      0,
      1,
      0,
      0,
      1,
      0.889470,
      0.390716,
      0.798800,
      0,
      1.266746,
      0,
      0.991953,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.920522,
      NULL,
      0.485077,
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      3.274478,
      NULL,
      55,
      1.416709,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.893815,
      NULL,
      0.786984,
      NULL,
      NULL,
      NULL,
      1.972432,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.707843,
      NULL,
      0.694196,
      NULL,
      0,
      NULL,
      0.644051,
      NULL,
      NULL,
      NULL,
      1.025872,
      1,
      0.151569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.568374,
      1.828214,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.222632,
      0.734844,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.971620,
      NULL,
      3,
      NULL,
      1.285979,
      NULL,
      152.546254,
      NULL,
      3,
      NULL,
      1,
      NULL,
      1,
      0,
      3,
      27.339078,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      2.810817,
      NULL,
      0.548946,
      NULL,
      NULL,
      1.893965,
      NULL,
      0,
      1,
      0.464074,
      1,
      0.289356,
      1.187637,
      0,
      1,
      1,
      1.286491,
      0,
      3.314966,
      1,
      3.970512,
      1,
      0,
      NULL,
      2.625317,
      NULL,
      0.510327,
      NULL,
      1,
      NULL,
      NULL,
      0.465567,
      NULL,
      0.701082,
      NULL,
      0,
      0.405993,
      1.956484,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.762663,
      1,
      0.534685,
      0.963794,
      0.368254,
      1,
      1.123473,
      1.406430,
      3.412910,
      NULL,
      NULL,
      1,
      3,
      0,
      2,
      NULL,
      1,
      1,
      1,
      3.183128,
      3.937350,
      0,
      0.977091,
      2,
      1,
      0,
      1,
      NULL,
      NULL,
      79.122538,
      1,
      NULL,
      3.919922,
      0.604469,
      1.594134,
      1.690289,
      2,
      3,
      NULL,
      0.667504,
      0,
      3,
      45.350426,
      38,
      4,
      NULL,
      1,
      '31304',
      '30344',
      '',
      1.008212,
      '',
      '',
      '',
      1.352826,
      '0011',
      '',
      '');
commit;
end;
/


